<?php
/*
  Plugin Name: WP Contact Widget
  Plugin URI: https://mythemeshop.com/plugins/wp-contact-widget/
  Description: WP Contact Widget is a plugin designed to easily help you add a contact form to your website anywhere you can place a widget, and help your users get in touch with you.
  Text Domain: wp_contact_widget
  Author: MyThemeShop
  Author URI: https://mythemeshop.com/
  Version: 1.0.3
 */

define('WPCW_PLUGIN_SELF_DIRNAME', basename(dirname(__FILE__)), true);
if (!defined('WPCW_PLUGIN_BASE_DIR')) {
    define('WPCW_PLUGIN_BASE_DIR', WP_PLUGIN_DIR . '/' . WPCW_PLUGIN_SELF_DIRNAME, true);
}

add_action('plugins_loaded', 'wpcw_load_textdomain');
function wpcw_load_textdomain() {
    load_plugin_textdomain( 'wp_contact_widget', false, dirname( plugin_basename(__FILE__) ) . '/languages/' );
}

add_action("widgets_init", array('WP_Contact_Widget', 'register'));

add_action('wp_ajax_wpcw_send_mail', 'wpcw_send_mail');
add_action('wp_ajax_nopriv_wpcw_send_mail', 'wpcw_send_mail');

add_action('wp_ajax_wpcw_get_mailchimp_lists', 'wpcw_get_mailchimp_lists');
add_action('wp_ajax_wpcw_get_getresponse_lists', 'wpcw_get_getresponse_lists');
add_action('wp_ajax_wpcw_get_aweber_lists', 'wpcw_get_aweber_lists' );

function wpcw_send_mail() {
    parse_str($_POST['data'], $_POST);
    require_once( rtrim(dirname(__FILE__), '/') . '/scripts/ajax.php' );
    die;
}

/**
 * Get all MailChimp Lists and display in settings
 *
 */
function wpcw_get_mailchimp_lists() {

    $options = '';

    if (isset($_POST['api_key']) && $_POST['api_key'] != '') {

        require_once WPCW_PLUGIN_BASE_DIR . '/scripts/mailchimp/MailChimp.php';
        $MailChimp = new WPS_MailChimp($_POST['api_key']);
        $lists = $MailChimp->call('lists/list');

        if (isset($lists) && is_array($lists)) {

            foreach ($lists['data'] as $list) {
                $options .= '<option value="' . $list['id'] . '">' . $list['name'] . '</option>';
            }

            if (isset($_POST['list']) && $_POST['list'] != '') {
                $options = '';
                foreach ($lists['data'] as $list) {

                    if ($_POST['list'] == $list['id']) {
                        $options .= '<option value="' . $list['id'] . '" selected="selected">' . $list['name'] . '</option>';
                    } else {
                        $options .= '<option value="' . $list['id'] . '">' . $list['name'] . '</option>';
                    }
                }
            }
        }
    }

    echo $options;

    die(); // this is required to terminate immediately and return a proper response
}

/**
 * Get all Get Response Lists and display in settings
 *
 */
function wpcw_get_getresponse_lists() {

    $options = '';

    if (isset($_POST['api_key']) && $_POST['api_key'] != '') {

        require_once WPCW_PLUGIN_BASE_DIR . '/scripts/getresponse/jsonRPCClient.php';
        $api = new jsonRPCClient('http://api2.getresponse.com');

        try {
            $result = $api->get_campaigns(trim($_POST['api_key']));
            foreach ((array) $result as $k => $v) {
                $campaigns[] = array('id' => $k, 'name' => $v['name']);
            }
        } catch (Exception $e) {
            
        }

        if (isset($campaigns) && is_array($campaigns)) {

            foreach ($campaigns as $campaign) {
                $options .= '<option value="' . $campaign['id'] . '">' . $campaign['name'] . '</option>';
            }

            if (isset($_POST['campaign']) && $_POST['campaign'] != '') {
                $options = '';
                foreach ($campaigns as $campaign) {

                    if ($_POST['campaign'] == $campaign['id']) {
                        $options .= '<option value="' . $campaign['id'] . '" selected="selected">' . $campaign['name'] . '</option>';
                    } else {
                        $options .= '<option value="' . $campaign['id'] . '">' . $campaign['name'] . '</option>';
                    }
                }
            }
        }
    }

    echo $options;

    die(); // this is required to terminate immediately and return a proper response
}

/**
 * Get the Aweber lists for an account
 *
 */
function wpcw_get_aweber_lists() {

    $options = '';
    $consumerKey = '';
    $consumerSecret = '';
    $accessKey = '';
    $accessSecret = '';

    if (isset($_POST['code']) && $_POST['code'] != '') {

        require_once( WPCW_PLUGIN_BASE_DIR . 'scripts/aweber/aweber_api.php');

        try {
            $credentials = AWeberAPI::getDataFromAweberID($_POST['code']);
            list($consumerKey, $consumerSecret, $accessKey, $accessSecret) = $credentials;


            $consumerKey = isset($consumerKey) && !empty($consumerKey) ? $consumerKey : '';
            $consumerSecret = isset($consumerSecret) && !empty($consumerSecret) ? $consumerSecret : '';
            $accessKey = isset($accessKey) && !empty($accessKey) ? $accessKey : '';
            $accessSecret = isset($accessSecret) && !empty($accessSecret) ? $accessSecret : '';
        } catch (AWeberAPIException $exc) {
            error_log($exc);
        }

        try {

            $aweber = new AWeberAPI($consumerKey, $consumerSecret);
            $account = $aweber->getAccount($accessKey, $accessSecret);
            $lists = $account->loadFromUrl('/accounts/' . $account->id . '/lists/');

            foreach ($lists as $list) {
                $options .= '<option value="' . $list->id . '">' .  $list->name . '</option>';
            }

        } catch (AWeberAPIException $exc) { error_log($exc); }
    }

    if (isset($_POST['list']) && $_POST['list'] != '') {

        $consumerKey     = $_POST['consumer_key'];
        $consumerSecret  = $_POST['consumer_secret'];
        $accessKey       = $_POST['access_key'];
        $accessSecret    = $_POST['access_secret'];

        require_once( WPCW_PLUGIN_BASE_DIR . 'includes/aweber/aweber_api.php');

        try {

            $aweber = new AWeberAPI($consumerKey, $consumerSecret);
            $account = $aweber->getAccount($accessKey, $accessSecret);
            $lists = $account->loadFromUrl('/accounts/' . $account->id . '/lists/');

            $options = '';
            foreach ($lists as $list) {
                if ($_POST['list'] == $list->id) {
                    $options .= '<option value="' . $list->id . '" selected="selected">' .  $list->name . '</option>';
                } else {
                    $options .= '<option value="' . $list->id . '">' .  $list->name . '</option>';
                }
            }

        } catch (AWeberAPIException $exc) { error_log($exc); }
    }

    echo json_encode(array(
        'html'               => $options,
        'consumer_key'       => $consumerKey,
        'consumer_secret'    => $consumerSecret,
        'access_key'         => $accessKey,
        'access_secret'      => $accessSecret,
    ));

    die(); // this is required to terminate immediately and return a proper response
}


/**
 * Widget Class
 */
class WP_Contact_Widget extends WP_Widget {

    public function __construct() {

        $widget_ops = array('classname' => __CLASS__, 'description' => __('WP Contact Widget', 'wp_contact_widget'));
        parent::__construct(__CLASS__, __('WP Contact Widget', 'wp_contact_widget'), $widget_ops);

        add_action( 'admin_enqueue_scripts', array( $this, 'admin_load_scripts' ) );
        add_action( 'customize_controls_enqueue_scripts', array( $this, 'admin_load_scripts' ) );
        if (!is_admin()) {
            add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_frontend_dependencies' ) );
        }

        $this->default_options = array(
            'wp_contact_widget_widget_title' => __('Contact Us', 'wp_contact_widget'),
            'wp_contact_widget_name_label' => __('Name', 'wp_contact_widget'),
            'wp_contact_widget_subject_label' => __('Subject', 'wp_contact_widget'),
            'wp_contact_widget_from_label' => __('Email', 'wp_contact_widget'),
            'wp_contact_widget_phone_label' => __('Phone', 'wp_contact_widget'),
            'wp_contact_widget_consent_label' => __('I consent to my submitted data being collected via this form', 'wp_contact_widget'),
            'wp_contact_widget_message_label' => __('Message', 'wp_contact_widget'),
            'wp_contact_widget_delivered_to_mail' => get_option('admin_email'),
            'wp_contact_widget_submit_label' => __('Send Message', 'wp_contact_widget'),
            'wp_contact_widget_success_message' => __('Mail sent!', 'wp_contact_widget'),
            'wp_contact_widget_newsletter_subscribe' => '',
            'wp_contact_widget_subscribe_label' => __('Subscribe to Newsletter', 'wp_contact_widget'),
            'wp_contact_widget_custom_fields' => array(),
            'wp_contact_widget_text_before' => '',
            'wp_contact_widget_text_after' => '',
            'wp_contact_widget_custom_css' => '',
            'wp_contact_widget_captcha' => 'on',
            'wp_contact_widget_refresh_message' => __('Click to refresh', 'wp_contact_widget'),
            'wp_contact_widget_refresh_link' => __('Reload Captcha', 'wp_contact_widget'),
            'wp_contact_widget_response_field' => __('Type the characters you see in image above', 'wp_contact_widget'),
            'wp_contact_widget_public_key' => '',
            'wp_contact_widget_private_key' => '',
            'wp_contact_widget_recaptcha_theme' => 'light',
            'wp_contact_widget_fields_order' => 'name#|%email#|%subject#|%phone#|%message#|%consent',
            'subscription_service' => '',
            'getresponse_api_key' => '',
            'getresponse_campaign' => '',
            'mailchimp_api_key' => '',
            'mailchimp_list_id' => '',
            'aweber_auth_code' => '',
            'aweber_list_id' => '',
            'aweber_consumer_key' => '',
            'aweber_consumer_secret' => '',
            'aweber_access_key' => '',
            'aweber_access_secret' => '',
        );
    }

    function enqueue_frontend_dependencies() {
        if ( is_active_widget( false, false, $this->id_base, true ) ) {
            wp_enqueue_script( 'wp-contact-widget', plugins_url( '/scripts/js/global.js', __FILE__ ), array('jquery') );
            wp_localize_script(
                'wp-contact-widget',
                'wp_contact_widget',
                array(
                    'ajax_url' => admin_url( 'admin-ajax.php' )
                )
            );
            wp_enqueue_style( 'wp-contact-widget', plugins_url( '/style.css', __FILE__ ) );
        }
    }

    function admin_load_scripts() {
        $screen = get_current_screen();
        $screen_id = $screen->id;
        $current_filter = current_filter();
        if ( 'widgets' === $screen_id || 'customize_controls_enqueue_scripts' === $current_filter ) {
            wp_enqueue_script( 'wp_contact_widget-admin', plugins_url( '/scripts/js/admin.js', __FILE__ ), array( 'jquery', 'jquery-ui-core', 'jquery-ui-sortable' ) );
            wp_enqueue_style( 'wp_contact_widget-admin', plugins_url( '/scripts/css/admin.css', __FILE__ ) );
        }
    }

    public static function register() {
        register_widget(__CLASS__);
    }

    public static function get_instance_data($instance_id) {
        $instances = get_option('widget_' . __CLASS__);
        $data = isset($instances[$instance_id]) ? $instances[$instance_id] : array();

        return $data;
    }

    public function form($instance) {

        $wp_contact_widget_widget_title = isset($instance['wp_contact_widget_widget_title']) ? $instance['wp_contact_widget_widget_title'] : $this->default_options['wp_contact_widget_widget_title'];

        $wp_contact_widget_name_enable = (isset($instance['wp_contact_widget_name_enable']) && (!empty($instance['wp_contact_widget_name_enable']) )) ? 'checked="checked"' : '';
        $wp_contact_widget_name_label = isset($instance['wp_contact_widget_name_label']) ? $instance['wp_contact_widget_name_label'] : $this->default_options['wp_contact_widget_name_label'];

        $wp_contact_widget_from_label = isset($instance['wp_contact_widget_from_label']) ? $instance['wp_contact_widget_from_label'] : $this->default_options['wp_contact_widget_from_label'];

        $wp_contact_widget_subject_enable = (isset($instance['wp_contact_widget_subject_enable']) && (!empty($instance['wp_contact_widget_subject_enable']) )) ? 'checked="checked"' : '';
        $wp_contact_widget_subject_label = isset($instance['wp_contact_widget_subject_label']) ? $instance['wp_contact_widget_subject_label'] : $this->default_options['wp_contact_widget_subject_label'];

        $wp_contact_widget_phone_enable = (isset($instance['wp_contact_widget_phone_enable']) && (!empty($instance['wp_contact_widget_phone_enable']) )) ? 'checked="checked"' : '';
        $wp_contact_widget_phone_label = isset($instance['wp_contact_widget_phone_label']) ? $instance['wp_contact_widget_phone_label'] : $this->default_options['wp_contact_widget_phone_label'];

        $wp_contact_widget_consent_enable = (isset($instance['wp_contact_widget_consent_enable']) && (!empty($instance['wp_contact_widget_consent_enable']) )) ? 'checked="checked"' : '';
        $wp_contact_widget_consent_label = isset($instance['wp_contact_widget_consent_label']) ? $instance['wp_contact_widget_consent_label'] : $this->default_options['wp_contact_widget_consent_label'];

        $wp_contact_widget_message_enable = (isset($instance['wp_contact_widget_message_enable']) && (!empty($instance['wp_contact_widget_message_enable']) )) ? 'checked="checked"' : '';
        $wp_contact_widget_message_label = isset($instance['wp_contact_widget_message_label']) ? $instance['wp_contact_widget_message_label'] : $this->default_options['wp_contact_widget_message_label'];

        $wp_contact_widget_delivered_to_mail = isset($instance['wp_contact_widget_delivered_to_mail']) ? $instance['wp_contact_widget_delivered_to_mail'] : $this->default_options['wp_contact_widget_delivered_to_mail'];

        $wp_contact_widget_submit_label = !empty($instance['wp_contact_widget_submit_label']) ? $instance['wp_contact_widget_submit_label'] : $this->default_options['wp_contact_widget_submit_label'];
        $wp_contact_widget_success_message = !empty($instance['wp_contact_widget_success_message']) ? $instance['wp_contact_widget_success_message'] : $this->default_options['wp_contact_widget_success_message'];

        $wp_contact_widget_newsletter_subscribe = (isset($instance['wp_contact_widget_newsletter_subscribe']) && (!empty($instance['wp_contact_widget_newsletter_subscribe']) )) ? 'checked="checked"' : '';
        $wp_contact_widget_subscribe_label = !empty($instance['wp_contact_widget_subscribe_label']) ? $instance['wp_contact_widget_subscribe_label'] : $this->default_options['wp_contact_widget_subscribe_label'];

        $wp_contact_widget_text_before = !empty($instance['wp_contact_widget_text_before']) ? $instance['wp_contact_widget_text_before'] : $this->default_options['wp_contact_widget_text_before'];
        $wp_contact_widget_text_after = !empty($instance['wp_contact_widget_text_after']) ? $instance['wp_contact_widget_text_after'] : $this->default_options['wp_contact_widget_text_after'];

        $wp_contact_widget_custom_css = !empty($instance['wp_contact_widget_custom_css']) ? $instance['wp_contact_widget_custom_css'] : $this->default_options['wp_contact_widget_custom_css'];

        $wp_contact_widget_captcha = (isset($instance['wp_contact_widget_captcha']) && (!empty($instance['wp_contact_widget_captcha']) )) ? 'checked="checked"' : '';

        $wp_contact_widget_public_key = !empty($instance['wp_contact_widget_public_key']) ? $instance['wp_contact_widget_public_key'] : $this->default_options['wp_contact_widget_public_key'];
        $wp_contact_widget_private_key = !empty($instance['wp_contact_widget_private_key']) ? $instance['wp_contact_widget_private_key'] : $this->default_options['wp_contact_widget_private_key'];

        $wp_contact_widget_recaptcha_theme = !empty($instance['wp_contact_widget_recaptcha_theme']) ? $instance['wp_contact_widget_recaptcha_theme'] : $this->default_options['wp_contact_widget_recaptcha_theme'];

        $subscription_service = !empty($instance['subscription_service']) ? $instance['subscription_service'] : $this->default_options['subscription_service'];

        $getresponse_api_key = !empty($instance['getresponse_api_key']) ? $instance['getresponse_api_key'] : $this->default_options['getresponse_api_key'];
        $getresponse_campaign = !empty($instance['getresponse_campaign']) ? $instance['getresponse_campaign'] : $this->default_options['getresponse_campaign'];

        $mailchimp_api_key = !empty($instance['mailchimp_api_key']) ? $instance['mailchimp_api_key'] : $this->default_options['mailchimp_api_key'];
        $mailchimp_list_id = !empty($instance['mailchimp_list_id']) ? $instance['mailchimp_list_id'] : $this->default_options['mailchimp_list_id'];

        $aweber_consumer_key = !empty($instance['aweber_consumer_key']) ? $instance['aweber_consumer_key'] : $this->default_options['aweber_consumer_key'];
        $aweber_consumer_secret = !empty($instance['aweber_consumer_secret']) ? $instance['aweber_consumer_secret'] : $this->default_options['aweber_consumer_secret'];
        $aweber_access_key = !empty($instance['aweber_access_key']) ? $instance['aweber_access_key'] : $this->default_options['aweber_access_key'];
        $aweber_access_secret = !empty($instance['aweber_access_secret']) ? $instance['aweber_access_secret'] : $this->default_options['aweber_access_secret'];
        $aweber_auth_code = !empty($instance['aweber_auth_code']) ? $instance['aweber_auth_code'] : $this->default_options['aweber_auth_code'];
        $aweber_list_id = !empty($instance['aweber_list_id']) ? $instance['aweber_list_id'] : $this->default_options['aweber_list_id'];

        $wp_contact_widget_fields_order = !empty($instance['wp_contact_widget_fields_order']) ? explode( '#|%', $instance['wp_contact_widget_fields_order'] ) : explode( '#|%', $this->default_options['wp_contact_widget_fields_order'] );
        
        ?>
        <div class="wp-contact-widget-inside">
            <p>
                <label for="<?php echo $this->get_field_id('wp_contact_widget_widget_title'); ?>"><?php _e('Widget title:', 'wp_contact_widget'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('wp_contact_widget_widget_title'); ?>" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_widget_title'); ?>" value="<?php echo esc_attr($wp_contact_widget_widget_title); ?>"/>
            </p>
            <input id="<?php echo $this->get_field_id('wp_contact_widget_fields_order'); ?>" class="wpcw_order" type="hidden" name="<?php echo $this->get_field_name('wp_contact_widget_fields_order'); ?>" value="<?php echo implode( '#|%', $wp_contact_widget_fields_order ); ?>"/>
            <div class="wpcw-form-items">
                <?php
                foreach ( $wp_contact_widget_fields_order as $field ) {
                    switch ( $field ) {
                        case 'email':
                            ?>
                            <div class="wpcw-form-item" data-label="email">
                                <div class="wpcw-sort-header">
                                    <strong class="wpcw-custom-field-label"><?php _e('Email field', 'wp_contact_widget');?></strong>
                                    <span class="wpcw-sort-handle" style="float:right;"><i class="dashicons dashicons-sort"></i></span>
                                </div>
                                <div class="wpcw-sort-content">
                                    <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_from_label'); ?>"><?php _e('Email label:', 'wp_contact_widget'); ?></label></strong><br/>
                                    <input id="<?php echo $this->get_field_id('wp_contact_widget_from_label'); ?>" class="widefat" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_from_label'); ?>" value="<?php echo esc_attr($wp_contact_widget_from_label); ?>"/>
                                </div>
                            </div>
                            <?php
                        break;
                        case 'name':
                            ?>
                            <div class="wpcw-form-item" data-label="name">
                                <div class="wpcw-sort-header">
                                    <input type="checkbox" class="wpcw-checkbox-toggle" id="<?php echo $this->get_field_id('wp_contact_widget_name_enable'); ?>" name="<?php echo $this->get_field_name('wp_contact_widget_name_enable'); ?>" <?php echo $wp_contact_widget_name_enable; ?> />
                                    <strong>&nbsp;<label for="<?php echo $this->get_field_id('wp_contact_widget_name_enable'); ?>"><?php _e('Enable Name field', 'wp_contact_widget'); ?></label></strong>
                                    <span class="wpcw-sort-handle" style="float:right;"><i class="dashicons dashicons-sort"></i></span>
                                </div>
                                <div class="wpcw-sort-content <?php if ( !empty( $wp_contact_widget_name_enable ) ) echo 'active'?>" data-checkbox="<?php echo $this->get_field_id('wp_contact_widget_name_enable'); ?>">
                                    <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_name_label'); ?>"><?php _e('Name label', 'wp_contact_widget'); ?></label></strong><br/>
                                    <input class="widefat"  id="<?php echo $this->get_field_id('wp_contact_widget_name_label'); ?>" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_name_label'); ?>" value="<?php echo esc_attr($wp_contact_widget_name_label); ?>"/>
                                </div>
                            </div>
                            <?php
                        break;
                        case 'phone':
                            ?>
                            <div class="wpcw-form-item" data-label="phone">
                                <div class="wpcw-sort-header">
                                    <input type="checkbox" class="wpcw-checkbox-toggle" id="<?php echo $this->get_field_id('wp_contact_widget_phone_enable'); ?>" name="<?php echo $this->get_field_name('wp_contact_widget_phone_enable'); ?>" <?php echo $wp_contact_widget_phone_enable; ?> />
                                    <strong>&nbsp;<label for="<?php echo $this->get_field_id('wp_contact_widget_phone_enable'); ?>"><?php _e('Enable Phone field', 'wp_contact_widget'); ?></label></strong>
                                    <span class="wpcw-sort-handle" style="float:right;"><i class="dashicons dashicons-sort"></i></span>
                                </div>
                                <div class="wpcw-sort-content <?php if ( !empty( $wp_contact_widget_phone_enable ) ) echo 'active'?>" data-checkbox="<?php echo $this->get_field_id('wp_contact_widget_phone_enable'); ?>">
                                    <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_phone_label'); ?>"><?php _e('Phone label:', 'wp_contact_widget'); ?></label></strong><br/>
                                    <input class="widefat" id="<?php echo $this->get_field_id('wp_contact_widget_phone_label'); ?>" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_phone_label'); ?>" value="<?php echo esc_attr($wp_contact_widget_phone_label); ?>"/>
                                </div>
                            </div>
                            <?php
                        break;
                        case 'consent':
                            ?>
                            <div class="wpcw-form-item" data-label="consent">
                                <div class="wpcw-sort-header">
                                    <input type="checkbox" class="wpcw-checkbox-toggle" id="<?php echo $this->get_field_id('wp_contact_widget_consent_enable'); ?>" name="<?php echo $this->get_field_name('wp_contact_widget_consent_enable'); ?>" <?php echo $wp_contact_widget_consent_enable; ?> />
                                    <strong>&nbsp;<label for="<?php echo $this->get_field_id('wp_contact_widget_consent_enable'); ?>"><?php _e('Enable Consent field', 'wp_contact_widget'); ?></label></strong>
                                    <span class="wpcw-sort-handle" style="float:right;"><i class="dashicons dashicons-sort"></i></span>
                                </div>
                                <div class="wpcw-sort-content <?php if ( !empty( $wp_contact_widget_consent_enable ) ) echo 'active'?>" data-checkbox="<?php echo $this->get_field_id('wp_contact_widget_consent_enable'); ?>">
                                    <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_consent_label'); ?>"><?php _e('Consent label:', 'wp_contact_widget'); ?></label></strong><br/>
                                    <input class="widefat" id="<?php echo $this->get_field_id('wp_contact_widget_consent_label'); ?>" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_consent_label'); ?>" value="<?php echo esc_attr($wp_contact_widget_consent_label); ?>"/>
                                </div>
                            </div>
                            <?php
                        break;
                        case 'message':
                            ?>
                            <div class="wpcw-form-item" data-label="message">
                                <div class="wpcw-sort-header">
                                    <input type="checkbox" class="wpcw-checkbox-toggle" id="<?php echo $this->get_field_id('wp_contact_widget_message_enable'); ?>" name="<?php echo $this->get_field_name('wp_contact_widget_message_enable'); ?>" <?php echo $wp_contact_widget_message_enable; ?> />
                                    <strong>&nbsp;<label for="<?php echo $this->get_field_id('wp_contact_widget_message_enable'); ?>"><?php _e('Enable Message field', 'wp_contact_widget'); ?></label></strong>
                                    <span class="wpcw-sort-handle" style="float:right;"><i class="dashicons dashicons-sort"></i></span>
                                </div>
                                <div class="wpcw-sort-content <?php if ( !empty( $wp_contact_widget_message_enable ) ) echo 'active'?>" data-checkbox="<?php echo $this->get_field_id('wp_contact_widget_message_enable'); ?>">
                                    <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_message_label'); ?>"><?php _e('Message label:', 'wp_contact_widget'); ?></label></strong><br/>
                                    <input class="widefat" id="<?php echo $this->get_field_id('wp_contact_widget_message_label'); ?>" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_message_label'); ?>" value="<?php echo esc_attr($wp_contact_widget_message_label); ?>"/>
                                </div>
                            </div>
                            <?php
                        break;
                        case 'subject':
                            ?>
                            <div class="wpcw-form-item" data-label="subject">
                                <div class="wpcw-sort-header">
                                    <input type="checkbox" class="wpcw-checkbox-toggle" id="<?php echo $this->get_field_id('wp_contact_widget_subject_enable'); ?>" name="<?php echo $this->get_field_name('wp_contact_widget_subject_enable'); ?>" <?php echo $wp_contact_widget_subject_enable; ?> />
                                    <strong>&nbsp;<label for="<?php echo $this->get_field_id('wp_contact_widget_subject_enable'); ?>"><?php _e('Enable Subject field', 'wp_contact_widget'); ?></label></strong>
                                    <span class="wpcw-sort-handle" style="float:right;"><i class="dashicons dashicons-sort"></i></span>
                                </div>
                                <div class="wpcw-sort-content <?php if ( !empty( $wp_contact_widget_subject_enable ) ) echo 'active'?>" data-checkbox="<?php echo $this->get_field_id('wp_contact_widget_subject_enable'); ?>">
                                    <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_subject_label'); ?>"><?php _e('Subject label:', 'wp_contact_widget'); ?></label></strong><br/>
                                    <input class="widefat" id="<?php echo $this->get_field_id('wp_contact_widget_subject_label'); ?>" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_subject_label'); ?>" value="<?php echo esc_attr($wp_contact_widget_subject_label); ?>"/>
                                </div>
                            </div>
                            <?php
                        break;
                        default://custom fields
                            ?>
                            <div class="wpcw-form-item" data-label="<?php echo $field; ?>">
                                <div class="wpcw-sort-header">
                                    <strong class="wpcw-custom-field-label">
                                        <span class="wpcw-custom-field-remove"><i class="dashicons dashicons-no"></i></span><?php echo $field; ?><span class="wpcw-sort-handle"><i class="dashicons dashicons-sort"></i></span>
                                    </strong>
                                </div>
                            </div>
                            <?php
                        break;
                    }
                }
                ?>
            </div>
            <div class="custom_fields_wrap wp-core-ui">
                <h4><?php _e('Add Custom text field:', 'wp_contact_widget'); ?></h4>
                <label for="<?php echo $this->get_field_id('wpcw_custom_field'); ?>"><?php _e('Custom field label:', 'wp_contact_widget'); ?></label>
                <input class="widefat add_field_input" id="<?php echo $this->get_field_id('wpcw_custom_field'); ?>" type="text" name="wpcw_custom_field" value=""/>
                <br/>
                <br/>
                <button class="add_field_button button" disabled ><i class="dashicons dashicons-plus"></i><?php _e( 'Add Text Field', 'wp_contact_widget' ); ?></button>
            </div>

            <p>
                <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_delivered_to_mail'); ?>"><?php _e('Delivered To Mail Address', 'wp_contact_widget'); ?></label></strong><br/>
                <input class="widefat" id="<?php echo $this->get_field_id('wp_contact_widget_delivered_to_mail'); ?>" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_delivered_to_mail'); ?>" value="<?php echo esc_attr($wp_contact_widget_delivered_to_mail); ?>"/>
            </p>

            <p>
                <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_submit_label'); ?>"><?php _e('Send Message button text:', 'wp_contact_widget'); ?></label></strong><br/>
                <input class="widefat" id="<?php echo $this->get_field_id('wp_contact_widget_submit_label'); ?>" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_submit_label'); ?>" value="<?php echo esc_attr($wp_contact_widget_submit_label); ?>"/>
            </p>

            <p>
                <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_success_message'); ?>"><?php _e('Success message:', 'wp_contact_widget'); ?></label></strong><br/>
                <input class="widefat" id="<?php echo $this->get_field_id('wp_contact_widget_success_message'); ?>" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_success_message'); ?>" value="<?php echo esc_attr($wp_contact_widget_success_message); ?>"/>
            </p>

            <p>
                <input type="checkbox" class="wpcw-checkbox-toggle" id="<?php echo $this->get_field_id('wp_contact_widget_newsletter_subscribe'); ?>" name="<?php echo $this->get_field_name('wp_contact_widget_newsletter_subscribe'); ?>" <?php echo $wp_contact_widget_newsletter_subscribe; ?> />
                <strong>&nbsp;<label for="<?php echo $this->get_field_id('wp_contact_widget_newsletter_subscribe'); ?>"><?php _e('Enable email subscription', 'wp_contact_widget'); ?></label></strong>
            </p>


            <div data-checkbox="<?php echo $this->get_field_id('wp_contact_widget_newsletter_subscribe'); ?>" <?php if ( !empty( $wp_contact_widget_newsletter_subscribe ) ) echo 'class="active"';?>>

                <p>
                    <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_subscribe_label'); ?>"><?php _e('Subscribe label:', 'wp_contact_widget'); ?></label></strong><br/>
                    <input class="widefat" id="<?php echo $this->get_field_id('wp_contact_widget_subscribe_label'); ?>" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_subscribe_label'); ?>" value="<?php echo esc_attr($wp_contact_widget_subscribe_label); ?>"/>
                </p>
            
                <p class="wpcw-has-child-opt">
                    <strong><label for="<?php echo $this->get_field_id('wpcw_fields_newsletter_type'); ?>"><?php echo __('Choose A Mail Service for subscription', 'wp_contact_widget') ?></label></strong><br/>
                    <select name="<?php echo $this->get_field_name('subscription_service'); ?>" id="<?php echo $this->get_field_id('subscription_service'); ?>">
                        <option value="" <?php echo ($subscription_service == '') ? 'selected=selected' : ''; ?>><?php _e('Choose a service', 'wp_contact_widget'); ?></option>
                        <option value="getresponse" <?php echo ($subscription_service === 'getresponse') ? 'selected=selected' : ''; ?>><?php _e('Get Response', 'wp_contact_widget'); ?></option>
                        <option value="mailchimp" <?php echo ($subscription_service === 'mailchimp') ? 'selected=selected' : ''; ?>><?php _e('MailChimp', 'wp_contact_widget'); ?></option>
                        <option value="aweber" <?php echo ($subscription_service === 'aweber') ? 'selected=selected' : ''; ?>><?php _e('Aweber', 'wp_contact_widget'); ?></option>
                    </select>
                </p>
                <div data-parent-select-id="<?php echo $this->get_field_id('subscription_service'); ?>" data-parent-select-value="getresponse">
                    <p class="wpcw_newsletter_getresponse_one">
                        <strong><label for="<?php echo $this->get_field_id('getresponse_api_key'); ?>"><?php echo __('GetResponse API Key', 'wp_contact_widget') ?></label></strong><br/>
                        <input class="widefat getresponse_api_key" id="<?php echo $this->get_field_id('getresponse_api_key'); ?>" type="text" name="<?php echo $this->get_field_name('getresponse_api_key'); ?>" value="<?php echo esc_attr($getresponse_api_key); ?>"/>
                    </p>
                    <p class="wpcw_newsletter_getresponse_two">
                        <strong><label for="<?php echo $this->get_field_id('getresponse_campaign'); ?>"><?php echo __('GetResponse Campaign', 'wp_contact_widget') ?></label></strong><br/>
                        <select name="<?php echo $this->get_field_name('getresponse_campaign'); ?>" id="<?php echo $this->get_field_id('getresponse_campaign'); ?>" class="getresponse_campaign" data-list="<?php echo esc_attr($getresponse_campaign); ?>"></select>
                    </p>
                </div>
                <div data-parent-select-id="<?php echo $this->get_field_id('subscription_service'); ?>" data-parent-select-value="mailchimp">
                    <p class="wpcw_newsletter_mailchimp_one">
                        <strong><label for="<?php echo $this->get_field_id('mailchimp_api_key'); ?>"><?php echo __('Mailchimp API Key', 'wp_contact_widget') ?></label></strong><br/>
                        <input class="widefat mailchimp_api_key" id="<?php echo $this->get_field_id('mailchimp_api_key'); ?>" type="text" name="<?php echo $this->get_field_name('mailchimp_api_key'); ?>" value="<?php echo esc_attr($mailchimp_api_key); ?>"/>
                    </p>
                    <p class="wpcw_newsletter_mailchimp_two">
                        <strong><label for="<?php echo $this->get_field_id('mailchimp_list_id'); ?>"><?php echo __('Mailchimp List ID', 'wp_contact_widget') ?></label></strong><br/>
                        <select name="<?php echo $this->get_field_name('mailchimp_list_id'); ?>" id="<?php echo $this->get_field_id('mailchimp_list_id'); ?>" class="mailchimp_list_id" data-list="<?php echo esc_attr($mailchimp_list_id); ?>"></select>
                    </p>
                </div>
                <div data-parent-select-id="<?php echo $this->get_field_id('subscription_service'); ?>" data-parent-select-value="aweber">
                    <p class="wpcw_newsletter_aweber_one">
                        <a href="https://auth.aweber.com/1.0/oauth/authorize_app/f6713114" target="_blank" class="button mtsnb-aweber-connect"><?php _e('Get Authorization Code', 'wp_contact_widget') ?></a>
                        <input type="hidden" class="aweber_consumer_key" id="<?php echo $this->get_field_id('aweber_consumer_key'); ?>" name="<?php echo $this->get_field_name('aweber_consumer_key'); ?>" value="<?php echo esc_attr($aweber_consumer_key); ?>" />
                        <input type="hidden" class="aweber_consumer_secret" id="<?php echo $this->get_field_id('aweber_consumer_secret'); ?>" name="<?php echo $this->get_field_name('aweber_consumer_secret'); ?>" value="<?php echo esc_attr($aweber_consumer_secret); ?>" />
                        <input type="hidden" class="aweber_access_key" id="<?php echo $this->get_field_id('aweber_access_key'); ?>" name="<?php echo $this->get_field_name('aweber_access_key'); ?>" value="<?php echo esc_attr($aweber_access_key); ?>" />
                        <input type="hidden" class="aweber_access_secret" id="<?php echo $this->get_field_id('aweber_access_secret'); ?>" name="<?php echo $this->get_field_name('aweber_access_secret'); ?>" value="<?php echo esc_attr($aweber_access_secret); ?>" />
                    </p>

                    <p class="wpcw_newsletter_aweber_two">
                        <strong><label for="<?php echo $this->get_field_id('aweber_auth_code'); ?>"><?php echo __('Paste Authorization Code', 'wp_contact_widget') ?></label></strong><br/>
                        <input class="widefat aweber_auth_code" id="<?php echo $this->get_field_id('aweber_auth_code'); ?>" type="text" name="<?php echo $this->get_field_name('aweber_auth_code'); ?>" value="<?php echo esc_attr($aweber_auth_code); ?>"/>
                    </p>

                    <p class="wpcw_newsletter_aweber_three">
                        <strong><label for="<?php echo $this->get_field_id('aweber_list_id'); ?>"><?php echo __('Aweber List ID', 'wp_contact_widget') ?></label></strong><br/>
                        <select name="<?php echo $this->get_field_name('aweber_list_id'); ?>" id="<?php echo $this->get_field_id('aweber_list_id'); ?>" class="aweber_list_id" data-list="<?php echo esc_attr($aweber_list_id); ?>"></select>
                    </p>
                </div>
            </div>
            <p>
                <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_text_before'); ?>"><?php _e('Text before the form:', 'wp_contact_widget'); ?></label></strong><br/>
                <textarea id="<?php echo $this->get_field_id('wp_contact_widget_text_before'); ?>" rows="5" cols="20" class="widefat" name="<?php echo $this->get_field_name('wp_contact_widget_text_before'); ?>" tabindex="0"><?php echo $wp_contact_widget_text_before; ?></textarea>
            </p>
            <p>
                <strong><label for="<?php echo $this->get_field_id('wp_contact_widget_text_after'); ?>"><?php _e('Text after the form:', 'wp_contact_widget'); ?></label></strong><br/>
                <textarea id="<?php echo $this->get_field_id('wp_contact_widget_text_after'); ?>" rows="5" cols="20" class="widefat" name="<?php echo $this->get_field_name('wp_contact_widget_text_after'); ?>" tabindex="0"><?php echo $wp_contact_widget_text_after; ?></textarea>
            </p>
            <p>
                <strong><?php _e('Custom CSS:', 'wp_contact_widget'); ?></strong><br/>
                <textarea rows="10" cols="20" class="widefat" name="<?php echo $this->get_field_name('wp_contact_widget_custom_css'); ?>" tabindex="0"><?php echo $wp_contact_widget_custom_css; ?></textarea>
            </p>

            <p>
                <input type="checkbox" class="wpcw-checkbox-toggle" name="<?php echo $this->get_field_name('wp_contact_widget_captcha'); ?>" id="<?php echo $this->get_field_id('wp_contact_widget_captcha'); ?>" <?php echo $wp_contact_widget_captcha; ?> value="on"/>
                <strong>&nbsp;<label for="<?php echo $this->get_field_id('wp_contact_widget_captcha'); ?>"><?php _e('Enable CAPTCHA', 'wp_contact_widget'); ?></label></strong>
            </p>
            <div class="wpcw_captcha_keys <?php if ( !empty( $wp_contact_widget_captcha ) ) echo 'active';?>" data-checkbox="<?php echo $this->get_field_id('wp_contact_widget_captcha'); ?>">
                <p>
                    <br/>
                    <?php
                    printf( __('To start using ReCaptcha protection, you will first need to <a href="%s" target="_blank">generate a set of API keys here</a>.', 'wp_contact_widget'), 'https://www.google.com/recaptcha/admin#list' );
                    ?>
                </p>
                <?php if (!empty($wp_contact_widget_captcha) && ( empty($wp_contact_widget_public_key) || empty($wp_contact_widget_private_key) )) { ?>
                    <div class="error below-h2"><?php _e('Please, remember that your submissions will <strong>not</strong> be protected until you set up the API keys.', 'wp_contact_widget'); ?></div>
                <?php } ?>
                <p>
                    <strong><?php _e('Site Key', 'wp_contact_widget'); ?></strong>
                    <br/>
                    <input class="widefat" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_public_key'); ?>" value="<?php echo esc_attr($wp_contact_widget_public_key); ?>"/>
                    <br/>
                </p>
                <p>
                    <strong><?php _e('Secret Key', 'wp_contact_widget'); ?></strong>
                    <br/>
                    <input class="widefat" type="text" name="<?php echo $this->get_field_name('wp_contact_widget_private_key'); ?>" value="<?php echo esc_attr($wp_contact_widget_private_key); ?>"/>
                    <br/>
                </p>
                <p>
                    <strong><?php _e('Recaptcha Theme:', 'wp_contact_widget'); ?></strong>
                    <br/>
                </p>
                <p>
                    <label>
                        <input type="radio" class="widefat" name="<?php echo $this->get_field_name('wp_contact_widget_recaptcha_theme'); ?>" value="light" <?php checked('light', $wp_contact_widget_recaptcha_theme, true); ?>/>
                        <?php _e('Light', 'wp_contact_widget'); ?>
                    </label>
                </p>
                <p>
                    <label>
                        <input type="radio" class="widefat" name="<?php echo $this->get_field_name('wp_contact_widget_recaptcha_theme'); ?>" value="dark" <?php checked('dark', $wp_contact_widget_recaptcha_theme, true); ?>/>
                        <?php _e('Dark', 'wp_contact_widget'); ?>
                    </label>
                </p>
            </div>
        </div>
        
        <?php
    }

    /**
     * Processing widget options on save
     *
     * @param array $new_instance The new options
     * @param array $old_instance The previous options
     */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = esc_html($new_instance['title']);
        $instance['wp_contact_widget_widget_title'] = esc_html($new_instance['wp_contact_widget_widget_title']);
        $instance['wp_contact_widget_name_enable'] = esc_html($new_instance['wp_contact_widget_name_enable']);
        $instance['wp_contact_widget_name_label'] = esc_html($new_instance['wp_contact_widget_name_label']);
        $instance['wp_contact_widget_from_label'] = esc_html($new_instance['wp_contact_widget_from_label']);

        $instance['wp_contact_widget_subject_enable'] = esc_html($new_instance['wp_contact_widget_subject_enable']);
        $instance['wp_contact_widget_subject_label'] = esc_html($new_instance['wp_contact_widget_subject_label']);

        $instance['wp_contact_widget_phone_enable'] = esc_html($new_instance['wp_contact_widget_phone_enable']);
        $instance['wp_contact_widget_phone_label'] = esc_html($new_instance['wp_contact_widget_phone_label']);

        $instance['wp_contact_widget_consent_enable'] = esc_html($new_instance['wp_contact_widget_consent_enable']);
        $instance['wp_contact_widget_consent_label'] = esc_html($new_instance['wp_contact_widget_consent_label']);

        $instance['wp_contact_widget_message_enable'] = esc_html($new_instance['wp_contact_widget_message_enable']);
        $instance['wp_contact_widget_message_label'] = esc_html($new_instance['wp_contact_widget_message_label']);
        $instance['wp_contact_widget_delivered_to_mail'] = esc_html($new_instance['wp_contact_widget_delivered_to_mail']);

        $instance['wp_contact_widget_submit_label'] = esc_html($new_instance['wp_contact_widget_submit_label']);
        $instance['wp_contact_widget_success_message'] = esc_html($new_instance['wp_contact_widget_success_message']);
        $instance['wp_contact_widget_newsletter_subscribe'] = esc_html($new_instance['wp_contact_widget_newsletter_subscribe']);
        $instance['wp_contact_widget_subscribe_label'] = esc_html($new_instance['wp_contact_widget_subscribe_label']);
        $instance['wp_contact_widget_text_before'] = esc_html($new_instance['wp_contact_widget_text_before']);

        $instance['wp_contact_widget_text_after'] = esc_html($new_instance['wp_contact_widget_text_after']);
        $instance['wp_contact_widget_custom_css'] = esc_html($new_instance['wp_contact_widget_custom_css']);

        $instance['wp_contact_widget_captcha'] = esc_html($new_instance['wp_contact_widget_captcha']);
        $instance['wp_contact_widget_public_key'] = esc_html($new_instance['wp_contact_widget_public_key']);
        $instance['wp_contact_widget_private_key'] = esc_html($new_instance['wp_contact_widget_private_key']);
        $instance['wp_contact_widget_recaptcha_theme'] = esc_html($new_instance['wp_contact_widget_recaptcha_theme']);

        if (!empty($instance['wp_contact_widget_private_key'])) {
            update_option('wp_contact_widget_private_key', $instance['wp_contact_widget_private_key']);
        }

        $instance['subscription_service'] = esc_html($new_instance['subscription_service']);
        $instance['getresponse_api_key'] = esc_html($new_instance['getresponse_api_key']);
        $instance['getresponse_campaign'] = esc_html($new_instance['getresponse_campaign']);
        $instance['mailchimp_api_key'] = esc_html($new_instance['mailchimp_api_key']);
        $instance['mailchimp_list_id'] = esc_html($new_instance['mailchimp_list_id']);
        $instance['aweber_auth_code'] = esc_html($new_instance['aweber_auth_code']);
        $instance['aweber_list_id'] = esc_html($new_instance['aweber_list_id']);

        $instance['wp_contact_widget_fields_order'] = (string) $new_instance['wp_contact_widget_fields_order'];

        return $instance;
    }

    /**
     * Outputs the content of the widget
     *
     * @param array $args
     * @param array $instance
     */
    function widget($args, $instance) {
        $data = $this->_get_data($instance);
        $plugin_dir = rtrim(dirname(__FILE__), '/') . '/';
        $wpcw_uniqid = md5(serialize($data) . uniqid());
        extract($data);
        $wp_contact_widget_refresh_message = !empty($wp_contact_widget_refresh_message) ? $wp_contact_widget_refresh_message : __('Click to refresh', 'wp_contact_widget');
        $wp_contact_widget_refresh_link = !empty($wp_contact_widget_refresh_link) ? $wp_contact_widget_refresh_link : __('Reload Captcha', 'wp_contact_widget');
        $wp_contact_widget_submit_label = !empty($wp_contact_widget_submit_label) ? $wp_contact_widget_submit_label : $data['wp_contact_widget_submit_label'];
        $wp_contact_widget_response_field = !empty($wp_contact_widget_response_field) ? $wp_contact_widget_response_field : __('Type the characters you see in image above', 'wp_contact_widget');
        $wp_contact_widget_recaptcha_version = !empty($wp_contact_widget_recaptcha_version) ? $wp_contact_widget_recaptcha_version : 'old';
        $wp_contact_widget_recaptcha_theme = !empty($wp_contact_widget_recaptcha_theme) ? $wp_contact_widget_recaptcha_theme : 'light';
        $wp_contact_widget_recaptcha_type = !empty($wp_contact_widget_recaptcha_type) ? $wp_contact_widget_recaptcha_type : 'image';

        $wp_contact_widget_newsletter_subscribe = (isset($instance['wp_contact_widget_newsletter_subscribe']) && (!empty($instance['wp_contact_widget_newsletter_subscribe']) )) ? 'checked="checked"' : '';
        //$wp_contact_widget_captcha = ( 'on' == $wp_contact_widget_captcha ) ? 1 : 0;
        $publickey = $wp_contact_widget_public_key;

        $wp_contact_widget_fields_order = explode( '#|%', $wp_contact_widget_fields_order );

        echo $args['before_widget'];
        echo $args['before_title'] . esc_html($wp_contact_widget_widget_title) . $args['after_title'];
        
        ?>

        <?php if ($wp_contact_widget_custom_css != '') { ?>
            <style type="text/css">
            <?php echo $wp_contact_widget_custom_css; ?>
            </style>
        <?php } ?>
        <div id="wp-contact-widget-form-fields">
            <div class="wp-contact-widget-form-field">
                <?php echo wp_kses_post($wp_contact_widget_text_before); ?>
            </div>
            <form class="wpcw-contact-form <?php echo( $wp_contact_widget_captcha ? 'wpcw-has_captcha' : '' ); ?>" id="wpcw-form-<?php echo $wpcw_uniqid; ?>">
                <?php do_action('wp_contact_form-form_start', $wpcw_uniqid); ?>
                <div class="wpcw-message">
                    <?php do_action('contact_form-form_message', $wpcw_uniqid); ?>
                </div>
                <input type="hidden" class="wpcw-refresh_message" value="<?php esc_attr_e($wp_contact_widget_refresh_message); ?>"/>
                <input type="hidden" class="wpcw-refresh_link" value="<?php esc_attr_e($wp_contact_widget_refresh_link); ?>"/>
                <input type="hidden" name="instance" value="<?php esc_attr_e($this->number); ?>"/>

                <?php do_action('contact_form-fields_start', $wpcw_uniqid); ?>

                <?php
                foreach ( $wp_contact_widget_fields_order as $field ) {
                    echo '<div class="wp-contact-widget-form-field">';
                    switch ( $field ) {
                        case 'email':
                            ?>
                            <label for="wpcw_email-<?php echo $wpcw_uniqid; ?>"><?php echo wp_kses_post($wp_contact_widget_from_label); ?></label>
                            <input class="text" type="text" name="email" id="wpcw_email-<?php echo $wpcw_uniqid; ?>" value="">
                            <?php
                            global $wp;
                            $current_url = home_url( add_query_arg( array(), $wp->request) );
                            $referrer_enabled = apply_filters( 'wpcw_referrer_field', true, $this->number );
                            if ( $referrer_enabled ) {
                                ?>
                                <input type="hidden" name="referrer" id="wpcw_referrer-<?php echo $wpcw_uniqid; ?>" value="<?php echo esc_url( $current_url ); ?>">
                                <?php
                            }
                            do_action('wp_contact_form-after_email', $wpcw_uniqid);
                        break;
                        case 'name':
                            if (isset($wp_contact_widget_name_enable) && ($wp_contact_widget_name_enable != '')):
                                ?>
                                <label for="wpcw_name-<?php echo $wpcw_uniqid; ?>"><?php echo wp_kses_post($wp_contact_widget_name_label); ?></label>
                                <input class="text" type="text" name="name" id="wpcw_name-<?php echo $wpcw_uniqid; ?>" value="">
                                <?php
                                do_action('wp_contact_form-after_name', $wpcw_uniqid);
                            endif;
                        break;
                        case 'phone':
                            if (isset($wp_contact_widget_phone_enable) && ($wp_contact_widget_phone_enable != '')): ?> 
                                <label for="wpcw_phone-<?php echo $wpcw_uniqid; ?>"><?php echo wp_kses_post($wp_contact_widget_phone_label); ?></label>
                                <input class="text" type="text" name="phone" id="wpcw_phone-<?php echo $wpcw_uniqid; ?>" value="">
                                <?php
                                do_action('wp_contact_form-after_phone', $wpcw_uniqid);
                            endif;
                        break;
                        case 'consent':
                            if (isset($wp_contact_widget_consent_enable) && ($wp_contact_widget_consent_enable != '')): ?> 
                                <label for="wpcw_consent-<?php echo $wpcw_uniqid; ?>" class="wpc-consent-field"><?php echo wp_kses_post($wp_contact_widget_consent_label); ?></label>
                                <input type="checkbox" class="consent" name="consent" id="wpcw_consent-<?php echo $wpcw_uniqid; ?>" value="yes" required />
                            <?php
                                do_action('wp_contact_form-after_phone', $wpcw_uniqid);
                            endif;
                        break;
                        case 'message':
                            if (isset($wp_contact_widget_message_enable) && ($wp_contact_widget_message_enable != '')): ?>
                                <label for="wpcw_message-<?php echo $wpcw_uniqid; ?>"><?php echo wp_kses_post($wp_contact_widget_message_label); ?></label>
                                <textarea name="message" id="wpcw_message-<?php echo $wpcw_uniqid; ?>" value=""></textarea>
                                <?php
                                do_action('wp_contact_form-after_message', $wpcw_uniqid);
                            endif;
                        break;
                        case 'subject':
                            if (isset($wp_contact_widget_subject_enable) && ($wp_contact_widget_subject_enable != '')): ?>
                                <label for="wpcw_subject-<?php echo $wpcw_uniqid; ?>"><?php echo wp_kses_post($wp_contact_widget_subject_label); ?></label>
                                <input class="text" type="text" name="subject" id="wpcw_subject-<?php echo $wpcw_uniqid; ?>" value="">
                                <?php
                                do_action('wp_contact_form-after_subject', $wpcw_uniqid);
                            endif;
                        break;
                        default://custom fields
                            ?>
                                <label for="wpcw_<?php echo sanitize_title($field); ?>-<?php echo $wpcw_uniqid; ?>"><?php echo wp_kses_post($field); ?></label>
                                <input class="text" type="text" name="<?php echo sanitize_title($field); ?>" id="wpcw_<?php echo sanitize_title($field); ?>-<?php echo $wpcw_uniqid; ?>" value="">
                                <?php
                                do_action('wp_contact_form-'.sanitize_title($field), $wpcw_uniqid);
                        break;
                    }
                    echo '</div>';
                }
                ?>

                <?php if (!empty($wp_contact_widget_newsletter_subscribe)): ?>
                <div class="wp-contact-widget-form-field">
                    <input type="checkbox" id="wpcw_newsletter-<?php echo $wpcw_uniqid; ?>" name="wp_contact_widget_newsletter_subscribe_toggle" />
                    &nbsp;<?php echo $wp_contact_widget_subscribe_label; ?><br />
                </div>
                <?php endif; ?>

                <?php
                if ($wp_contact_widget_captcha && !empty($wp_contact_widget_public_key) && !empty($wp_contact_widget_private_key) && !defined('CW_RECAPTCHA_DONE')) {
                    if (!function_exists('_recaptcha_qsencode')) {
                        require_once( $plugin_dir . 'scripts/recaptchalib.php' );
                    }
                    //Use old recaptcha
                    define('CW_RECAPTCHA_DONE', true);
                    if ($wp_contact_widget_recaptcha_version == 'new') {
                        ?>

                        <script type="text/javascript">
                            var RecaptchaOptions = {
                                theme: 'custom',
                                lang: 'en',
                                custom_theme_widget: 'wpcw-recaptcha_widget'
                            };
                        </script>
                        <div id="wpcw-recaptcha_widget" style="display: none;">
                            <div id="recaptcha_image"></div>
                            <div id="wpcw_refresh">
                                <a href="javascript:Recaptcha.reload()"><span><?php echo wp_kses_post($wp_contact_widget_refresh_link); ?></span></a>
                            </div>
                            <br/>

                            <!--Incorrect message-->
                            <div class="recaptcha_only_if_incorrect_sol" style="color: red;"><?php _e('Incorrect please try again', 'wp_contact_widget'); ?></div>

                            <!-- Captcha Input field-->
                            <label><?php echo $wp_contact_widget_response_field; ?></label>
                            <br/>
                            <input id="recaptcha_response_field" name="recaptcha_response_field" type="text">
                            <script type="text/javascript" src="http://api.recaptcha.net/challenge?k=<?php echo $publickey; ?>&lang=en"></script>
                        </div>
                        <br/>
                    <?php } else { ?>
                        <div class="g-recaptcha" id="wpmu_grecaptcha" data-sitekey="<?php echo $wp_contact_widget_public_key; ?>" data-type="<?php echo $wp_contact_widget_recaptcha_type; ?>" data-theme="<?php echo $wp_contact_widget_recaptcha_theme; ?>"></div>
                        <script src="https://www.google.com/recaptcha/api.js"></script>
                        <br/><?php }
                    } ?>
                <div class="wp-contact-widget-form-field">
                    <input class="button mts-contact-submit" type="button" name="submit" value="<?php echo wp_kses_post($wp_contact_widget_submit_label); ?>">
                </div>
            </form>
            <div class="wp-contact-widget-form-field">
                <?php echo wp_kses_post($wp_contact_widget_text_after); ?>
            </div>
        </div>
        <?php
        echo $args['after_widget'];
    }

    private function _get_data($data = array()) {
        return wp_parse_args(
            $data, $this->default_options
        );
    }
}

register_activation_hook( __FILE__, 'wpcw_plugin_activate' );
function wpcw_plugin_activate() {

    // Replace commas with new separator in fields order option ( v1.0.2 )
    if ( false === get_option('wp_contact_widget_upgraded') ) {
        
        $settings = get_option('widget_wp_contact_widget');

        if ( $settings ) {

            foreach ( $settings as $key => $value ) {

                if ( isset( $value['wp_contact_widget_fields_order'] ) ) {

                    $new_order = str_replace( ',', '#|%', $value['wp_contact_widget_fields_order'] );

                    $settings[ $key ]['wp_contact_widget_fields_order'] = $new_order;
                }
            }

            update_option('widget_wp_contact_widget', $settings );
            update_option('wp_contact_widget_upgraded', '1.0.3' );
        }
    }
}