(function( $ ) {

	var NF_Trello = {
		populateObjects: function( model, selected_id, type, id ) {
			$( '#trello_' + type ).empty();
			$( '#trello_' + type ).append( '<option value="0">Retrieving...</option>' );
			$.ajax( {
				url: ajaxurl,
				type: 'POST',
				dataType: 'json',
				data: {
					action: 'nf_trello_get_objects',
					id: id,
					type: type
				},
				success: function( response ) {
					$( '#trello_' + type ).empty();
					$.each( response.data, function( key, val ) {
						var selected = ( selected_id == key ) ? ' selected="selected"' : '';
						$( '#trello_' + type ).append( '<option value="' + key + '"' + selected + '>' + val + '</option>' );
					} );
					$( '#trello_' + type ).removeAttr( 'disabled' );
				},
				error: function( response, status, error ) {
					alert( 'Error: ' + error.replace( /(<([^>]+)>)/ig, "" ) );
				}
			} );
		},

		populateMembers: function( board_id, membersModel, rerender ) {
			rerender = rerender || false;
			$.ajax( {
				url: ajaxurl,
				type: 'POST',
				dataType: 'json',
				data: {
					action: 'nf_trello_get_objects',
					id: board_id,
					type: 'BoardMember'
				},
				success: function( response ) {
					var settingCollection = membersModel.get( 'settings' );
					settingCollection.reset( response.data );
					membersModel.set( 'settings', settingCollection );
					if ( rerender ) {
						membersModel.trigger( 'rerender' );
					}
				},
				error: function( response, status, error ) {
					alert( 'Error: ' + error.replace( /(<([^>]+)>)/ig, "" ) );
				}
			} );
		},

		resetDropdown: function( type ) {
			var object = 'select#trello_' + type.toLowerCase();
			$( object ).attr( 'disabled', 'disabled' );
			$( object ).empty();
			$( object ).append( '<option value="0">Select ' + type + '</option>' );
		}
	};

	var nfRadio = Backbone.Radio;
	var trelloController = Marionette.Object.extend( {
		membersModel: false,
		initialize: function() {
			this.listenTo( nfRadio.channel( 'actions-trello' ), 'init:actionModel', this.registerChangeListener );
			this.listenTo( nfRadio.channel( 'setting-trello_organization' ), 'before:renderSetting', this.populateOrgs );
			this.listenTo( nfRadio.channel( 'setting-trello_board' ), 'before:renderSetting', this.populateBoards );
			this.listenTo( nfRadio.channel( 'setting-trello_list' ), 'before:renderSetting', this.populateLists );
			this.listenTo( nfRadio.channel( 'setting-card_members' ), 'before:renderSetting', this.populateMembers );
			this.listenTo( nfRadio.channel( 'app' ), 'change:setting', this.maybePopulateOrgs );
		},

		registerChangeListener: function( actionModel ) {
			this.listenTo( actionModel, 'change:trello_organization', this.triggerPopulateMembers );
			this.listenTo( actionModel, 'change:trello_board', this.triggerPopulateMembers );
		},

		maybePopulateOrgs: function( e, model, dataModel ) {
			if ( 'select' != model.get( 'type' ) ) {
				return;
			}

			var id = model.get( 'name' );

			if ( 'trello_' != id.substring( 0, 7 ) ) {
				return;
			}

			this.populateObject( id.substring( 7 ), model, dataModel );
		},

		populateObject: function( object, model, dataModel ) {
			var object_id = $( 'option:selected', $( '#' + model.get( 'name' ) ) ).val();
			if ( 'organization' == object ) {
				this.populateBoards( model, dataModel, '', object_id );
			} else if ( 'board' == object ) {
				this.populateLists( model, dataModel, '', object_id );
			}
		},

		populateOrgs: function( model, dataModel, item ) {
			NF_Trello.resetDropdown( 'Board' );
			NF_Trello.resetDropdown( 'List' );

			var value = dataModel.get( 'trello_organization' );
			NF_Trello.populateObjects( model, value, 'organization', 1 );
		},

		populateBoards: function( model, dataModel, item, org_id ) {
			NF_Trello.resetDropdown( 'List' );
			var value = dataModel.get( 'trello_board' );
			var beforeRender = false;
			if ( null == org_id ) {
				beforeRender = true;
				org_id = dataModel.get( 'trello_organization' );
			}
			NF_Trello.populateObjects( model, value, 'board', org_id );
		},

		populateLists: function( model, dataModel, item, board_id ) {
			var value = dataModel.get( 'trello_list' );
			if ( null == board_id ) {
				board_id = dataModel.get( 'trello_board' );
			}
			NF_Trello.populateObjects( model, value, 'list', board_id );
		},

		triggerPopulateMembers: function( dataModel, value ) {
			this.populateMembers( false, dataModel, false, true );
		},

		populateMembers: function( model, dataModel, item, rerender ) {
			rerender = rerender || false;

			if ( model ) {
				this.membersModel = model;
			} else {
				model = this.membersModel;
			}

			var board_id = dataModel.get( 'trello_board' );
			if ( '' == board_id ) {
				return;
			}

			NF_Trello.populateMembers( board_id, model, rerender );
		},

	} );

	new trelloController();
})( jQuery );