<?php 
namespace NinjaForms\Trello\Contracts;

interface SettingRetriever{

    /**
     * Retrieve NF Setting value, with optional fallback
     *
     * The 'mixed' return declaration is a pseudo type that is not available in
     * PHP 7; it only is allowed in PHP 8+.  After support for PHP 7 is
     * completely dropped,  the return type can be un-commented.
     * 
     * @param string $key
     * @param mixed $fallback
     * @return mixed
     */
    public function getNfSettingValue(string $key, $fallback = null )/*: mixed*/;
}