<?php 
namespace NinjaForms\Trello\Factories;

use NinjaForms\Trello\Contracts\SettingRetriever as ContractsSettingRetriever;
use \trello_oauth;
use NinjaForms\Trello\admin\SettingRetriever;
/**
 * Master factory that produces required objects
 *
 * Constructs both simple objects and other factories should they be needed for
 * run time construction
 */
class MasterFactory{


    /**
     * Make Trello Oauth object, maybe with new authorization since Nov 2021
     *
     * Authorization process changed, old method sunset November 2021. New
     * process disallows previous wildcard authorization keys, but existing
     * installs may still allow them.  
     * 
     * @param string $oauth_token
     * @param string $oauth_token_secret
     * @return trello_oauth
     */
    public function makeTrelloOauth( $oauth_token = null, $oauth_token_secret = null): trello_oauth
    {
        $settingsRetriever = $this->makeSettingRetriever();

        $developerKey = $settingsRetriever->getNfSettingValue('trello_developer_key',null);
        $oauthSecret = $settingsRetriever->getNfSettingValue('trello_oauth_secret',null);
        
        $return = new trello_oauth($oauth_token, $oauth_token_secret, $developerKey,$oauthSecret);

        return $return;
    }

    /**
     * Make SettingRetriever object
     * 
     *
     * @return ContractsSettingRetriever
     */
    public function makeSettingRetriever( ): ContractsSettingRetriever
    {
        $return = new SettingRetriever();

        return $return;
    }
}