<?php 
namespace NinjaForms\Trello\admin;

/**
 * Registers the plugin settings with NF core
 */
class PluginSettings{


    /**
     * Configuration for plugin settings
     *
     * @var array
     */
    protected $pluginSettingsConfiguration;

    /**
     * Configuration of the setting group
     *
     * @var array
     */
    protected $pluginGroupConfiguration;

    /**
     * Register the plugin settings
     *
     * Class should be instantiated and this method called immediately upon
     * loading.  Internally, this method will handle the timing.
     * @return void
     */
    public function handle( ): void
    {
        add_action('ninja_forms_loaded',[$this, 'registerFilters']);

        $this->configureSettings();
    }

    /**
     * Registers plugin settings and group settings by hooking into filter
     *
     * @return void
     */
    public function registerFilters(): void
    {
        add_filter('ninja_forms_plugin_settings', array( $this, 'pluginSettings' ), 10, 1);

        add_filter('ninja_forms_plugin_settings_groups', array( $this, 'pluginGroupSettings' ), 10, 1);
    }

    /**
     * Add this plugin's settings to the settings page under the group key
     *
     * @param array $incomingSettings
     * @return array
     */
    public function pluginSettings(array $incomingSettings): array
    {
        $outgoingSettings = $incomingSettings;
        
        $outgoingSettings['trello_settings'] = $this->pluginSettingsConfiguration; // key must match group settings id

        return $outgoingSettings;
    }

    /**
     * Create a new group section on the NF settings page
     *
     * @param array $incomingSettings
     * @return array
     */
    public function pluginGroupSettings(array $incomingSettings): array
    {
        $outgoingSettings = $incomingSettings;
        
        $outgoingSettings['trello_settings'] = $this->pluginGroupConfiguration; // key must match group settings id

        return $outgoingSettings;
    }

    /**
     * Retrieve the configured settings
     *
     * @return void
     */
    protected function configureSettings( ): void
    {
        $this->pluginSettingsConfiguration = include(\dirname(__FILE__,2).'/config/plugin-settings.php');
        $this->pluginGroupConfiguration = include(\dirname(__FILE__,2).'/config/plugin-group-settings.php');
    }
}