<?php 
namespace NinjaForms\Trello\admin;

use NinjaForms\Trello\Contracts\SettingRetriever as ContractsSettingRetriever;

/**
 * Retrieve NF Setting value using Ninja_Forms()->get_setting
 * 
 */
class SettingRetriever implements ContractsSettingRetriever{

    /** @inheritDoc */
    public function getNfSettingValue(string $key, $fallback = null )/*: mixed*/{

        $return = $fallback;

        if(\class_exists('Ninja_Forms')){
            $return = \Ninja_Forms()->get_setting($key,$fallback);
        }

        return $return;
    }
}