<?php if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class NF_Trello_Admin_Upgrade {

	/**
	 * NF_Trello_Admin_Upgrade constructor.
	 */
	public function __construct() {
		add_filter( 'ninja_forms_upgrade_settings', array( $this, 'upgrade' ), 99 );
		add_filter( 'ninja_forms_after_upgrade_settings', array( $this, 'after_upgrade' ), 99 );
	}

	/**
	 * Upgrade the settings and field settings when NF core is upgraded to 3.0
	 *
	 * @param array $form
	 *
	 * @return array
	 */
	public function upgrade( $form ) {
		$action = array(
			'trello' => array(
				'type'   => 'trello',
				'label'  => 'Trello',
				'active' => '1',
			),
		);

		if ( ! isset( $form['settings']['trello_lists'] ) || empty( $form['settings']['trello_lists'] ) ) {
			return $form;
		}

		$action['trello']['trello_organization'] = $form['settings']['trello_orgs'];
		$action['trello']['trello_board']        = $form['settings']['trello_boards'];
		$action['trello']['trello_list']         = $form['settings']['trello_lists'];
		$action['trello']['trello_position']     = $form['settings']['card_position'];

		if ( isset( $form['settings']['card_labels'] ) && is_array( $form['settings']['card_labels'] ) ) {
			foreach ( $form['settings']['card_labels'] as $label ) {
				$action['trello'][ 'trello_labels_' . $label ] = "1";
			}
		}

		if ( isset( $form['settings']['card_members'] ) && is_array( $form['settings']['card_members'] ) ) {
			foreach ( $form['settings']['card_members'] as $member ) {
				$action['trello'][ 'trello_members_' . $member ] = "1";
			}
		}

		$card_link  = array();
		$card_name  = array();
		$card_descp = array();
		foreach ( $form['fields'] as $key => $field ) {
			if ( isset( $field['data']['trello_card_attach'] ) && "1" === $field['data']['trello_card_attach'] ) {
				$action['trello'][ 'field_list_fu_email_attachments-' . $key ] = "1";
				unset( $field['data']['trello_card_attach'] );
			}

			if ( ! isset( $field['data']['trello_card_type'] ) ) {
				$form['fields'][ $key ] = $field;
				continue;
			}

			if ( 'link' === $field['data']['trello_card_type'] ) {
				$card_link[] = '{field:' . $key . '}';
				unset( $field['data']['trello_card_type'] );
			} else if ( 'title' === $field['data']['trello_card_type'] ) {
				$card_name[] = '{field:' . $key . '}';
				unset( $field['data']['trello_card_type'] );
			} else if ( 'descp' === $field['data']['trello_card_type'] ) {
				$card_descp[] = '{field:' . $key . '}';
				unset( $field['data']['trello_card_type'] );
			}

			$form['fields'][ $key ] = $field;
		}

		$action['trello']['card_link']  = implode( "\r\n", $card_link );
		$action['trello']['card_name']  = implode( "\r\n", $card_name );
		$action['trello']['card_descp'] = implode( "\r\n", $card_descp );

		$form['actions'] = array_merge( $form['actions'], array_values( $action ) );

		return $form;
	}

	/**
	 * Replace old keys with new Field keys
	 *
	 * @param array $form
	 *
	 * @return array
	 */
	public function after_upgrade( $form ) {
		// Replace field IDs with keys in actions
		foreach ( $form['actions'] as $action_key => $action ) {
			if ( 'trello' !== $action['type'] ) {

				continue;
			}

			foreach ( $form['fields'] as $field_key => $field ) {
				if ( isset( $action[ 'field_list_fu_email_attachments-' . $field_key ] ) ) {
					$new_key = 'field_list_fu_email_attachments-' . $field['key'];

					$action[ $new_key ] = $action[ 'field_list_fu_email_attachments-' . $field_key ];
					unset( $action[ 'field_list_fu_email_attachments-' . $field_key ] );
				}

				$action['card_link']  = str_replace( '{field:' . $field_key . '}', '{field:' .  $field['key'] . '}', $action['card_link'] );
				$action['card_name']  = str_replace( '{field:' . $field_key . '}', '{field:' .  $field['key'] . '}', $action['card_name'] );
				$action['card_descp'] = str_replace( '{field:' . $field_key . '}', '{field:' .  $field['key'] . '}', $action['card_descp'] );
			}

			$form['actions'][ $action_key ] = $action;
		}


		return $form;
	}

	/**
	 * Add email attachments to the action
	 *
	 * @param array $action
	 * @param array $form
	 *
	 * @return array
	 */
	protected function email_attachments( $action, $form ) {
		if ( 'email' !== $action['type'] ) {
			return $action;
		}

		foreach ( $form['fields'] as $key => $field ) {
			if ( '_table_editor' !== $field['type'] ) {
				// Not an upload field
				continue;
			}

			if ( ! isset( $action[ 'table_editor_' . $field['id'] ] ) || 1 != $action[ 'table_editor_' . $field['id'] ] ) {
				continue;
			}

			$action[ NF_TE_Integrations_NinjaForms_Attachments::KEY . '-' . $key ] = 1;
		}

		return $action;
	}
}