<?php

$labels = array();

$all_labels = array( 'green', 'yellow', 'orange', 'red', 'purple', 'blue' );

foreach ( $all_labels as $label ) {
	$labels[] = array(
		'name'  => 'trello_labels_' . $label,
		'type'  => 'toggle',
		'label' => ucfirst( $label ),
		'value' => $label,
		'width' => 'one-third',
	);
}

return apply_filters( 'ninja_forms_trello_action_settings', array(
	'trello_organization' => array(
		'name'     => 'trello_organization',
		'type'     => 'select',
		'options'  => array( array( 'label' => __( 'Loading Organizations' ), 'value' => $org_id ) ),
		'group'    => 'primary',
		'label'    => __( 'Organization', 'ninja-forms-trello' ),
		'value'    => $org_id,
		'disabled' => true,
	),
	'trello_board'        => array(
		'name'     => 'trello_board',
		'type'     => 'select',
		'options'  => array( array( 'label' => __( 'Loading Boards' ), 'value' => $board_id ) ),
		'group'    => 'primary',
		'label'    => __( 'Board', 'ninja-forms-trello' ),
		'value'    => $board_id,
		'disabled' => true,
	),
	'trello_list'         => array(
		'name'     => 'trello_list',
		'type'     => 'select',
		'options'  => array( array( 'label' => __( 'Loading Lists' ), 'value' => $list_id ) ),
		'group'    => 'primary',
		'label'    => __( 'List', 'ninja-forms-trello' ),
		'value'    => $list_id,
		'disabled' => true,
	),
	'card_name'           => array(
		'name'           => 'card_name',
		'type'           => 'textbox',
		'group'          => 'primary',
		'label'          => __( 'Card Name', 'ninja-forms-trello' ),
		'value'          => '',
		'width'          => 'full',
		'use_merge_tags' => true,
	),
	'card_descp'          => array(
		'name'           => 'card_descp',
		'type'           => 'textarea',
		'group'          => 'primary',
		'label'          => __( 'Card Description', 'ninja-forms-trello' ),
		'placeholder'    => '',
		'value'          => '',
		'width'          => 'full',
		'use_merge_tags' => true,
	),
	'card_link'           => array(
		'name'           => 'card_link',
		'type'           => 'textbox',
		'group'          => 'primary',
		'label'          => __( 'Attachment Links', 'ninja-forms-trello' ),
		'value'          => '',
		'width'          => 'full',
		'help'           => __( 'New links on separate lines', 'ninja-forms-trello'),
		'use_merge_tags' => true,
	),
	'trello_position'     => array(
		'name'    => 'trello_position',
		'type'    => 'select',
		'options' => array(
			array( 'label' => __( 'Bottom', 'ninja-forms-trello' ), 'value' => 'bottom' ),
			array( 'label' => __( 'Top', 'ninja-forms-trello' ), 'value' => 'top' ),
		),
		'group'   => 'advanced',
		'label'   => __( 'Card Position', 'ninja-forms-trello' ),
		'value'   => 'bottom',
	),
	'trello_labels'       => array(
		'name'     => 'trello_labels',
		'label'    => __( 'Card Labels', 'ninja-forms-trello' ),
		'type'     => 'fieldset',
		'group'    => 'advanced',
		'settings' => $labels,
	),
	'card_members'        => array(
		'name'     => 'card_members',
		'label'    => __( 'Card Members', 'ninja-forms-trello' ),
		'type'     => 'fieldset',
		'group'    => 'advanced',
		'settings' => array(),
	),
) );