<?php
require_once dirname( __FILE__ ) . '/abstracts/addon.php';
require_once dirname( __FILE__ ) . '/oauth/oauth-trello.php';

/**
 * Class NF_Trello
 */
final class NF_Trello extends NF_PVW_Abstract_Addon {

	public $plugin_name = 'Trello';
	public $plugin_option_prefix = 'nf_trello';
	protected $class_prefix = 'NF_Trello';
	protected $textdomain = 'ninja-forms-trello';

	protected $settings;

	/**
	 * Load the Table Editor plugin for deprecated Ninja Form installs
	 */
	protected function load_deprecated() {
		require_once dirname( $this->plugin_file_path ) . '/deprecated/deprecated-class-trello.php';
		if ( ! defined( 'NINJA_FORMS_TRELLO_URL' ) ) {
			define( 'NINJA_FORMS_TRELLO_URL', plugins_url() . "/" . basename( dirname( $this->plugin_file_path ) ) );
		}

		new ninja_form_trello( $this->plugin_name );
	}

	/**
	 * Load all the 3.0+ plugin code
	 */
	public function load_plugin() {}

	/**
	 * @return bool
	 */
	protected function is_ninja_forms_three() {
		// Perform update if necessary for forms
		new NF_Trello_Admin_Upgrade();

		return parent::is_ninja_forms_three();
	}

	/**
	 * Initialize THREE code
	 */
	protected function three_init() {
		$this->settings = new NF_Trello_Admin_Menus_Settings();
		$this->settings->init();

		(new \NinjaForms\Trello\admin\PluginSettings())->handle();

		add_filter( 'ninja_forms_register_actions', array( $this, 'register_actions' ) );
	}

	/**
	 * Get the Trello access token
	 *
	 * @return bool|string
	 */
	public function get_trello_access_token() {
		if ( ! $this->settings->connected() ) {
			return false;
		}

		$access_token = $this->settings->get_access_token();
		if ( ! $access_token ) {
			return false;
		}

		return $access_token;
	}

	/**
	 * Register actions.
	 *
	 * @param array $actions
	 *
	 * @return array
	 */
	public function register_actions( $actions ) {
		$access_token = $this->get_trello_access_token();
		if ( false === $access_token ) {
			return $actions;
		}

		$actions['trello'] = new NF_Trello_Actions_Action( $access_token );

		return $actions;
	}
}