<?php
/*
* Plugin Name: Ninja Forms - Trello
* Plugin URI: https://ninjaforms.com/extensions/trello/
* Description: Create Trello cards from your Ninja Forms submissions
 * Version: 3.0.4
 * Author: Saturday Drive
 * Author URI: http://ninjaforms.com/?utm_source=Ninja+Forms+Plugin&utm_medium=Plugins+WP+Dashboard
* Text Domain: ninja-forms-trello
* Domain Path: /languages/
*
* Copyright 2014  SaturdayDrive
*
* Release Description: Merge branch 'release-3.0.4'

* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 3, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Load PSR-4 autoloader from composer
 *
 * @param string $rootFileLocation
 * @return boolean
 */
function nFTrelloAutoloader(string $rootFileLocation): bool
{
    $autoloader = dirname($rootFileLocation) . '/vendor/autoload.php';

    if (file_exists($autoloader)) {
        include_once $autoloader;
        $return = true;
    } else {
        $return = false;
    }
    return $return;
}
// Add autoloader
$autoload = nFTrelloAutoloader(__FILE__);

if (!$autoload) {
    return;
}

/**
 * The main function responsible for returning the one true instance to functions everywhere.
 */
function NF_Trello() {
	// Load our main plugin class
	require_once dirname( __FILE__ ) . '/includes/trello.php';
	$plugin_version = '3.0.4';

	return NF_Trello::instance( 'NF_Trello', __FILE__, $plugin_version );
}

NF_Trello();