<?php

/**
 * Reviewer Plugin v.3.15.0
 * Created by Michele Ivani
 */

class RWP_User_Reviews_Shortcode
{
	// Instace of this class
	protected static $instance = null;

	protected $shortcode_tag = 'rwp_user_reviews';

	protected $plugin_slug = 'reviewer';

	private $default_preferences;

	private $preferences;

	function __construct()
	{
		add_shortcode($this->shortcode_tag, array($this, 'render'));
		add_action('wp_enqueue_scripts', array($this, 'localize_script'));
	}

	public function render($atts)
	{
		// Shortcode attributes.	
		extract(shortcode_atts(array(
			'user' 		=> '0',
			'order'		=> 'latest',
			'url'		=> '',
			'limit'		=> null,
			'stats'		=> 'true',
		), $atts));

		// Component ID, VueJS.
		$component_id = uniqid('rwp-component-');

		// Preferences.
		$this->preferences = get_option('rwp_preferences', array());

		// Get the user ID.
		$user = $this->parse_user($user);

		if ($user == false) {
			return '<p class="rwp-rosu__notice">' . __('Error. Please configure the profile setting.', 'reviewer') . '</p>';
		}

		// User
		$user_obj = new RWP_User($user);

		// Verified badge.
		$verified_badge = $this->preferences_field('preferences_user_review_verified_badge', true);

		// Stats
		$show_stats = ($stats === 'false') ? false : true;

		ob_start();

		include('themes/layout-user-reviews-shortcode.php');

		return ob_get_clean();
	}

	public function localize_script()
	{
		$action_name = 'rwp_reviews_of_single_user';
		wp_localize_script($this->plugin_slug . '-front-end-script', 'reviewerReviewsOfSingleUser', array('ajax_nonce' => wp_create_nonce($action_name), 'ajax_url' => admin_url('admin-ajax.php'), 'action' => $action_name));
	}

	public function parse_user($value)
	{
		if ($value == 'current') {
			return get_current_user_id();
		}

		$user_id = intval($value);
		if ($user_id >= 0) {
			return $user_id;
		}

		$setting = $this->preferences_field('preferences_profile_link', true);

		if (!isset($setting['structure']) || !isset($setting['tag']) || empty($setting['structure'])) {
			return false;
		}

		$tag = $setting['tag'];

		// Current url.
		$url = $this->get_current_url();
		$parse = wp_parse_url($url);

		// Pattern url.
		$pattern = $setting['structure'];
		$pattern_parse = wp_parse_url($pattern);

		$subject = $parse['path'];
		$patter_path = $pattern_parse['path'];

		// Fix last slash.
		if (substr($subject, -1) == '/') {
			if (substr($patter_path, -1) != '/') {
				$patter_path = $patter_path .= '/';
			}
		} else {
			if (substr($patter_path, -1) == '/') {
				$patter_path = substr($patter_path, 0, -1);
			}
		}

		// Extract the template.
		$pattern = "@^" . preg_replace('/\\%[a-zA-Z0-9\_\-]+\%/', '([a-zA-Z0-9\-\_]+)', preg_quote($patter_path)) . "$@D";
		$res = preg_match($pattern, $subject, $matches);
		// var_dump($patter_path, $pattern, $subject, $matches);

		if ($res < 1 || $res === false || count($matches) != 2) {
			return false;
		}

		array_shift($matches);

		if (!isset($matches[0])) {
			return false;
		}

		if ($tag == 'username') {
			$user = get_user_by('login', $matches[0]);
			if ($user === false) {
				return 0;
			}

			return $user->ID;
		}

		if ($tag == 'id' && is_numeric($matches[0])) {
			return intval($matches[0]);
		}

		return 0;
	}

	function get_current_url($no_query_params = false)
	{
		wp_fix_server_vars();

		if (defined('WP_CLI') && WP_CLI) {
			$host = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : 'localhost';
		} else {
			if (isset($_SERVER['HTTP_HOST'])) {
				$host = $_SERVER['HTTP_HOST'];
			} else {
				$host = 'localhost';
			}
		}

		$page_url = (is_ssl() ? 'https://' : 'http://') . $host . $_SERVER['REQUEST_URI'];

		if ($no_query_params == true) {
			$page_url = strtok($page_url, '?');
		}

		return $page_url;
	}

	public function preferences_field($field, $return = false)
	{
		if (null == $this->default_preferences) {
			$this->default_preferences = RWP_Preferences_Page::get_preferences_fields();
		}

		$value = isset($this->preferences[$field]) ? $this->preferences[$field] : $this->default_preferences[$field]['default'];

		if ($return)
			return $value;

		echo $value;
	}

	public static function get_instance()
	{
		// If the single instance hasn't been set, set it now.
		if (null == self::$instance) {
			self::$instance = new self;
		}

		return self::$instance;
	}
}
