<?php
$text_color = $this->template_field('template_text_color', true);
$font_size  = $this->template_field('template_box_font_size', true);
$user = wp_get_current_user();
if (!($user instanceof WP_User)) {
    $user = new stdClass;
    $user->ID = 0;
    $user->display_name = __('Anonymous', 'reviewer');
}

$can_manage_reviews = current_user_can('rwp_manage_user_reviews');

switch ($reply_auth['option']) {
    case 'logged_in':
        $login_required = true;
        $user_can_reply = is_user_logged_in();
        break;
    case 'limited_users':
        $user_can_reply = (isset($reply_auth['ids']) && is_array($reply_auth['ids']) && in_array($user->ID, $reply_auth['ids']));
        $login_required = false;
        break;
    case 'advanced':
        $login_required = false;
        $user_can_reply = false;

        if (!isset($reply_auth['rules']) || !is_array($reply_auth['rules']) || $user->ID == 0) {
            break;
        }

        foreach ($reply_auth['rules'] as  $rule) {
            if (!isset($rule['user']) || !isset($rule['posts']) || !is_array($rule['posts']) || $user->ID != $rule['user']) {
                continue;
            }
            $allowed = in_array($this->post_id, $rule['posts']);
            if ($allowed === true) {
                $user_can_reply = true;
                // $can_manage_reviews = true;
                break;
            }
        }
        break;
    case 'everyone':
    default:
        $user_can_reply = true;
        $login_required = false;
        break;
}
?>
<rwp-replies inline-template v-bind:replies="review.rating_replies" v-bind:review-id="review.rating_id" v-bind:post-id="review.rating_post_id" action="<?php echo RWP_Reply::$submit_action_name ?>" action-delete="<?php echo RWP_Reply::$delete_action_name ?>" action-edit="<?php echo RWP_Reply::$edit_action_name ?>" security="<?php echo RWP_Reply::get_submit_nonce() ?>" security-edit="<?php echo RWP_Reply::get_edit_nonce() ?>" security-delete="<?php echo RWP_Reply::get_delete_nonce() ?>" endpoint="<?php echo admin_url('admin-ajax.php') ?>" v-bind:user-id="<?php echo $user->ID ?>" v-bind:user-can-reply="<?php echo $user_can_reply ? 'true' : 'false' ?>" v-bind:per-page="3" v-show="review.show_replies" deletion-message="<?php _e('Do you confirm the reply deletion?', 'reviewer') ?>">
    <div class="rwp-replies" style="font-size: <?php echo $font_size ?>px; color: <?php echo $text_color ?>;">

        <p v-if="!userCanReply && replies.length == 0"><?php _e('This review has no replies yet.', 'reviewer') ?></p>

        <div class="rwp-reply" v-for="(rInd, reply) in replies | limitBy toShow">

            <?php if ($can_manage_reviews) : ?>
                <div v-if="reply.reply_id == replyToEdit">
                    <div class="rwp-reply__manager-input-wrap" style="display: flex; align-items: center">
                        <div style="flex: 1; margin-right: 20px;">
                            <label class="rwp-reply__manager-label"><?php _e('Author ID', 'reviewer') ?></label>
                            <input type="text" v-model="reply.reply_user_id" class="rwp-reply__text-input rwp-reply__manager-input" />
                        </div>
                        <div style="flex: 3;">
                            <label class="rwp-reply__manager-label"><?php _e('Author Name', 'reviewer') ?></label>
                            <input type="text" v-model="reply.reply_author_name" class="rwp-reply__text-input rwp-reply__manager-input" />
                        </div>
                    </div>
                    <div class="rwp-reply__manager-input-wrap">
                        <label class="rwp-reply__manager-label"><?php _e('Date', 'reviewer') ?></label>
                        <input type="text" v-model="reply.reply_date" class="rwp-reply__text-input rwp-reply__manager-input" placeholder="<?php _e('YYYY-MM-DD HH:MM', 'reviewer') ?>" />
                    </div>
                    <div class="rwp-reply__manager-input-wrap">
                        <label class="rwp-reply__manager-label"><?php _e('Comment', 'reviewer') ?></label>
                        <textarea v-model="reply.reply_comment" class="rwp-reply__text-input rwp-reply__manager-input"></textarea>
                    </div>
                    <div class="rwp-reply__manager-input-wrap" style="display: flex; justify-content: flex-end">
                        <span class="rwp-reply__manager-done" @click.prevent="updateReply(reply, rInd)"><?php _e('Update', 'reviewer') ?></span>
                    </div>
                </div>

                <div v-else>
                <?php endif; ?>
                <p v-html="reply.reply_comment | nl2br"></p>

                <div class="rwp-reply__info">
                    <div class="rwp-reply__author">
                        <div>
                            <img v-bind:src="reply.reply_author_avatar" alt="Avatar">
                        </div>
                        <span v-text="reply.reply_author_name"></span>
                    </div>
                    <span class="rwp-reply__created-at" v-text="reply.reply_created_at"></span>
                </div>
                <?php if ($can_manage_reviews) : ?>
                </div>

                <div class="rwp-reply__manager-action">
                    <span v-on:click="editReply(reply, rInd)"><?php _e('Edit', 'reviewer') ?></span> | <span v-on:click="deleteReply(reply)"><?php _e('Delete', 'reviewer') ?></span>
                </div>
            <?php endif; ?>
        </div><!-- /reply -->

        <span class="rwp-more-urs-btn" v-on:click="showMore" v-if="toShow < replies.length"><?php _e('Show more', $this->plugin_slug) ?></span>

        <?php if ($user_can_reply) : ?>
            <div class="rwp-reply__form">
                <?php if ($user->ID == 0) : ?>
                    <input class="rwp-reply__text-input" type="text" v-model="userName" placeholder="<?php _e('Write your name', 'reviewer') ?>" style="font-size: <?php echo $font_size ?>px; color: <?php echo $text_color ?>;">
                <?php endif; ?>

                <div class="rwp-reply__input">
                    <textarea v-model="commentText" placeholder="<?php _e('Reply to this review', 'reviewer') ?>" style="font-size: <?php echo $font_size ?>px; color: <?php echo $text_color ?>;" v-on:input="onInput" rows="1"></textarea>

                    <span class="rwp-reply__submit" v-bind:class="{'rwp-cursor-not-allowed': isSubmitNotAllowed}" v-on:click.prevent="submitReply">
                        <svg fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="#718096">
                            <path d="M9 5l7 7-7 7"></path>
                        </svg>
                    </span>
                </div>

                <div class="rwp-reply__footer">
                    <span class="rwp-reply__user"><?php ($user->ID > 0) ? printf(__('Logged in as %s', 'reviewer'), $user->display_name) : '' ?></span>
                    <span class="rwp-reply__feedback" v-text="feedback"></span>
                    <span class="rwp-loader" v-show="isProccessing"></span>
                </div>
            </div><!-- /reply form -->
        <?php endif; ?>

        <?php if (!$user_can_reply && $login_required) :
            $reply_custom_login = $this->preferences_field('preferences_custom_login_link', true);
            $login_url = empty($reply_custom_login) ? wp_login_url(get_permalink()) : $reply_custom_login;
        ?>
            <div class="rwp-reply__login-link"><a href="<?php echo $login_url; ?>"><?php _e('Please login to reply', 'reviewer') ?></a></div>
        <?php endif ?>
    </div><!-- /replies -->
</rwp-replies>