<?php
/**
 * Snax Image Card
 *
 * @package snax 1.11
 * @subpackage FrontendSubmission
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}
?>

<div class="snax-image snax-object" data-snax-id="<?php the_ID(); ?>">

	<div class="snax-object-container">
		<?php do_action( 'snax_before_card_media' ); ?>

		<?php
        if ( wp_attachment_is_image( get_the_ID() ) ) {
            echo wp_get_attachment_image( get_the_ID(), apply_filters( 'snax_get_item_image_size', 'post-thumbnail' ) );
        } else {
            snax_the_card_image();
        }
        ?>

		<?php do_action( 'snax_after_card_media' ); ?>
	</div>

    <?php if ( apply_filters( 'snax_item_delete_link_allowed', true ) ): ?>

	<div class="snax-object-actions">
		<?php snax_render_item_delete_link( array(
			'classes' => array(
				'snax-object-action',
				'snax-media-action',
				'snax-media-action-delete',
			),
		) ); ?>
	</div>

    <?php endif; ?>
</div>
