# Building a form

This guide will walk you through the steps to create a form from scratch.

If you wish to install example forms you can do so via `Super Forms` > `Demos`.

## 1. Creating a new form

Before we start creating our first form, we will first have to walk through the **Global Settings**.

You can find these under `Super Forms` > `Settings`.

Make sure all the settings are correctly setup for your needs and click the `Save Settings` button at the bottom left corner.

Now we have our global setting correctly setup, we can proceed to create our first form.

To create a new form navigate to `Super Forms` > `Create Form`.

You will now see the **Form setup wizard** where you will be able to review the most important form settings based on your global settings.
If necessary change them accordingly and click on the `Save settings` button.

If not, you can proceed by clicking the `Skip wizard` button.

This will create a new form from scratch and save it with the settings based on your **Global Settings**.

?> **NOTE:** The Global Settings will never affect previously created form settings if they do not share the same values. It's good practise to change settings on the form itself after creating one.

## 2. Adding elements

Now we can add fields and elements to our form.
On the right side of the page you can find a panel with the following sections:

* **Element Settings & Options** - Contains settings related to an element that you are currently editing.
* **Layout Elements** - Contains [Columns](columns) and [Multi-part](multi-parts) elements
* **Form Elements** - Contains all fields such as [Text field](text), [Dropdown](dropdown), [Checkboxes](checkbox) etc.
* **HTML Elements** - Contains all HTML elements such as **Headings** , **Spacer**, **Google Map** etc.
* **Form Settings** - Here you can change all the settings related to this specific form

Now let's add our first element to our form.
Open up the `Form Elements` section by clicking on it and pick any of the elements you wish to add to your form.
For this guide it doesn't matter which one you choose.
Simply drag & drop the element over the "Drop Elements Here" and release your mouse button to drop it in place.

The new element should now be visible. :smiley:

## 3. Updating elements

In most cases you will want to edit the element. You can do this by clicking on the pencil :pencil2: icon.

This should open up the **Element Settings & Options** section which allows you to change the element settings.

Each element has it's own settings, some have more advanced settings than others.

If you need more information about a specific field and it's settings you can find it under the [Form Elements](text) guide.

After you are done making the necessary changes for your element click `Update Element` button.

Your element is now updated and the changes you made should now be visible (if they are visible changes of course).

This process is the same for all other elements. Now go ahead and play around by adding more elements and visually build the form you wish to create.

## 4. Preview your form

If you want to know how the form would look on the front-end of your website you can use the `Preview` mode which you can find at the top right of your screen.
After you are done and satisfied with your form click the `Save` button at the top right of your screen to save the form.

Remember that any settings you wish to change for the form, you will have to do this via the **Form Settings** section.

_(the global settings will now no longer take affect since you already saved this form)_.

## 5. Publishing your form

Your form is now ready to be placed on your site's front-end.

Simply copy (_CTRL+C_ ) the shortcode `[super_form id="xxxx"]` which you can find at the top left on the form builder page.
Once copied, paste (_CTRL+V_ ) the shortcode anywhere on your site (normally within your page content).

But you can place it anywhere you wish, such as a text widget or anywhere your theme handles shortcodes.

If you are using Visual Composer (JS Composer) you can also add the Super Forms element and choose the form from a dropdown which makes life just a little bit easier. :wink:

## 6. Testing your form

Ready for testing! :smiley: Let's now go ahead and test your form on the front-end.

Just fill out the form yourself and see if everything works as expected.

If everything isn't working as expected you can try to find your answer in our [FAQ](faq).

Couldn't find your answer? Then [contact support](support) and provide as much details as possible regarding your issue and hopefully we can help you out!
