Vue.component('field-calculation_options', {
    template: '#tmpl-wpuf-field-calculation_options',

    mixins: [
        wpuf_mixins.option_field_mixin
    ],

    props: {
        field: [String, Number, Object],
        enable_calculation: '',
        filter: {
            type: String,
            default: null
        },
    },

    data: function() {
        return {
            type: null,
            fieldsonly: true,
            formula_field: '',
        };
    },

    created: function () {
        this.formula_field = this.editing_form_field.formula_field;
    },

    computed: {
        form_fields: function () {
            var template = this.filter,
                fields = this.$store.state.form_fields;

            if (template !== null) {
                return fields.filter(function(item) {
                    return item.template === template;
                });
            }

            // remove the action/hidden fields
            return fields.filter(function(item) {
                return !_.contains( [ 'action_hook', 'custom_hidden_field'], item.template );
            });
        },

        update_formula_field: function() {
            return this.formula_field;
        },

    },

    methods: {

        insertOperator: function ( value ) {
            return this.formula_field += value;
        },

        insertOperand: function ( val1, val2 ) {
            return this.formula_field += val2;
        },

        validateExpression: function() {
            var scope = {};
            for ( var i=0; i < this.$store.state.form_fields.length; i++ ) {
                var index = this.$store.state.form_fields[i].name;
                scope[index] = 1;
            }
            try {
                var expr = this.editing_form_field.formula_field.split( '%' ).join( '' );
                var result = math.eval( String( expr ), scope );
                if ( result ) {
                    alert( this.i18n.valid_formula );
                }
            } catch( error ) {
                alert( this.i18n.invalid_formula );
            }
        },
    },

    watch: {
        update_formula_field: function ( new_opts ) {
            this.update_value( 'formula_field', new_opts );
        },
    },
});
