Vue.component('field-field-payment_method', {
    mixins: [wpuf_mixins.option_field_mixin],
    template: '#tmpl-wpuf-field-payment_method',
    data: function(){
        return {
            'paypal': false,
            'stripe': false,
            'card_images': [],
            'paypal_image': 'https://www.paypalobjects.com/webstatic/mktg/logo/AM_mc_vs_dc_ae.jpg',
            'paypal_label': 'PayPal',
            'stripe_label': 'Stripe',
        };
    },
    computed: {
        settings: function(){
            return this.$store.state.settings;
        }
    },
    created: function () {
        this.paypal = this.settings.payment_paypal_deactivate ? '' : '1';
        this.stripe = this.settings.payment_stripe_deactivate ? '' : '1';
        this.card_images = this.settings.payment_stripe_images;
        this.paypal_image = this.settings.payment_paypal_images;
        this.stripe_label = this.settings.payment_stripe_label;
        this.paypal_label = this.settings.payment_paypal_label;
    },

    watch: {
        paypal: function(val){
            this.$store.state.settings.payment_paypal_deactivate = val ? '' : '1';
        },
        stripe: function(val){
            this.$store.state.settings.payment_stripe_deactivate = val ? '' : '1';
        },
        card_images: function(val){
            this.$store.state.settings.payment_stripe_images = val;
        },
        stripe_label: function(val){
            this.$store.state.settings.payment_stripe_label = val;
        },
        paypal_label: function(val){
            this.$store.state.settings.payment_paypal_label = val;
        },
        paypal_image: function(val){
            this.$store.state.settings.payment_paypal_images = val;
        },
    },
});