/**
 * Common settings component for multiple field
 */
Vue.component('field-product-data', {
    template: '#tmpl-wpuf-field-product-data',

    mixins: [
        wpuf_mixins.option_field_mixin
    ],

    data: function () {
        return {
            show_value: true,
            options: [],
            select_type: 'radio',
            selected: ''
        };
    },

    computed: {
        field_options: function () {
            return this.editing_form_field.options;
        },

        field_selected: function () {
            return this.editing_form_field.selected;
        },

        field_select_type: function () {
            return this.editing_form_field.select_type;
        }
    },

    mounted: function () {

        var self = this;

        this.set_options();

        jQuery(this.$el).find('.option-field-option-chooser').sortable({
            items: '.option-field-option',
            handle: '.sort-handler',
            update: function (e, ui) {
                var item        = ui.item[0],
                    data        = item.dataset,
                    toIndex     = parseInt(jQuery(ui.item).index()),
                    fromIndex   = parseInt(data.index);

                self.options.swap(fromIndex, toIndex);
            }
        });
    },

    methods: {
        set_options: function () {
            var self = this;
            var field_options = jQuery.extend(true, {}, this.editing_form_field.options);

            _.each(field_options, function (label, value) {
                self.options.push({label: label, value: value, id: self.get_random_id()});
            });

            this.selected = this.field_selected;
            this.select_type = this.field_select_type ? this.field_select_type : 'radio';
        },

        // in case of select or radio buttons, user should deselect default value
        clear_selection: function () {
            this.selected = '';
        },

        add_option: function () {
            var count   = this.options.length,
                new_opt = 'Product' + '-' + (count + 1);

            this.options.push({
                label: 10, value: new_opt, id: this.get_random_id()
            });
        },

        delete_option: function (index) {
            if (this.options.length === 1) {
                this.warn({
                    text: this.i18n.last_choice_warn_msg,
                    showCancelButton: false,
                    confirmButtonColor: "#46b450",
                });

                return;
            }

            this.options.splice(index, 1);
        },
    },

    watch: {
        options: {
            deep: true,
            handler: function (new_opts) {
                var options = {},
                    i = 0;

                for (i = 0; i < new_opts.length; i++) {
                    options[new_opts[i].value] = new_opts[i].label;
                }

                this.update_value('options', options);
            }
        },

        selected: function (new_val) {

            this.update_value('selected', new_val);
        },

        select_type: function (new_val) {

            if ( typeof this.selected === 'object' ) {
                if ( new_val !== 'checkbox' ) {
                    this.selected = '';
                }

            } else {
                if ( new_val !== 'radio' ) {
                    this.selected = [];
                }
            }

            this.update_value('select_type', new_val);
        }
    }
});
