<div>
    <div class="panel-field-opt panel-field-opt-radio">
        <label>
            Product list type
            <help-text text="<?php _e("Use checkbox if you want to allow buying multiple product.", 'weforms-pro' ) ?>"></help-text>
        </label>
        <ul class="list-inline">
            <li>
                <label>
                    <input type="radio" value="radio" v-model="select_type"> Radio
                </label>
            </li>
            <li>
                <label>
                    <input type="radio" value="checkbox" v-model="select_type"> Checkbox
                </label>
            </li>
        </ul>
    </div>

    <div class="panel-field-opt panel-field-opt-text">
        <label class="clearfix">
            {{ option_field.title }} <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
        </label>

        <ul :class="['option-field-option-chooser', show_value ? 'show-value' : 'show-value']">
            <li class="clearfix margin-0 header">
                <div class="selector">&nbsp;</div>

                <div class="sort-handler">&nbsp;</div>

                <div class="value">
                    <?php _e( 'Name', 'wpuf' ); ?>
                </div>

                <div class="label">
                    <?php _e( 'Price', 'wpuf' ) ?>
                </div>

                <div class="action-buttons">&nbsp;</div>
            </li>
        </ul>

        <ul :class="['option-field-option-chooser margin-0', show_value ? 'show-value' : 'show-value']">
            <li v-for="(option, index) in options" :key="option.id" :data-index="index" class="clearfix option-field-option">
                <div class="selector">

                    <template v-if="select_type == 'radio'">

                        <input
                            type="radio"
                            :value="option.value"
                            v-model="selected"
                        >
                    </template>

                    <template v-else>
                        <input
                            type="checkbox"
                            :value="option.value"
                            v-model="selected"
                        >

                    </template>


                </div>

                <div class="sort-handler">
                    <i class="fa fa-bars"></i>
                </div>

                <div class="value">
                    <input type="text" v-model="option.value">
                </div>

                <div class="label">
                    <input type="number" v-model="option.label">
                </div>

                <div class="action-buttons clearfix">
                    <i class="fa fa-minus-circle" @click="delete_option(index)"></i>
                </div>
            </li>
            <li>
                <div class="plus-buttons clearfix" @click="add_option">
                    <i class="fa fa-plus-circle"></i>
                </div>
            </li>
        </ul>

        <a v-if="select_type == 'radio' && selected" href="#clear" @click.prevent="clear_selection"><?php _e( 'Clear Selection', 'wpuf' ); ?></a>
    </div>

</div>