Vue.component('field-selected_answers', {
    template: '#tmpl-wpuf-field-selected_answers',

    mixins: [
        wpuf_mixins.option_field_mixin
    ],

    data: function () {
        return {
            single_value: this.is_single_value(),
            answer_options: [
                {
                    id: Math.random().toString(36).substr(2, 16),
                    label: 'Option',
                    value: 'Option'
                }
            ],
            selected_answers: []
        };
    },

    computed: {
        update_answer_options: function () {
            return this.editing_form_field.options;
        },

        field_selected: function () {
            return this.editing_form_field.selected_answers;
        },

        update_total_points: function() {
            return this.editing_form_field.points;
        }
    },

    mounted: function () {
        this.set_options();
    },

    methods: {
        is_single_value: function() {
            var template    = this.editing_form_field.template;
            var is_single   = this.single_value;

            switch(template) {
                case 'checkbox_field':
                case 'multiple_select':
                    is_single = false;
                    break;
                case 'radio_field':
                case 'dropdown_field':
                    is_single = true;
                    break;
                default:
                    is_single = false;
            }

            return is_single;
        },

        set_options: function () {
            var self = this;
            var field_options = jQuery.extend(true, {}, this.editing_form_field.answer_options);

            _.each(field_options, function (label, value) {
                self.answer_options.push({label: label, value: value, id: self.get_random_id()});
            });

            if (this.option_field.is_multiple && !_.isArray(this.field_selected)) {
                this.selected_answers = [this.field_selected];
            } else {
                this.selected_answers = this.field_selected;
            }
        }
    },

    watch: {
        update_answer_options: function( new_opts ) {
            var answerOptions = [];

            jQuery.each( new_opts, function( value, label ) {
                var answerOption    = {};
                answerOption.id     = Math.random().toString(36).substr(2, 16);
                answerOption.label  = label;
                answerOption.value  = value;
                answerOptions.push(answerOption);
            });

            this.answer_options = answerOptions;
        },

        selected_answers: function ( new_val ) {
            this.update_value('selected_answers', new_val);
        },

        update_total_points: function( value, previousValue, difference ) {
            previousValue = previousValue || 0;
            difference = difference || 0;

            if ( isNaN(value) || value === '' ) {
                value = 0;
            }

            value = parseFloat(value);

            if ( value > previousValue ) {
                difference = value - previousValue;
                previousValue = value;

                return this.$store.state.settings.total_points += difference;
            } else if ( value < previousValue ) {
                difference = previousValue - value;
                previousValue = value;

                return this.$store.state.settings.total_points -= difference;
            }
        }
    }
});
