Vue.component('form-entry-resend-notifications', {
    template: '#tmpl-wpuf-form-entry-resend-notifications',
    mixins: [weForms.mixins.Loading,weForms.mixins.Cookie],

    data: function() {
        return {
            notifications: [],
        };
    },

    mounted: function() {
        this.getFormNotifications();
    },

    methods: {
        getFormNotifications: function() {
            var self = this;

            wp.ajax.send( 'weforms_form_active_notifications', {
                data: {
                    form_id: self.$route.params.id,
                    _wpnonce: weForms.nonce
                },
                success: function(response) {
                    self.notifications = response.form_notifications;
                },
                error: function(error) {
                    alert(error);
                }
            });
        },

        sendNotifications: function() {
            var self          = this,
                items         = document.querySelectorAll('input.weforms-resend-notification-item'),
                overrideEmail = document.querySelector('input.weforms-notification-override-email').value,
                notifications = [];

            items.forEach( function( item ) {
                if ( item.checked === true ) {
                    notifications.push(self.notifications[item.value]);
                }
            });

            if ( notifications.length === 0 ) {
                alert(wpuf_form_builder.i18n.selectNotification);
                return;
            }

            if ( !confirm( weForms.confirm ) ) {
                return;
            }

            if ( overrideEmail.length !== 0 ) {
                notifications.forEach( function( notification ) {
                    notification.to = overrideEmail;
                });
            }

            wp.ajax.send( 'weforms_entry_resend_notifications', {
                data: {
                    form_id: self.$route.params.id,
                    entry_id: self.$route.params.entryid,
                    notifications: notifications,
                    _wpnonce: weForms.nonce
                },

                success: function( response ) {
                    toastr.success(response.message);
                },

                error: function(error) {
                    alert(error);
                }
            });
        }
    }
});
