/**
 * Field template: Payment method
 */
Vue.component('form-payment_method', {
    template: '#tmpl-wpuf-form-payment_method',

    mixins: [
        wpuf_mixins.form_field_mixin
    ],


    computed: {
       settings: function () {
            return this.$store.state.settings;
       },

       payment_methods: function () {
            var methods = {};

            if ( ! this.settings.payment_paypal_deactivate ) {
            	methods.paypal = {
                label: this.settings.payment_paypal_label,
                img: this.settings.payment_paypal_images,
              };
            }

            if ( ! this.settings.payment_stripe_deactivate ) {
              methods.stripe = {
                label: this.settings.payment_stripe_label,
                img: this.settings.payment_stripe_images,
              };
            }

            return methods;
       },
    }
});
