<div class="wpuf-fields">

    <template v-if="payment_methods.paypal || payment_methods.stripe">
        <template v-if="payment_methods.paypal && payment_methods.stripe">
            <ul :class="['wpuf-fields-list', ('yes' === field.inline) ? 'wpuf-list-inline' : '']">
                <li v-for="(method, val) in payment_methods">
                    <label>
                        <input
                            type="radio"
                            :value="val"
                            :checked="is_selected(val)"
                        >
                        {{ method.label }}
                        <template v-if="val == 'stripe'">
                            <img v-for="image in method.img" :src="'<?php echo WEFORMS_PRO_URL ?>/modules/payment/assets/images/' +image+ '.svg'" :alt="image" style="height: 20px; margin-right: 5px; vertical-align: middle;">
                        </template>
                        <template v-else>
                            <img :src="method.img" :alt="method.label" style="height: 25px; vertical-align: middle;">
                        </template>
                    </label>
                </li>
            </ul>
        </template>
        <template v-else>
            <ul :class="['wpuf-fields-list', ('yes' === field.inline) ? 'wpuf-list-inline' : '']">
                <li v-for="(method, val) in payment_methods">
                    <label>
                        <input
                            type="radio"
                            :value="val"
                            :checked=1
                            style="display:none"
                        >
                        {{ method.label }}
                        <template v-if="val == 'stripe'">
                            <img v-for="image in method.img" :src="'<?php echo WEFORMS_PRO_URL ?>/modules/payment/assets/images/' +image+ '.svg'" :alt="image" style="height: 20px; margin-right: 5px; vertical-align: middle;">
                        </template>
                        <template v-else>
                            <img :src="method.img" :alt="method.label" style="height: 25px; vertical-align: middle;">
                        </template>
                    </label>
                </li>
            </ul>
        </template>
    </template>

    <span v-if="field.help" class="wpuf-help">{{ field.help }}</span>
</div>
