Vue.component( 'form-chart', {

    render: function (createElement) {
        return createElement(
            'div', {
                class: this.css_classes,
                style: this.styles,
            },
            [
                createElement(
                    'canvas', {
                        attrs: {
                            id: this.chart_id,
                            width: 100,
                            height: 100
                        },
                        ref: 'canvas'
                    }
                )
            ]
        );
    },

    props: {
        chart_id: {
            type: String,
            default: '',
        },
        width: {
            type: Number,
            default: 100,
        },
        height: {
            type: Number,
            default: 100,
        },
        css_classes: {
            default: '',
            type: String,
        },
        styles: {
            type: Object
        },
        chart_data: {
            default: {},
            type: Object,
        },
    },

    data: function() {
        return {
            _chart: null,
        };
    },

    mounted: function() {
        this.process_chart_data();
    },

    methods: {
        process_chart_data: function() {

            var exclude_array = [ 'file_upload', 'repeat_field', 'google_map', 'step_start', 'shortcode', 'action_hook', 'toc', 'custom_hidden_field', 'image_upload', 'section_break', 'custom_html', 'recaptcha', 'address_field' ];

            if ( this.in_array( this.chart_data.template, exclude_array ) ) {
                return;
            }

            var chart_title = this.chart_data.field_label;
            var data_set = [];
            var chart_data_var = {};
            var options1 = {},
                options2 = {};
            var chart_dataset = [
                    {
                      label: this.chart_data.field_label,
                      backgroundColor: this.chart_data.bg_color,
                      data: this.chart_data.data,
                    }
                ];

            if ( this.chart_data.template === 'checkbox_grid' || this.chart_data.template === 'multiple_choice_grid' ) {
                var count = 0;
                for( var index in this.chart_data.data ) {
                    var new_data = this.chart_data.data[index];
                    if ( !Array.isArray( new_data ) ) {
                        new_data = [new_data];
                    }
                    data_set.push( {
                      label: index,
                      backgroundColor: this.chart_data.bg_color[count++],
                      data: new_data,
                    });
                }
                chart_dataset = data_set;
            }

            chart_data_var = {
                labels: this.chart_data.label,
                datasets: chart_dataset
            };

            options1 = {
                legend: {
                    display: true,
                    position: 'top',
                    labels: {
                        fontColor: '#333'
                    }
                },
                title: {
                    display: true,
                    text: chart_title
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            min: 0,
                            beginAtZero: true,
                            stepSize: 1,
                        }
                    }]
                },
            };

            options2 = {
                legend: {
                    display: true,
                    position: 'top',
                    labels: {
                        fontColor: '#333'
                    }
                },
                title: {
                    display: true,
                    text: chart_title
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            min: 0,
                            beginAtZero: true,
                            stepSize: 1,
                        }
                    }]
                },
                tooltips: {
                    callbacks: {
                        title: function () {
                            return '';
                        },
                        label: function (item) {
                            return item.xLabel + ': ' + item.yLabel;
                        }
                    },
                },
            };

            if ( this.chart_data.template === 'checkbox_grid' || this.chart_data.template === 'multiple_choice_grid' ) {
                this.render_chart(chart_data_var, options1);
            } else {
                this.render_chart(chart_data_var, options2);
            }
        },

        render_chart: function( data, options ) {
            this.$data._chart = new Chart(
            this.$refs.canvas.getContext('2d'), {
                    type: this.chart_data.chart_type,
                    data: data,
                    options: options
                }
            );
        },

        in_array: function( needle, haystack ) {
            var length = haystack.length;
            for ( var i = 0; i < length; i++ ) {
                if ( haystack[i] === needle ) {
                    return true;
                }
            }
            return false;
        }
    },
});

weForms.routeComponents.formReports = {
    props: {
        id: [String, Number]
    },
    template: '#tmpl-wpuf-form-report',
    data: function() {
        return {
            form_title : '',
            form_id : 0,
            report_data : '',
        };
    },

    created: function() {
        this.fetchReports();
    },

    computed: {
        hasFormFields: function() {
            return Object.keys(this.entry.form_fields).length;
        },
    },

    methods: {
        fetchReports: function() {
            var self = this;

            wp.ajax.send( 'weforms_form_report', {
                data: {
                    form_id: self.$route.params.id,
                    _wpnonce: weForms.nonce
                },
                success: function( response ) {
                    if ( Object.keys( response.form_id ).length ) {
                        self.form_title = response.form_title;
                    } else {
                        self.form_title = 'No entry found';
                    }
                    self.form_id    = response.form_id;
                    self.report_data= JSON.parse(response.report_data);
                },
                error: function(error) {
                    console.log(error);
                },

            });
        },
    },
};
