/* globals google */

Vue.component('weforms-entry-gmap', {
    template: '#tmpl-wpuf-weforms-entry-gmap',
    props: [ 'lat', 'long', 'zoom' ],

    computed: {

        api_key: function() {
            return wpuf_form_builder.gmap_api_key;
        }
    },

    mounted: function() {

        var center = new google.maps.LatLng( parseFloat( this.lat ), parseFloat( this.long ) );
        var map = new google.maps.Map( jQuery( '.wpuf-form-google-map' ).get(0), {
            center: center,
            zoom: parseInt(this.zoom) || 12, // Default Zoom int for Maps
            mapTypeId: google.maps.MapTypeId.ROADMAP,
        });

        new google.maps.Marker({
            map: map,
            position: center
        });

    }
});
