<div class="weforms-modules">

    <div class="clearfix">
        <div class="pull-right activate-deactivate-all">
            <a href="#" @click.prevent="toggleModule('all','activate')">Activate</a> |
            <a href="#" @click.prevent="toggleModule('all','deactivate')">Deactivate</a> All
        </div>

        <h1 class="pull-left">
            <?php _e( 'Modules', 'weforms' ); ?>
        </h1>
    </div>


    <div class="wp-list-table widefat weforms-modules">

        <div class="plugin-card" v-for="(module, key) in modules.all">
            <div class="plugin-card-top">

                <div class="name column-name">
                    <h3>
                        <span class="plugin-name">{{ module.name }}</span>
                        <img class="plugin-icon" :src="module.thumbnail" :alt="module.name" />
                    </h3>
                </div>

                <div class="action-links">
                    <ul class="plugin-action-buttons">
                        <li>
                            <span :class="['wpuf-toggle-switch', 'big', isActive(key) ? 'checked' : '']" v-on:click="toggleModule(key)"></span>
                        </li>
                    </ul>
                </div>

                <div class="desc column-description">
                    <p>
                        {{ module.description }}
                    </p>
                </div>
            </div>
        </div>

    </div>

</div>
