weForms.routeComponents.License = {
    template: '#tmpl-wpuf-weforms-page-license',
    mixins: [weForms.mixins.Loading],

    data: function() {
        return {
            loading: false,
            license: '',
            email: '',
            status: {},
            message: '',
            error: ''
        };
    },

    created: function() {
        this.fetchLicense();
    },

    computed: {

        isActivated: function()  {
            return ( this.status.activated !== undefined ) ? this.status.activated : false;
        }
    },

    methods: {

        fetchLicense: function() {
            var self = this;

            self.loading = true;

            wp.ajax.send( 'weforms_pro_get_license', {
                data: {
                    _wpnonce: weForms.nonce
                },

                success: function(response) {
                    self.license = response.license.key;
                    self.email   = response.license.email;
                    self.status  = response.status || {};
                    self.message = response.message;
                },

                complete: function() {
                    self.loading = false;
                }
            });
        },

        deleteLicense: function(target, nonce) {
            var self = this;

            if ( ! confirm( weForms.confirm ) ) {
                return;
            }

            self.loading = true;
            jQuery(target).addClass('updating-message');

            wp.ajax.send( 'wedevs-license-delete-form-action', {
                data: {
                    _wpnonce: nonce,
                    license_product_slug: 'weforms-pro'
                },

                success: function() {
                    self.license = '';
                    self.email   = '';
                    self.status  = {};
                    self.message = '';
                },

                error: function(error) {
                    alert(error);
                },

                complete: function() {
                    self.loading = false;
                    jQuery(target).removeClass('updating-message');
                }
            });
        },

        activate: function(target, nonce) {
            if ( '' === this.license || '' === this.email ) {
                alert( 'Please provide your email and license key' );
                return;
            }

            var self = this;
            self.error = '';

            jQuery(target).addClass('updating-message');

            wp.ajax.send( 'wedevs-license-form-action', {
                data: {
                    _wpnonce: nonce,
                    email: self.email,
                    key: self.license,
                    license_product_slug: 'weforms-pro'
                },

                success: function(response) {
                    if ( response.data.activated ) {
                        self.status  = response.data;
                        self.message = response.message;
                        jQuery('#weforms-pro-license-notice').remove();
                    } else {
                        self.status  = response.data;
                        self.error   = response.data.error;
                    }

                },

                error: function(error) {
                    alert(error);
                },

                complete: function() {
                    jQuery(target).removeClass('updating-message');
                }
            });
        }
    }
};