<div>
    <h1><?php _e( 'License Updates', 'weforms-pro' ); ?></h1>

    <template v-if="!loading">

        <div class="updated error" v-if="error">
            <p>{{ error }}</p>
        </div>

        <table class="form-table" v-if="!isActivated">
            <tr>
                <th><?php _e( 'E-mail Address', 'weforms-pro' ); ?></th>
                <td>
                    <input type="email" name="email" class="regular-text" v-model="email" required>
                    <p class="description"><?php _e( 'Enter your purchase Email address', 'weforms-pro' ); ?></p>
                </td>
            </tr>
            <tr>
                <th><?php _e( 'License Key', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" name="license_key" class="regular-text" v-model="license">
                    <p class="description"><?php _e( 'Enter your license key', 'weforms-pro' ); ?></p>
                </td>
            </tr>
            <tr>
                <th>&nbsp;</th>
                <td>
                    <button class="button button-primary" @click="activate($event.target, '<?php echo wp_create_nonce( 'wedevs-license-nonce' ); ?>')"><?php _e( 'Save & Activate', 'weforms-pro' ); ?></button>
                </td>
            </tr>
        </table>
        <div class="weforms-license activated" v-else>
            <div class="updated">
                <p><span v-html="message">{{ message }}</span></p>
            </div>

            <button class="button" @click="deleteLicense($event.target, '<?php echo wp_create_nonce( 'wedevs-license-delete-nonce' ); ?>')"><?php _e( 'Delete License', 'weforms-pro' ); ?></button>
        </div>
    </template>
    <div class="loading" v-else>
        <?php _e( 'Loading', 'weforms-pro' ); ?>
    </div>

</div>
