<script type="text/x-template" id="tmpl-wpuf-field-calculation_options">
<div>
    <template v-if="form_fields.length">
        <template v-for="field in form_fields">
            <template v-if="field.id === $store.state.editing_field_id && 'yes' === field.enable_calculation">
                <div class="weforms-calculation-options">

                    <label for="field_calculation_formula">
                        <?php esc_html_e('Expression Builder', 'weforms-pro'); ?>
                    </label>

                    <div class="wefoms ">
                        <div class="weforms_calculation_buttons">
                            <?php foreach ( array('+', '-', '/', '*', '%', '^', '(', ')' ) as $button ) { ?>
                                <input type="button" value="<?php echo $button; ?>"
                                       @click.prevent="insertOperator( '<?php echo $button ?>' );"/>
                            <?php } ?>
                            <div class="weforms_calculation_fields">
                                <wpuf-merge-tags :fieldsonly="true" v-on:insert="insertOperand"></wpuf-merge-tags>
                            </div>
                        </div>
                    </div>

                    <textarea id="weforms_calculation_formula_field" v-model="formula_field" style="width: 100%; height: 60px">{{ formula_field }}</textarea>

                    <a href="#"  @click.prevent="validateExpression"> Validate Expression </a>

                    <br/>
                </div>
            </template>
        </template>
    </template>
</div>

</script>

<script type="text/x-template" id="tmpl-wpuf-field-column-data">
<div class="panel-field-opt panel-field-opt-text">
    <label class="clearfix">
        {{ option_field.title }} <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
        <span class="pull-right">
            <input type="checkbox" v-model="show_value"> <?php _e( 'Show values', 'wpuf' ); ?>
        </span>
    </label>

    <ul :class="['option-field-option-chooser', show_value ? 'show-value' : '']">
        <li class="clearfix margin-0 header">
            <div class="selector">&nbsp;</div>

            <div class="sort-handler">&nbsp;</div>

            <div class="label">
                <?php _e( 'Label', 'wpuf' ); ?>
            </div>

            <div v-if="show_value" class="value">
                <?php _e( 'Value', 'wpuf' ) ?>
            </div>

            <div class="action-buttons">&nbsp;</div>
        </li>
    </ul>

    <ul :class="['option-field-option-chooser margin-0', show_value ? 'show-value' : '']">
        <li v-for="(option, index) in options" :key="option.id" :data-index="index" class="clearfix option-field-option">
            <div class="selector">
                <input
                    v-if="option_field.is_multiple"
                    type="checkbox"
                    :value="option.value"
                    v-model="selected"
                >
                <input
                    v-else
                    type="radio"
                    :value="option.value"
                    v-model="selected"
                    class="option-chooser-radio"
                >
            </div>

            <div class="sort-handler">
                <i class="fa fa-bars"></i>
            </div>

            <div class="label">
                <input type="text" v-model="option.label" @input="set_option_label(index, option.label)">
            </div>

            <div v-if="show_value" class="value">
                <input type="text" v-model="option.value">
            </div>

            <div class="action-buttons clearfix">
                <i class="fa fa-minus-circle" @click="delete_option(index)"></i>
            </div>
        </li>
        <li>
            <div class="plus-buttons clearfix" @click="add_option">
                <i class="fa fa-plus-circle"></i>
            </div>
        </li>
    </ul>

    <a v-if="!option_field.is_multiple && selected" href="#clear" @click.prevent="clear_selection"><?php _e( 'Clear Selection', 'wpuf' ); ?></a>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-field-linear">
<div>
    <div class="panel-field-opt panel-field-name clearfix">

        <label>
            <?php _e( 'Scale Range', 'weforms' ); ?>
        </label>

        <div class="name-field-placeholder">
            <input type="text" v-model="editing_form_field.scale_range.from">
            <label><?php _e( 'From', 'weforms' ); ?></label>
        </div>

        <div class="name-field-value">
            <input type="text" v-model="editing_form_field.scale_range.to">
            <label><?php _e( 'To', 'weforms' ); ?></label>
        </div>
    </div>

    <div class="panel-field-opt panel-field-name clearfix">

        <label>
            <?php _e( 'Scale Text', 'weforms' ); ?>
        </label>

        <div class="name-field-placeholder">
            <input type="text" v-model="editing_form_field.scale_text.first">
            <label><?php _e( 'First Text', 'weforms' ); ?></label>
        </div>

        <div class="name-field-value">
            <input type="text" v-model="editing_form_field.scale_text.last">
            <label><?php _e( 'Last Text', 'weforms' ); ?></label>
        </div>
    </div>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-field-multiple_product">
<div v-if="met_dependencies" class="panel-field-opt panel-field-opt-multiple_product">
    <label v-if="option_field.title" :class="option_field.title_class">
        {{ option_field.title }} <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
    </label>
    <ul :class="[option_field.inline ? 'list-inline' : '']">
        <li v-for="(option, key) in option_field.options">
            <label>
                {{ option }}
            </label>
        </li>
    </ul>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-field-payment_method">
<div>

    <div class="panel-field-opt panel-field-opt-checkbox">
        <label class="clearfix">
            <?php _e( 'Payment Methods', 'weforms-pro' ) ?>
            <help-text text="<?php _e( "You will find more details on the Payment tab", 'weforms-pro' ) ?>"></help-text>
        </label>

        <ul>
            <li>
                <label>
                     <input type="checkbox" value="1" v-model="paypal"> <?php _e( "PayPal", 'weforms-pro' ) ?>
                </label>
            </li>
            <li>
                <label>
                     <input type="checkbox" value="1" v-model="stripe"> <?php _e( "Stripe", 'weforms-pro' ) ?>
                </label>
            </li>
        </ul>
    </div>


    <div class="panel-field-opt panel-field-opt-text" v-if="paypal">
        <label class="clearfix">
            <?php _e( 'PayPal Label', 'weforms-pro' ) ?>
            <help-text text="<?php _e( "What label you want to show for PayPal method", 'weforms-pro' ) ?>"></help-text>
        </label>
        <input type="text" v-model="paypal_label">
    </div>


    <div class="panel-field-opt panel-field-opt-text" v-if="stripe">
        <label class="clearfix">
            <?php _e( 'Stripe Label', 'weforms-pro' ) ?>
            <help-text text="<?php _e( "What label you want to show for stripe method", 'weforms-pro' ) ?>"></help-text>
        </label>

        <input type="text" v-model="stripe_label">
    </div>


    <div class="panel-field-opt panel-field-opt-text" v-if="paypal">
        <label class="clearfix">
         <?php _e( 'PayPal Picture', 'weforms-pro' ) ?>
         <help-text text="<?php _e( "Select cards you want to show pictures", 'weforms-pro' ) ?>"></help-text>
        </label>

        <input type="text" v-model="paypal_image">
    </div>

    <div class="panel-field-opt panel-field-opt-checkbox" v-if="stripe">
        <label class="clearfix">  <?php _e( 'Stripe Card Pictures', 'weforms-pro' ) ?> <help-text text="<?php _e( "Select cards you want to show pictures", 'weforms-pro' ) ?>"></help-text>
        </label>

        <ul>

            <?php
                foreach ( weforms_get_credit_card_names() as $card ) {
                    ?>
                    <li>
                        <label>
                             <input type="checkbox" value="<?php echo $card; ?>" v-model="card_images">
                                <img src="<?php echo WEFORMS_PRO_URL . '/modules/payment/assets/images/' . $card . '.svg'; ?>" alt="<?php echo $card; ?>" style="width: 25px">
                        </label>
                    </li>
                    <?php
                }
            ?>
        </ul>
    </div>

</div></script>

<script type="text/x-template" id="tmpl-wpuf-field-price">
<div>

	<template v-if="price.is_flexible">
		<div class="panel-field-opt panel-field-opt-text">
			<label class="clearfix">
		        <?php _e( 'Minimum Price', 'weforms' ) ?>
		        <help-text text="<?php _e( "Minimum price of this product. Default: 0", 'weforms' ) ?>"></help-text>
		        <input type="number" v-model="price.min">
	     	</label>
     	</div>

		<div class="panel-field-opt panel-field-opt-text">
			<label class="clearfix">
				<?php _e( 'Maximum Price', 'weforms' ) ?>
		        <help-text text="<?php _e( "Maximum price of this product. Keeping empty will be treated as unlimited.", 'weforms' ) ?>"></help-text>
		        <input type="number" v-model="price.max">
	     	</label>
     	</div>

	</template>
	<template v-else>
		<div class="panel-field-opt panel-field-opt-text">
			<label class="clearfix">
		        <?php _e( 'Price', 'weforms' ) ?>
		        <help-text text="<?php _e( "Insert Product Price", 'weforms' ) ?>"></help-text>
		        <input type="number" v-model="price.price">
	     	</label>
     	</div>
	</template>

	<div class="panel-field-opt panel-field-opt-text">
		<label class="clearfix">
			<input type="checkbox" value="yes" v-model="price.is_flexible"> Use flexible price
		</label>
	</div>



</div></script>

<script type="text/x-template" id="tmpl-wpuf-field-product-data">
<div>
    <div class="panel-field-opt panel-field-opt-radio">
        <label>
            Product list type
            <help-text text="<?php _e("Use checkbox if you want to allow buying multiple product.", 'weforms-pro' ) ?>"></help-text>
        </label>
        <ul class="list-inline">
            <li>
                <label>
                    <input type="radio" value="radio" v-model="select_type"> Radio
                </label>
            </li>
            <li>
                <label>
                    <input type="radio" value="checkbox" v-model="select_type"> Checkbox
                </label>
            </li>
        </ul>
    </div>

    <div class="panel-field-opt panel-field-opt-text">
        <label class="clearfix">
            {{ option_field.title }} <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
        </label>

        <ul :class="['option-field-option-chooser', show_value ? 'show-value' : 'show-value']">
            <li class="clearfix margin-0 header">
                <div class="selector">&nbsp;</div>

                <div class="sort-handler">&nbsp;</div>

                <div class="value">
                    <?php _e( 'Name', 'wpuf' ); ?>
                </div>

                <div class="label">
                    <?php _e( 'Price', 'wpuf' ) ?>
                </div>

                <div class="action-buttons">&nbsp;</div>
            </li>
        </ul>

        <ul :class="['option-field-option-chooser margin-0', show_value ? 'show-value' : 'show-value']">
            <li v-for="(option, index) in options" :key="option.id" :data-index="index" class="clearfix option-field-option">
                <div class="selector">

                    <template v-if="select_type == 'radio'">

                        <input
                            type="radio"
                            :value="option.value"
                            v-model="selected"
                        >
                    </template>

                    <template v-else>
                        <input
                            type="checkbox"
                            :value="option.value"
                            v-model="selected"
                        >

                    </template>


                </div>

                <div class="sort-handler">
                    <i class="fa fa-bars"></i>
                </div>

                <div class="value">
                    <input type="text" v-model="option.value">
                </div>

                <div class="label">
                    <input type="number" v-model="option.label">
                </div>

                <div class="action-buttons clearfix">
                    <i class="fa fa-minus-circle" @click="delete_option(index)"></i>
                </div>
            </li>
            <li>
                <div class="plus-buttons clearfix" @click="add_option">
                    <i class="fa fa-plus-circle"></i>
                </div>
            </li>
        </ul>

        <a v-if="select_type == 'radio' && selected" href="#clear" @click.prevent="clear_selection"><?php _e( 'Clear Selection', 'wpuf' ); ?></a>
    </div>

</div></script>

<script type="text/x-template" id="tmpl-wpuf-field-quantity">
<div>

	<div class="panel-field-opt panel-field-opt-text">
		<label><input type="checkbox" value="yes" v-model="quantity.status"> <?php _e( 'Use Quantity', 'weforms' ); ?></label>
	</div>

	<template v-if="quantity.status">

		<div class="panel-field-opt panel-field-opt-text">
			<label>
		       	<?php _e( 'Minimum Quantity', 'weforms' ) ?>
		        <help-text text="<?php _e( "Minimum quantity of this product. Default: 0", 'weforms' ) ?>"></help-text>
		        <input type="number" v-model="quantity.min">
	     	</label>
     	</div>

		<div class="panel-field-opt panel-field-opt-text">
			<label>
				<?php _e( 'Maximum Quantity', 'weforms' ) ?>
		        <help-text text="<?php _e( "Maximum quantity of this product. Keeping empty will be treated as unlimited.", 'weforms' ) ?>"></help-text>
		        <input type="number" v-model="quantity.max">
	     	</label>
     	</div>
	</template>

</div></script>

<script type="text/x-template" id="tmpl-wpuf-field-row-data">
<div class="panel-field-opt panel-field-opt-text">
    <label class="clearfix">
        {{ option_field.title }} <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
        <span class="pull-right">
            <input type="checkbox" v-model="show_value"> <?php _e( 'Show values', 'wpuf' ); ?>
        </span>
    </label>

    <ul :class="['option-field-option-chooser', show_value ? 'show-value' : '']">
        <li class="clearfix margin-0 header">
            <div class="selector">&nbsp;</div>

            <div class="sort-handler">&nbsp;</div>

            <div class="label">
                <?php _e( 'Label', 'wpuf' ); ?>
            </div>

            <div v-if="show_value" class="value">
                <?php _e( 'Value', 'wpuf' ) ?>
            </div>

            <div class="action-buttons">&nbsp;</div>
        </li>
    </ul>

    <ul :class="['option-field-option-chooser margin-0', show_value ? 'show-value' : '']">
        <li v-for="(option, index) in options" :key="option.id" :data-index="index" class="clearfix option-field-option">
            <div class="selector">
                <input
                    v-if="option_field.is_multiple"
                    type="checkbox"
                    :value="option.value"
                    v-model="selected"
                >
                <input
                    v-else
                    type="radio"
                    :value="option.value"
                    v-model="selected"
                    class="option-chooser-radio"
                >
            </div>

            <div class="sort-handler">
                <i class="fa fa-bars"></i>
            </div>

            <div class="label">
                <input type="text" v-model="option.label" @input="set_option_label(index, option.label)">
            </div>

            <div v-if="show_value" class="value">
                <input type="text" v-model="option.value">
            </div>

            <div class="action-buttons clearfix">
                <i class="fa fa-minus-circle" @click="delete_option(index)"></i>
            </div>
        </li>
        <li>
            <div class="plus-buttons clearfix" @click="add_option">
                <i class="fa fa-plus-circle"></i>
            </div>
        </li>
    </ul>

    <a v-if="!option_field.is_multiple && selected" href="#clear" @click.prevent="clear_selection"><?php _e( 'Clear Selection', 'wpuf' ); ?></a>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-field-selected_answers">
<div class="panel-field-opt panel-field-opt-text">
    <label class="clearfix">
        {{ option_field.title }} <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
    </label>

    <ul :class="['option-field-option-chooser margin-0']" style="margin-top:10px;">
        <li v-for="(option, index) in answer_options" :key="option.id" :data-index="index" class="clearfix option-field-option">
            <div class="label">
                <input
                    v-if="single_value"
                    type="radio"
                    :value="option.value"
                    v-model="selected_answers"
                    class="option-chooser-radio"
                >
                <input
                    v-else
                    type="checkbox"
                    :value="option.value"
                    v-model="selected_answers"
                >
                {{ option.label }}
            </div>
        </li>
    </ul>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-checkbox_grid">
<div class="wpuf-fields">
    <table>
        <tr>
            <th></th>
            <th  v-if="has_this('grid_columns')" v-for="(column_label, column_val) in field.grid_columns">
                {{ column_label }}
            </th>
        </tr>
        <tr  v-if="has_this('grid_rows')" v-for="(row_label, row_val) in field.grid_rows">
            <th>{{ row_label }}</th>
            <td  v-if="has_this('grid_columns')" v-for="(column_label, column_val) in field.grid_columns">
                <input type="checkbox" name="">
            </td>
        </tr>
    </table>

    <span v-if="field.help" class="wpuf-help">{{ field.help }}</span>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-entry-resend-notifications">
<div class="postbox">
    <h2 class="hndle ui-sortable-handle"><span><?php _e( 'Resend Notifications', 'weforms-pro' ); ?></span></h2>
    <div class="inside">
        <div class="main">
            <ul :class="['option-field-option-chooser weforms-entry-resend-notification-items']">
                <li :class="['clearfix option-field-option']" v-for="(notification, index) in notifications">
                    <label>
                        <input
                            type="checkbox"
                            :value="index"
                            class="weforms-resend-notification-item"
                        >
                        {{ notification.name }}
                    </label>
                </li>
                <li :class="['clearfix option-field-option']" style="margin-top:15px">
                    <h3 style="font-size:14px;margin-bottom:5px"><?php _e( 'Override Email', 'weforms-pro' ); ?><span style="font-size:10px;font-weight:400;margin-left:5px;color:#c51111"><?php _e( '(optional)', 'weforms-pro' ); ?></span></h3>
                    <input
                        type="email"
                        :class="['clearfix weforms-notification-override-email']"
                        placeholder="Enter Email"
                    >
                    <label :class="['clearfix']"><?php _e( 'It will override selected notifications email', 'weforms-pro'); ?></label>
                </li>
            </ul>
        </div>
    </div>

    <div id="major-publishing-actions">
        <div id="publishing-action">
            <button class="button button-large button-secondary" v-on:click.prevent="sendNotifications"><span class="dashicons dashicons-email-alt"></span> <?php _e( 'Resend', 'weforms-pro' ); ?></button>
        </div>
        <div class="clear"></div>
    </div>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-linear_scale">
<div class="wpuf-fields">

    <ul :class="['wpuf-fields-list', ('yes' === field.inline) ? 'wpuf-list-inline' : '']">
        <li><label>{{ field.scale_text.first }}</label></li>
        <li v-for="i in linearRange(field.scale_range.from, field.scale_range.to)">
            <label>
                <input
                    type="radio"
                    :value="i"
                    :class="class_names('radio_btns')"
                >{{ i }}
            </label>
        </li>
        <li>
            <label>
                <input
                    type="radio"
                    :value="field.scale_range.to"
                    :class="class_names('radio_btns')"
                >{{ field.scale_range.to }}
            </label>
        </li>
        <li><label>{{ field.scale_text.last }}</label></li>
    </ul>
    <span v-if="field.help" class="wpuf-help">{{ field.help }}</span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-multiple_choice_grid">
<div class="wpuf-fields">
    <table>
        <tr>
            <th></th>
            <th  v-if="has_this('grid_columns')" v-for="(column_label, column_val) in field.grid_columns">
                {{ column_label }}
            </th>
        </tr>
        <tr  v-if="has_this('grid_rows')" v-for="(row_label, row_val) in field.grid_rows">
            <th>{{ row_label }}</th>
            <td  v-if="has_this('grid_columns')" v-for="(column_label, column_val) in field.grid_columns">
                <input type="radio" name="">
            </td>
        </tr>
    </table>

    <span v-if="field.help" class="wpuf-help">{{ field.help }}</span>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-multiple_product">
<div class="wpuf-fields">
    <ul :class="['wpuf-fields-list', ('yes' === field.inline) ? 'wpuf-list-inline' : '']">
        <li v-if="has_options" v-for="(label, val) in field.options">
            <label>

            	    <template v-if="field.select_type == undefined || field.select_type == 'radio'">
                         <input type="radio" :checked="is_selected(val)"> {{ val }} - <?php echo weforms_get_currency( 'symbol' ); ?>{{ label }}
                    </template>

                    <template v-else>
                        <input type="checkbox" :checked="is_selected(val)"> {{ val }} - <?php echo weforms_get_currency( 'symbol' ); ?>{{ label }}

                    </template>
            </label>
        </li>
    </ul>

    <span v-if="field.help" class="wpuf-help">{{ field.help }}</span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-payment_method">
<div class="wpuf-fields">

    <template v-if="payment_methods.paypal || payment_methods.stripe">
        <template v-if="payment_methods.paypal && payment_methods.stripe">
            <ul :class="['wpuf-fields-list', ('yes' === field.inline) ? 'wpuf-list-inline' : '']">
                <li v-for="(method, val) in payment_methods">
                    <label>
                        <input
                            type="radio"
                            :value="val"
                            :checked="is_selected(val)"
                        >
                        {{ method.label }}
                        <template v-if="val == 'stripe'">
                            <img v-for="image in method.img" :src="'<?php echo WEFORMS_PRO_URL ?>/modules/payment/assets/images/' +image+ '.svg'" :alt="image" style="height: 20px; margin-right: 5px; vertical-align: middle;">
                        </template>
                        <template v-else>
                            <img :src="method.img" :alt="method.label" style="height: 25px; vertical-align: middle;">
                        </template>
                    </label>
                </li>
            </ul>
        </template>
        <template v-else>
            <ul :class="['wpuf-fields-list', ('yes' === field.inline) ? 'wpuf-list-inline' : '']">
                <li v-for="(method, val) in payment_methods">
                    <label>
                        <input
                            type="radio"
                            :value="val"
                            :checked=1
                            style="display:none"
                        >
                        {{ method.label }}
                        <template v-if="val == 'stripe'">
                            <img v-for="image in method.img" :src="'<?php echo WEFORMS_PRO_URL ?>/modules/payment/assets/images/' +image+ '.svg'" :alt="image" style="height: 20px; margin-right: 5px; vertical-align: middle;">
                        </template>
                        <template v-else>
                            <img :src="method.img" :alt="method.label" style="height: 25px; vertical-align: middle;">
                        </template>
                    </label>
                </li>
            </ul>
        </template>
    </template>

    <span v-if="field.help" class="wpuf-help">{{ field.help }}</span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-phone_field">
<div class="wpuf-fields">
    <input
        type="tel"
        :class="class_names('phonefield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help">{{ field.help }}</span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-report">
<div class="wpuf-form-reports">
    <h1 class="wp-heading-inline">
        <?php _e( 'Reports', 'weforms' ); ?>
        <span class="dashicons dashicons-arrow-right-alt2" style="margin-top: 5px;"></span>
        <span style="color: #999;" class="form-name">{{ form_title }}</span>
    </h1>
    <router-link class="page-title-action" to="/"><?php _e( 'Back to forms', 'weforms' ); ?></router-link>

    <div class="weforms-form-report-wrap">
        <template v-for="chart in report_data">
            <form-chart :chart_id="chart.name" :css_classes="chart.template + '-chart'" :styles="{height: '400px', width: '400px', position: 'relative'}" :chart_data="chart"></form-chart>
        </template>
    </div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-signature_field">
<div class="wpuf-fields">
    <div id="wpuf-signature-container">
        <div class="wpuf-signature-pad">
            <canvas id="signature-pad" class="signature-pad" style="border: 1px solid; border-width: thin;" width=200 height=100></canvas>
        </div>
        <input type="hidden" id='wpuf_signature_image' name="wpuf_signature_image" value="">
        <div>
            <a href="#" id="clear">Clear</a>
        </div>
    </div>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-single_product">
<div class="wpuf-fields">
	<template v-if="field.price.is_flexible">
		<div class="weforms-single-product-price-warp">
			<span><?php echo weforms_get_currency( 'symbol' ); ?></span>
			<input type="text" :value="field.price.min ? field.price.min : 0">
		</div>

	</template>

	<template v-else>
        <template v-if = "field.label == 'Donation Amount'">
            <label>Amount:</label>
        </template>
        <template v-else>
            <label>Price:</label>
        </template>
		<?php echo weforms_get_currency( 'symbol' ) ?> {{ field.price.price ? field.price.price : 0 }}

	</template>


	<div v-if="field.quantity.status">
		<label><?php _e( 'Quantity: ', 'wpuf' ) ?></label>

	    <input
	        type="text"
	        :class="class_names('textfield wpuf-product-qty')"
	        placeholder="1"
	        :value="field.quantity.min"
	        style="width: 50px; float: none !important"
	    >
	</div>
    <span v-if="field.help" class="wpuf-help">{{ field.help }}</span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-total">
<div class="wpuf-fields">
    <label><?php echo weforms_get_currency( 'symbol' ); ?>{{ field.price }}</label>
    <span v-if="field.help" class="wpuf-help">{{ field.help }}</span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-notification-conditional-logic">
<div class="panel-field-opt panel-field-opt-conditional-logic notification-conditional-logic">
    <label>
        <?php _e( 'Conditional Logic', 'weforms-pro' ); ?>
    </label>

    <ul class="list-inline condition-status">
        <li>
            <label><input type="radio" value="yes" v-model="notification.weforms_cond.condition_status"> <?php _e( 'Yes', 'weforms-pro' ); ?></label>
        </li>

        <li>
            <label><input type="radio" value="no" v-model="notification.weforms_cond.condition_status"> <?php _e( 'No', 'weforms-pro' ); ?></label>
        </li>
    </ul>

    <div v-if="'yes' === notification.weforms_cond.condition_status" class="condiotional-logic-container">
        <ul class="condiotional-logic-repeater">
            <li v-for="(condition, index) in notification.weforms_cond.conditions" class="clearfix">
                <div class="cond-field">
                    <select v-model="condition.name" @change="on_change_cond_field(index, condition.name)">
                        <option value=""><?php _e( '- select -', 'weforms-pro' ); ?></option>
                        <option
                            v-for="dep_field in dependencies"
                            :value="dep_field.name"
                        >{{ dep_field.label }}</option>
                    </select>
                </div>

                <div class="cond-operator">
                    <select v-model="condition.operator">
                        <option value="="><?php _e( 'is', 'weforms-pro' ); ?></option>
                        <option value="!="><?php _e( 'is not', 'weforms-pro' ); ?></option>
                    </select>
                </div>

                <div class="cond-option">
                    <select v-model="condition.option">
                        <option value=""><?php _e( '- select -', 'weforms-pro' ); ?></option>
                        <option
                            v-for="cond_option in get_cond_options(condition.name)"
                            :value="cond_option.opt_name"
                        >
                            {{ cond_option.opt_title }}
                        </option>
                    </select>
                </div>

                <div class="cond-action-btns">
                    <i class="fa fa-plus-circle" @click="add_condition"></i>
                    <i class="fa fa-minus-circle pull-right" @click="delete_condition(index)"></i>
                </div>
            </li>
        </ul>

        <p class="help">
            <?php
                printf(
                    __( 'Send email when %s of these rules are met', 'weforms-pro' ),
                    '<select v-model="notification.weforms_cond.cond_logic"><option value="any">' . __( 'any', 'weforms-pro' ) . '</option><option value="all">' . __( 'all', 'weforms-pro' ) . '</option></select>'
                );
            ?>
        </p>
    </div>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-submit-button-conditional-logic">
<div class="panel-field-opt panel-field-opt-conditional-logic notification-conditional-logic">

    <ul class="list-inline condition-status">
        <li>
            <label><input type="radio" value="yes" v-model="settings.submit_button_cond.condition_status"> <?php _e( 'Yes', 'weforms-pro' ); ?></label>
        </li>

        <li>
            <label><input type="radio" value="no" v-model="settings.submit_button_cond.condition_status"> <?php _e( 'No', 'weforms-pro' ); ?></label>
        </li>
    </ul>

    <div v-if="'yes' === settings.submit_button_cond.condition_status" class="condiotional-logic-container">
        <ul class="condiotional-logic-repeater">
            <li v-for="(condition, index) in settings.submit_button_cond.conditions" class="clearfix">
                <div class="cond-field">
                    <select v-model="condition.name" @change="on_change_cond_field(index, condition.name)">
                        <option value=""><?php _e( '- select -', 'weforms-pro' ); ?></option>
                        <option
                            v-for="dep_field in dependencies"
                            :value="dep_field.name"
                        >{{ dep_field.label }}</option>
                    </select>
                </div>

                <div class="cond-operator">
                    <select v-model="condition.operator">
                        <option value="="><?php _e( 'is', 'weforms-pro' ); ?></option>
                        <option value="!="><?php _e( 'is not', 'weforms-pro' ); ?></option>
                    </select>
                </div>

                <div class="cond-option">
                    <select v-model="condition.option">
                        <option value=""><?php _e( '- select -', 'weforms-pro' ); ?></option>
                        <option
                            v-for="cond_option in get_cond_options(condition.name)"
                            :value="cond_option.opt_name"
                        >
                            {{ cond_option.opt_title }}
                        </option>
                    </select>
                </div>

                <div class="cond-action-btns">
                    <i class="fa fa-plus-circle" @click="add_condition"></i>
                    <i class="fa fa-minus-circle pull-right" @click="delete_condition(index)"></i>
                </div>
            </li>
        </ul>

        <p class="help">
            <?php
                printf(
                    __( 'Show submit button when %s of these rules are met', 'weforms-pro' ),
                    '<select v-model="settings.submit_button_cond.cond_logic"><option value="any">' . __( 'any', 'weforms-pro' ) . '</option><option value="all">' . __( 'all', 'weforms-pro' ) . '</option></select>'
                );
            ?>
        </p>
    </div>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-weforms-entry-gmap">
<div class="wpuf-form-google-map"></div></script>

<script type="text/x-template" id="tmpl-wpuf-weforms-modules">
<div class="weforms-modules">

    <div class="clearfix">
        <div class="pull-right activate-deactivate-all">
            <a href="#" @click.prevent="toggleModule('all','activate')">Activate</a> |
            <a href="#" @click.prevent="toggleModule('all','deactivate')">Deactivate</a> All
        </div>

        <h1 class="pull-left">
            <?php _e( 'Modules', 'weforms' ); ?>
        </h1>
    </div>


    <div class="wp-list-table widefat weforms-modules">

        <div class="plugin-card" v-for="(module, key) in modules.all">
            <div class="plugin-card-top">

                <div class="name column-name">
                    <h3>
                        <span class="plugin-name">{{ module.name }}</span>
                        <img class="plugin-icon" :src="module.thumbnail" :alt="module.name" />
                    </h3>
                </div>

                <div class="action-links">
                    <ul class="plugin-action-buttons">
                        <li>
                            <span :class="['wpuf-toggle-switch', 'big', isActive(key) ? 'checked' : '']" v-on:click="toggleModule(key)"></span>
                        </li>
                    </ul>
                </div>

                <div class="desc column-description">
                    <p>
                        {{ module.description }}
                    </p>
                </div>
            </div>
        </div>

    </div>

</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-weforms-page-license">
<div>
    <h1><?php _e( 'License Updates', 'weforms-pro' ); ?></h1>

    <template v-if="!loading">

        <div class="updated error" v-if="error">
            <p>{{ error }}</p>
        </div>

        <table class="form-table" v-if="!isActivated">
            <tr>
                <th><?php _e( 'E-mail Address', 'weforms-pro' ); ?></th>
                <td>
                    <input type="email" name="email" class="regular-text" v-model="email" required>
                    <p class="description"><?php _e( 'Enter your purchase Email address', 'weforms-pro' ); ?></p>
                </td>
            </tr>
            <tr>
                <th><?php _e( 'License Key', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" name="license_key" class="regular-text" v-model="license">
                    <p class="description"><?php _e( 'Enter your license key', 'weforms-pro' ); ?></p>
                </td>
            </tr>
            <tr>
                <th>&nbsp;</th>
                <td>
                    <button class="button button-primary" @click="activate($event.target, '<?php echo wp_create_nonce( 'wedevs-license-nonce' ); ?>')"><?php _e( 'Save & Activate', 'weforms-pro' ); ?></button>
                </td>
            </tr>
        </table>
        <div class="weforms-license activated" v-else>
            <div class="updated">
                <p><span v-html="message">{{ message }}</span></p>
            </div>

            <button class="button" @click="deleteLicense($event.target, '<?php echo wp_create_nonce( 'wedevs-license-delete-nonce' ); ?>')"><?php _e( 'Delete License', 'weforms-pro' ); ?></button>
        </div>
    </template>
    <div class="loading" v-else>
        <?php _e( 'Loading', 'weforms-pro' ); ?>
    </div>

</div></script>
