'use strict';

var _typeof10 = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _typeof9 = typeof Symbol === "function" && _typeof10(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof10(obj);
} : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof10(obj);
};

var _typeof8 = typeof Symbol === "function" && _typeof9(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof9(obj);
} : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof9(obj);
};

var _typeof7 = typeof Symbol === "function" && _typeof8(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof8(obj);
} : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof8(obj);
};

var _typeof6 = typeof Symbol === "function" && _typeof7(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof7(obj);
} : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof7(obj);
};

var _typeof5 = typeof Symbol === "function" && _typeof6(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof6(obj);
} : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof6(obj);
};

var _typeof4 = typeof Symbol === "function" && _typeof5(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof5(obj);
} : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof5(obj);
};

var _typeof3 = typeof Symbol === "function" && _typeof4(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof4(obj);
} : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof4(obj);
};

var _typeof2 = typeof Symbol === "function" && _typeof3(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof3(obj);
} : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof3(obj);
};

var _typeof = typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof2(obj);
} : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof2(obj);
};

/* ./assets/components/field-calculation_options/index.js */
Vue.component('field-calculation_options', {
    template: '#tmpl-wpuf-field-calculation_options',

    mixins: [wpuf_mixins.option_field_mixin],

    props: {
        field: [String, Number, Object],
        enable_calculation: '',
        filter: {
            type: String,
            default: null
        }
    },

    data: function data() {
        return {
            type: null,
            fieldsonly: true,
            formula_field: ''
        };
    },

    created: function created() {
        this.formula_field = this.editing_form_field.formula_field;
    },

    computed: {
        form_fields: function form_fields() {
            var template = this.filter,
                fields = this.$store.state.form_fields;

            if (template !== null) {
                return fields.filter(function (item) {
                    return item.template === template;
                });
            }

            // remove the action/hidden fields
            return fields.filter(function (item) {
                return !_.contains(['action_hook', 'custom_hidden_field'], item.template);
            });
        },

        update_formula_field: function update_formula_field() {
            return this.formula_field;
        }

    },

    methods: {

        insertOperator: function insertOperator(value) {
            return this.formula_field += value;
        },

        insertOperand: function insertOperand(val1, val2) {
            return this.formula_field += val2;
        },

        validateExpression: function validateExpression() {
            var scope = {};
            for (var i = 0; i < this.$store.state.form_fields.length; i++) {
                var index = this.$store.state.form_fields[i].name;
                scope[index] = 1;
            }
            try {
                var expr = this.editing_form_field.formula_field.split('%').join('');
                var result = math.eval(String(expr), scope);
                if (result) {
                    alert(this.i18n.valid_formula);
                }
            } catch (error) {
                alert(this.i18n.invalid_formula);
            }
        }
    },

    watch: {
        update_formula_field: function update_formula_field(new_opts) {
            this.update_value('formula_field', new_opts);
        }
    }
});

/* ./assets/components/field-column-data/index.js */
/**
 * Common settings component for grid based fields
 * like multiselect grid, checkbox grid
 */
Vue.component('field-column-data', {
    template: '#tmpl-wpuf-field-column-data',

    mixins: [wpuf_mixins.option_field_mixin],

    data: function data() {
        return {
            show_value: false,
            options: [],
            selected: []
        };
    },

    computed: {
        field_options: function field_options() {
            return this.editing_form_field.options;
        },

        field_selected: function field_selected() {
            return this.editing_form_field.selected;
        }
    },

    mounted: function mounted() {
        var self = this;

        this.set_options();

        jQuery(this.$el).find('.option-field-option-chooser').sortable({
            items: '.option-field-option',
            handle: '.sort-handler',
            update: function update(e, ui) {
                var item = ui.item[0],
                    data = item.dataset,
                    toIndex = parseInt($(ui.item).index()),
                    fromIndex = parseInt(data.index);

                self.options.swap(fromIndex, toIndex);
            }
        });
    },

    methods: {
        set_options: function set_options() {
            var self = this;
            var field_options = jQuery.extend(true, {}, this.editing_form_field.grid_columns);

            _.each(field_options, function (label, value) {
                self.options.push({ label: label, value: value, id: self.get_random_id() });
            });

            if (this.option_field.is_multiple && !_.isArray(this.field_selected)) {
                this.selected = [this.field_selected];
            } else {
                this.selected = this.field_selected;
            }
        },

        // in case of select or radio buttons, user should deselect default value
        clear_selection: function clear_selection() {
            this.selected = null;
        },

        add_option: function add_option() {
            var count = this.options.length,
                new_opt = this.i18n.column + '-' + count;

            this.options.push({
                label: new_opt, value: new_opt, id: this.get_random_id()
            });
        },

        delete_option: function delete_option(index) {
            if (this.options.length === 1) {
                this.warn({
                    text: this.i18n.last_choice_warn_msg,
                    showCancelButton: false,
                    confirmButtonColor: "#46b450"
                });

                return;
            }

            this.options.splice(index, 1);
        },

        set_option_label: function set_option_label(index, label) {
            this.options[index].value = label.toLocaleLowerCase().replace(/\s/g, '_');
        }
    },

    watch: {
        options: {
            deep: true,
            handler: function handler(new_opts) {
                var options = {},
                    i = 0;

                for (i = 0; i < new_opts.length; i++) {
                    options[new_opts[i].value] = new_opts[i].label;
                }

                this.update_value('grid_columns', options);
            }
        },

        selected: function selected(new_val) {
            this.update_value('selected', new_val);
        }
    }
});

/* ./assets/components/field-linear/index.js */
Vue.component('field-linear', {
    template: '#tmpl-wpuf-field-linear',

    mixins: [wpuf_mixins.option_field_mixin],

    computed: {
        value: {
            get: function get() {
                return this.editing_form_field[this.option_field.name];
            },

            set: function set(value) {
                this.update_value(this.option_field.name, value);
            }
        }
    },

    methods: {
        on_focusout: function on_focusout(e) {
            wpuf_form_builder.event_hub.$emit('field-text-focusout', e, this);
        },
        on_keyup: function on_keyup(e) {
            wpuf_form_builder.event_hub.$emit('field-text-keyup', e, this);
        }
    }
});

/* ./assets/components/field-multiple_product/index.js */
Vue.component('field-multiple_product', {
    template: '#tmpl-wpuf-field-multiple_product',

    mixins: [wpuf_mixins.option_field_mixin],

    computed: {
        value: {
            get: function get() {
                return this.editing_form_field[this.option_field.name];
            },

            set: function set(value) {
                this.$store.commit('update_editing_form_field', {
                    editing_field_id: this.editing_form_field.id,
                    field_name: this.option_field.name,
                    value: value
                });
            }
        }
    }
});

/* ./assets/components/field-payment_method/index.js */
Vue.component('field-field-payment_method', {
    mixins: [wpuf_mixins.option_field_mixin],
    template: '#tmpl-wpuf-field-payment_method',
    data: function data() {
        return {
            'paypal': false,
            'stripe': false,
            'card_images': [],
            'paypal_image': 'https://www.paypalobjects.com/webstatic/mktg/logo/AM_mc_vs_dc_ae.jpg',
            'paypal_label': 'PayPal',
            'stripe_label': 'Stripe'
        };
    },
    computed: {
        settings: function settings() {
            return this.$store.state.settings;
        }
    },
    created: function created() {
        this.paypal = this.settings.payment_paypal_deactivate ? '' : '1';
        this.stripe = this.settings.payment_stripe_deactivate ? '' : '1';
        this.card_images = this.settings.payment_stripe_images;
        this.paypal_image = this.settings.payment_paypal_images;
        this.stripe_label = this.settings.payment_stripe_label;
        this.paypal_label = this.settings.payment_paypal_label;
    },

    watch: {
        paypal: function paypal(val) {
            this.$store.state.settings.payment_paypal_deactivate = val ? '' : '1';
        },
        stripe: function stripe(val) {
            this.$store.state.settings.payment_stripe_deactivate = val ? '' : '1';
        },
        card_images: function card_images(val) {
            this.$store.state.settings.payment_stripe_images = val;
        },
        stripe_label: function stripe_label(val) {
            this.$store.state.settings.payment_stripe_label = val;
        },
        paypal_label: function paypal_label(val) {
            this.$store.state.settings.payment_paypal_label = val;
        },
        paypal_image: function paypal_image(val) {
            this.$store.state.settings.payment_paypal_images = val;
        }
    }
});
/* ./assets/components/field-price/index.js */
Vue.component('field-field-price', {
    mixins: [wpuf_mixins.option_field_mixin],
    template: '#tmpl-wpuf-field-price',
    data: function data() {
        return {
            price: {
                is_flexible: false,
                price: '',
                min: '',
                max: ''
            }
        };
    },
    computed: {
        price: function price() {
            return this.editing_form_field.price;
        }
    },

    created: function created() {
        this.price = jQuery.extend(false, this.price, this.editing_form_field.price);
    },

    methods: {},

    watch: {
        price: function price() {
            this.update_value('price', this.price);
        }
    }
});
/* ./assets/components/field-product-data/index.js */
/**
 * Common settings component for multiple field
 */
Vue.component('field-product-data', {
    template: '#tmpl-wpuf-field-product-data',

    mixins: [wpuf_mixins.option_field_mixin],

    data: function data() {
        return {
            show_value: true,
            options: [],
            select_type: 'radio',
            selected: ''
        };
    },

    computed: {
        field_options: function field_options() {
            return this.editing_form_field.options;
        },

        field_selected: function field_selected() {
            return this.editing_form_field.selected;
        },

        field_select_type: function field_select_type() {
            return this.editing_form_field.select_type;
        }
    },

    mounted: function mounted() {

        var self = this;

        this.set_options();

        jQuery(this.$el).find('.option-field-option-chooser').sortable({
            items: '.option-field-option',
            handle: '.sort-handler',
            update: function update(e, ui) {
                var item = ui.item[0],
                    data = item.dataset,
                    toIndex = parseInt(jQuery(ui.item).index()),
                    fromIndex = parseInt(data.index);

                self.options.swap(fromIndex, toIndex);
            }
        });
    },

    methods: {
        set_options: function set_options() {
            var self = this;
            var field_options = jQuery.extend(true, {}, this.editing_form_field.options);

            _.each(field_options, function (label, value) {
                self.options.push({ label: label, value: value, id: self.get_random_id() });
            });

            this.selected = this.field_selected;
            this.select_type = this.field_select_type ? this.field_select_type : 'radio';
        },

        // in case of select or radio buttons, user should deselect default value
        clear_selection: function clear_selection() {
            this.selected = '';
        },

        add_option: function add_option() {
            var count = this.options.length,
                new_opt = 'Product' + '-' + (count + 1);

            this.options.push({
                label: 10, value: new_opt, id: this.get_random_id()
            });
        },

        delete_option: function delete_option(index) {
            if (this.options.length === 1) {
                this.warn({
                    text: this.i18n.last_choice_warn_msg,
                    showCancelButton: false,
                    confirmButtonColor: "#46b450"
                });

                return;
            }

            this.options.splice(index, 1);
        }
    },

    watch: {
        options: {
            deep: true,
            handler: function handler(new_opts) {
                var options = {},
                    i = 0;

                for (i = 0; i < new_opts.length; i++) {
                    options[new_opts[i].value] = new_opts[i].label;
                }

                this.update_value('options', options);
            }
        },

        selected: function selected(new_val) {

            this.update_value('selected', new_val);
        },

        select_type: function select_type(new_val) {

            if (_typeof(this.selected) === 'object') {
                if (new_val !== 'checkbox') {
                    this.selected = '';
                }
            } else {
                if (new_val !== 'radio') {
                    this.selected = [];
                }
            }

            this.update_value('select_type', new_val);
        }
    }
});

/* ./assets/components/field-quantity/index.js */
Vue.component('field-field-quantity', {
    mixins: [wpuf_mixins.option_field_mixin],
    template: '#tmpl-wpuf-field-quantity',
    data: function data() {
        return {
            quantity: {
                status: false,
                min: 0,
                max: ''
            }
        };
    },
    computed: {
        quantity: function quantity() {
            return this.editing_form_field.quantity;
        }
    },

    created: function created() {
        this.quantity = jQuery.extend(false, this.quantity, this.editing_form_field.quantity);
    },

    methods: {},

    watch: {
        quantity: function quantity() {
            this.update_value('quantity', this.quantity);
        }
    }
});
/* ./assets/components/field-row-data/index.js */
/**
 * Common settings component for grid based fields
 * like multiselect grid, checkbox grid
 */
Vue.component('field-row-data', {
    template: '#tmpl-wpuf-field-row-data',

    mixins: [wpuf_mixins.option_field_mixin],

    data: function data() {
        return {
            show_value: false,
            options: [],
            selected: []
        };
    },

    computed: {
        field_options: function field_options() {
            return this.editing_form_field.options;
        },

        field_selected: function field_selected() {
            return this.editing_form_field.selected;
        }
    },

    mounted: function mounted() {
        var self = this;

        this.set_options();

        jQuery(this.$el).find('.option-field-option-chooser').sortable({
            items: '.option-field-option',
            handle: '.sort-handler',
            update: function update(e, ui) {
                var item = ui.item[0],
                    data = item.dataset,
                    toIndex = parseInt($(ui.item).index()),
                    fromIndex = parseInt(data.index);

                self.options.swap(fromIndex, toIndex);
            }
        });
    },

    methods: {
        set_options: function set_options() {
            var self = this;
            var field_options = jQuery.extend(true, {}, this.editing_form_field.grid_rows);

            _.each(field_options, function (label, value) {
                self.options.push({ label: label, value: value, id: self.get_random_id() });
            });

            if (this.option_field.is_multiple && !_.isArray(this.field_selected)) {
                this.selected = [this.field_selected];
            } else {
                this.selected = this.field_selected;
            }
        },

        // in case of select or radio buttons, user should deselect default value
        clear_selection: function clear_selection() {
            this.selected = null;
        },

        add_option: function add_option() {
            var count = this.options.length,
                new_opt = this.i18n.row + '-' + count;

            this.options.push({
                label: new_opt, value: new_opt, id: this.get_random_id()
            });
        },

        delete_option: function delete_option(index) {
            if (this.options.length === 1) {
                this.warn({
                    text: this.i18n.last_choice_warn_msg,
                    showCancelButton: false,
                    confirmButtonColor: "#46b450"
                });

                return;
            }

            this.options.splice(index, 1);
        },

        set_option_label: function set_option_label(index, label) {
            this.options[index].value = label.toLocaleLowerCase().replace(/\s/g, '_');
        }
    },

    watch: {
        options: {
            deep: true,
            handler: function handler(new_opts) {
                var options = {},
                    i = 0;

                for (i = 0; i < new_opts.length; i++) {
                    options[new_opts[i].value] = new_opts[i].label;
                }

                this.update_value('grid_rows', options);
            }
        },

        selected: function selected(new_val) {
            this.update_value('selected', new_val);
        }
    }
});

/* ./assets/components/field-selected_answers/index.js */
Vue.component('field-selected_answers', {
    template: '#tmpl-wpuf-field-selected_answers',

    mixins: [wpuf_mixins.option_field_mixin],

    data: function data() {
        return {
            single_value: this.is_single_value(),
            answer_options: [{
                id: Math.random().toString(36).substr(2, 16),
                label: 'Option',
                value: 'Option'
            }],
            selected_answers: []
        };
    },

    computed: {
        update_answer_options: function update_answer_options() {
            return this.editing_form_field.options;
        },

        field_selected: function field_selected() {
            return this.editing_form_field.selected_answers;
        },

        update_total_points: function update_total_points() {
            return this.editing_form_field.points;
        }
    },

    mounted: function mounted() {
        this.set_options();
    },

    methods: {
        is_single_value: function is_single_value() {
            var template = this.editing_form_field.template;
            var is_single = this.single_value;

            switch (template) {
                case 'checkbox_field':
                case 'multiple_select':
                    is_single = false;
                    break;
                case 'radio_field':
                case 'dropdown_field':
                    is_single = true;
                    break;
                default:
                    is_single = false;
            }

            return is_single;
        },

        set_options: function set_options() {
            var self = this;
            var field_options = jQuery.extend(true, {}, this.editing_form_field.answer_options);

            _.each(field_options, function (label, value) {
                self.answer_options.push({ label: label, value: value, id: self.get_random_id() });
            });

            if (this.option_field.is_multiple && !_.isArray(this.field_selected)) {
                this.selected_answers = [this.field_selected];
            } else {
                this.selected_answers = this.field_selected;
            }
        }
    },

    watch: {
        update_answer_options: function update_answer_options(new_opts) {
            var answerOptions = [];

            jQuery.each(new_opts, function (value, label) {
                var answerOption = {};
                answerOption.id = Math.random().toString(36).substr(2, 16);
                answerOption.label = label;
                answerOption.value = value;
                answerOptions.push(answerOption);
            });

            this.answer_options = answerOptions;
        },

        selected_answers: function selected_answers(new_val) {
            this.update_value('selected_answers', new_val);
        },

        update_total_points: function update_total_points(value, previousValue, difference) {
            previousValue = previousValue || 0;
            difference = difference || 0;

            if (isNaN(value) || value === '') {
                value = 0;
            }

            value = parseFloat(value);

            if (value > previousValue) {
                difference = value - previousValue;
                previousValue = value;

                return this.$store.state.settings.total_points += difference;
            } else if (value < previousValue) {
                difference = previousValue - value;
                previousValue = value;

                return this.$store.state.settings.total_points -= difference;
            }
        }
    }
});

/* ./assets/components/form-checkbox_grid/index.js */
/**
 * Field template: checkbox_grid
 */
Vue.component('form-checkbox_grid', {
    template: '#tmpl-wpuf-form-checkbox_grid',

    mixins: [wpuf_mixins.form_field_mixin],
    methods: {
        has_this: function has_this(name) {
            if (!this.field.hasOwnProperty(name)) {
                return false;
            }

            return !!Object.keys(this.field.name).length;
        }
    }
});

/* ./assets/components/form-entry-resend-notifications/index.js */
Vue.component('form-entry-resend-notifications', {
    template: '#tmpl-wpuf-form-entry-resend-notifications',
    mixins: [weForms.mixins.Loading, weForms.mixins.Cookie],

    data: function data() {
        return {
            notifications: []
        };
    },

    mounted: function mounted() {
        this.getFormNotifications();
    },

    methods: {
        getFormNotifications: function getFormNotifications() {
            var self = this;

            wp.ajax.send('weforms_form_active_notifications', {
                data: {
                    form_id: self.$route.params.id,
                    _wpnonce: weForms.nonce
                },
                success: function success(response) {
                    self.notifications = response.form_notifications;
                },
                error: function error(_error) {
                    alert(_error);
                }
            });
        },

        sendNotifications: function sendNotifications() {
            var self = this,
                items = document.querySelectorAll('input.weforms-resend-notification-item'),
                overrideEmail = document.querySelector('input.weforms-notification-override-email').value,
                notifications = [];

            items.forEach(function (item) {
                if (item.checked === true) {
                    notifications.push(self.notifications[item.value]);
                }
            });

            if (notifications.length === 0) {
                alert(wpuf_form_builder.i18n.selectNotification);
                return;
            }

            if (!confirm(weForms.confirm)) {
                return;
            }

            if (overrideEmail.length !== 0) {
                notifications.forEach(function (notification) {
                    notification.to = overrideEmail;
                });
            }

            wp.ajax.send('weforms_entry_resend_notifications', {
                data: {
                    form_id: self.$route.params.id,
                    entry_id: self.$route.params.entryid,
                    notifications: notifications,
                    _wpnonce: weForms.nonce
                },

                success: function success(response) {
                    toastr.success(response.message);
                },

                error: function error(_error2) {
                    alert(_error2);
                }
            });
        }
    }
});

/* ./assets/components/form-linear_scale/index.js */
/**
 * Field template: Linear Scale
 */
Vue.component('form-linear_scale', {
    template: '#tmpl-wpuf-form-linear_scale',

    mixins: [wpuf_mixins.form_field_mixin],
    methods: {
        linearRange: function linearRange(from, to) {
            return _.range(parseInt(from), parseInt(to));
        }
    }
});

/* ./assets/components/form-multiple_choice_grid/index.js */
/**
 * Field template: multiple_choice_grid
 */
Vue.component('form-multiple_choice_grid', {
    template: '#tmpl-wpuf-form-multiple_choice_grid',

    mixins: [wpuf_mixins.form_field_mixin],
    methods: {
        has_this: function has_this(name) {
            if (!this.field.hasOwnProperty(name)) {
                return false;
            }

            return !!Object.keys(this.field.name).length;
        }
    }
});

/* ./assets/components/form-multiple_product/index.js */
/**
 * Field template: Multiple Product
 */
Vue.component('form-multiple_product', {
    template: '#tmpl-wpuf-form-multiple_product',

    mixins: [wpuf_mixins.form_field_mixin]
});
/* ./assets/components/form-payment_method/index.js */
/**
 * Field template: Payment method
 */
Vue.component('form-payment_method', {
    template: '#tmpl-wpuf-form-payment_method',

    mixins: [wpuf_mixins.form_field_mixin],

    computed: {
        settings: function settings() {
            return this.$store.state.settings;
        },

        payment_methods: function payment_methods() {
            var methods = {};

            if (!this.settings.payment_paypal_deactivate) {
                methods.paypal = {
                    label: this.settings.payment_paypal_label,
                    img: this.settings.payment_paypal_images
                };
            }

            if (!this.settings.payment_stripe_deactivate) {
                methods.stripe = {
                    label: this.settings.payment_stripe_label,
                    img: this.settings.payment_stripe_images
                };
            }

            return methods;
        }
    }
});

/* ./assets/components/form-phone_field/index.js */
Vue.component('form-phone_field', {
    template: '#tmpl-wpuf-form-phone_field',

    mixins: [wpuf_mixins.form_field_mixin]
});

/* ./assets/components/form-report/index.js */
Vue.component('form-chart', {

    render: function render(createElement) {
        return createElement('div', {
            class: this.css_classes,
            style: this.styles
        }, [createElement('canvas', {
            attrs: {
                id: this.chart_id,
                width: 100,
                height: 100
            },
            ref: 'canvas'
        })]);
    },

    props: {
        chart_id: {
            type: String,
            default: ''
        },
        width: {
            type: Number,
            default: 100
        },
        height: {
            type: Number,
            default: 100
        },
        css_classes: {
            default: '',
            type: String
        },
        styles: {
            type: Object
        },
        chart_data: {
            default: {},
            type: Object
        }
    },

    data: function data() {
        return {
            _chart: null
        };
    },

    mounted: function mounted() {
        this.process_chart_data();
    },

    methods: {
        process_chart_data: function process_chart_data() {

            var exclude_array = ['file_upload', 'repeat_field', 'google_map', 'step_start', 'shortcode', 'action_hook', 'toc', 'custom_hidden_field', 'image_upload', 'section_break', 'custom_html', 'recaptcha', 'address_field'];

            if (this.in_array(this.chart_data.template, exclude_array)) {
                return;
            }

            var chart_title = this.chart_data.field_label;
            var data_set = [];
            var chart_data_var = {};
            var options1 = {},
                options2 = {};
            var chart_dataset = [{
                label: this.chart_data.field_label,
                backgroundColor: this.chart_data.bg_color,
                data: this.chart_data.data
            }];

            if (this.chart_data.template === 'checkbox_grid' || this.chart_data.template === 'multiple_choice_grid') {
                var count = 0;
                for (var index in this.chart_data.data) {
                    var new_data = this.chart_data.data[index];
                    if (!Array.isArray(new_data)) {
                        new_data = [new_data];
                    }
                    data_set.push({
                        label: index,
                        backgroundColor: this.chart_data.bg_color[count++],
                        data: new_data
                    });
                }
                chart_dataset = data_set;
            }

            chart_data_var = {
                labels: this.chart_data.label,
                datasets: chart_dataset
            };

            options1 = {
                legend: {
                    display: true,
                    position: 'top',
                    labels: {
                        fontColor: '#333'
                    }
                },
                title: {
                    display: true,
                    text: chart_title
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            min: 0,
                            beginAtZero: true,
                            stepSize: 1
                        }
                    }]
                }
            };

            options2 = {
                legend: {
                    display: true,
                    position: 'top',
                    labels: {
                        fontColor: '#333'
                    }
                },
                title: {
                    display: true,
                    text: chart_title
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            min: 0,
                            beginAtZero: true,
                            stepSize: 1
                        }
                    }]
                },
                tooltips: {
                    callbacks: {
                        title: function title() {
                            return '';
                        },
                        label: function label(item) {
                            return item.xLabel + ': ' + item.yLabel;
                        }
                    }
                }
            };

            if (this.chart_data.template === 'checkbox_grid' || this.chart_data.template === 'multiple_choice_grid') {
                this.render_chart(chart_data_var, options1);
            } else {
                this.render_chart(chart_data_var, options2);
            }
        },

        render_chart: function render_chart(data, options) {
            this.$data._chart = new Chart(this.$refs.canvas.getContext('2d'), {
                type: this.chart_data.chart_type,
                data: data,
                options: options
            });
        },

        in_array: function in_array(needle, haystack) {
            var length = haystack.length;
            for (var i = 0; i < length; i++) {
                if (haystack[i] === needle) {
                    return true;
                }
            }
            return false;
        }
    }
});

weForms.routeComponents.formReports = {
    props: {
        id: [String, Number]
    },
    template: '#tmpl-wpuf-form-report',
    data: function data() {
        return {
            form_title: '',
            form_id: 0,
            report_data: ''
        };
    },

    created: function created() {
        this.fetchReports();
    },

    computed: {
        hasFormFields: function hasFormFields() {
            return Object.keys(this.entry.form_fields).length;
        }
    },

    methods: {
        fetchReports: function fetchReports() {
            var self = this;

            wp.ajax.send('weforms_form_report', {
                data: {
                    form_id: self.$route.params.id,
                    _wpnonce: weForms.nonce
                },
                success: function success(response) {
                    if (Object.keys(response.form_id)) {
                        self.form_title = response.form_title;
                    } else {
                        self.form_title = 'No entry found';
                    }
                    self.form_id = response.form_id;
                    self.report_data = JSON.parse(response.report_data);
                },
                error: function error(_error3) {
                    console.log(_error3);
                }

            });
        }
    }
};

/* ./assets/components/form-signature_field/index.js */
Vue.component('form-signature_field', {
    template: '#tmpl-wpuf-form-signature_field',

    mixins: [wpuf_mixins.form_field_mixin]
});

/* ./assets/components/form-single_product/index.js */
/**
 * Form template: Single Product
 */
Vue.component('form-single_product', {
    template: '#tmpl-wpuf-form-single_product',

    mixins: [wpuf_mixins.form_field_mixin]
});

/* ./assets/components/form-total/index.js */
/**
 * Form template: Total
 */
Vue.component('form-total', {
    template: '#tmpl-wpuf-form-total',

    mixins: [wpuf_mixins.form_field_mixin]
});

/* ./assets/components/notification-conditional-logic/index.js */
Vue.component('notification-conditional-logics', {
    props: ['notification'],
    template: '#tmpl-wpuf-notification-conditional-logic',
    computed: {

        weforms_cond_supported_fields: function weforms_cond_supported_fields() {
            return wpuf_form_builder.wpuf_cond_supported_fields;
        },

        dependencies: function dependencies() {
            var self = this;

            return this.$store.state.form_fields.filter(function (form_field) {
                return _.indexOf(self.weforms_cond_supported_fields, form_field.template) >= 0 && form_field.name && form_field.label;
            });
        }
    },

    created: function created() {},

    methods: {
        get_cond_options: function get_cond_options(field_name) {
            var options = [];

            if (_.indexOf(this.weforms_cond_supported_fields, field_name) < 0) {
                var dep = this.dependencies.filter(function (field) {
                    return field.name === field_name;
                });

                if (dep.length && dep[0].options) {
                    _.each(dep[0].options, function (option_title, option_name) {
                        options.push({ opt_name: option_name, opt_title: option_title });
                    });
                }
            }

            return options;
        },

        on_change_cond_field: function on_change_cond_field(index) {
            this.notification.weforms_cond.conditions[index].option = '';
        },

        add_condition: function add_condition() {
            this.notification.weforms_cond.conditions.push({
                name: '',
                operator: '=',
                option: ''
            });
        },

        delete_condition: function delete_condition(index) {
            if (this.notification.weforms_cond.conditions.length === 1) {
                this.warn({
                    text: this.i18n.last_choice_warn_msg,
                    showCancelButton: false,
                    confirmButtonColor: "#46b450"
                });

                return;
            }

            this.notification.weforms_cond.conditions.splice(index, 1);
        }
    }
});
/* ./assets/components/submit-button-conditional-logic/index.js */
Vue.component('submit-button-conditional-logics', {
    template: '#tmpl-wpuf-submit-button-conditional-logic',

    data: function data() {
        return {
            settings: this.$store.state.settings
        };
    },

    computed: {

        weforms_cond_supported_fields: function weforms_cond_supported_fields() {
            return wpuf_form_builder.wpuf_cond_supported_fields;
        },

        dependencies: function dependencies() {
            var self = this;

            return this.$store.state.form_fields.filter(function (form_field) {
                return _.indexOf(self.weforms_cond_supported_fields, form_field.template) >= 0 && form_field.name && form_field.label;
            });
        }
    },

    methods: {
        get_cond_options: function get_cond_options(field_name) {
            var options = [];

            if (_.indexOf(this.weforms_cond_supported_fields, field_name) < 0) {
                var dep = this.dependencies.filter(function (field) {
                    return field.name === field_name;
                });

                if (dep.length && dep[0].options) {
                    _.each(dep[0].options, function (option_title, option_name) {
                        options.push({ opt_name: option_name, opt_title: option_title });
                    });
                }
            }

            return options;
        },

        on_change_cond_field: function on_change_cond_field(index) {
            this.$store.state.settings.submit_button_cond.conditions[index].option = '';
        },

        add_condition: function add_condition() {
            this.$store.state.settings.submit_button_cond.conditions.push({
                name: '',
                operator: '=',
                option: ''
            });
        },

        delete_condition: function delete_condition(index) {
            if (this.$store.state.settings.submit_button_cond.conditions.length === 1) {
                this.warn({
                    text: this.i18n.last_choice_warn_msg,
                    showCancelButton: false,
                    confirmButtonColor: "#46b450"
                });

                return;
            }

            this.$store.state.settings.submit_button_cond.conditions.splice(index, 1);
        }
    }
});
/* ./assets/components/weforms-entry-gmap/index.js */
/* globals google */

Vue.component('weforms-entry-gmap', {
    template: '#tmpl-wpuf-weforms-entry-gmap',
    props: ['lat', 'long', 'zoom'],

    computed: {

        api_key: function api_key() {
            return wpuf_form_builder.gmap_api_key;
        }
    },

    mounted: function mounted() {

        var center = new google.maps.LatLng(parseFloat(this.lat), parseFloat(this.long));
        var map = new google.maps.Map(jQuery('.wpuf-form-google-map').get(0), {
            center: center,
            zoom: parseInt(this.zoom) || 12, // Default Zoom int for Maps
            mapTypeId: google.maps.MapTypeId.ROADMAP
        });

        new google.maps.Marker({
            map: map,
            position: center
        });
    }
});

/* ./assets/components/weforms-modules/index.js */
weForms.routeComponents.Modules = {
    template: '#tmpl-wpuf-weforms-modules',
    mixins: [weForms.mixins.Loading],
    data: function data() {
        return {
            requesting: false,
            loading: false,
            modules: {
                all: {},
                active: []
            }
        };
    },

    created: function created() {
        this.fetchModules();
    },

    methods: {

        isActive: function isActive(module) {
            return _.contains(this.modules.active, module);
        },

        activateModule: function activateModule(module) {
            if (!this.isActive(module)) {
                this.modules.active.push(module);
            }
        },

        deactivateModule: function deactivateModule(module) {
            console.log(this.modules.active);

            if (this.isActive(module)) {
                this.modules.active.splice(this.modules.active.indexOf(module), 1);
            }
        },

        fetchModules: function fetchModules() {
            var self = this;

            self.loading = true;

            wp.ajax.send('weforms_get_modules', {
                data: {
                    _wpnonce: weForms.nonce
                },

                success: function success(response) {
                    self.modules = response;
                },

                complete: function complete() {
                    self.loading = false;
                }
            });
        },

        toggleModule: function toggleModule(module, state) {
            var self = this;

            if (!state) {
                state = this.isActive(module) ? 'deactivate' : 'activate';
            }

            // if we are already making a call
            if (self.requesting) {
                return;
            }

            self.requesting = true;
            self.loading = true;

            wp.ajax.send('weforms_toggle_modules', {
                data: {
                    type: state,
                    module: module,
                    _wpnonce: weForms.nonce
                },

                success: function success(response) {

                    if (state === 'activate') {
                        self.activateModule(module);
                    } else {
                        self.deactivateModule(module);
                    }

                    toastr.options.timeOut = 1000;
                    toastr.success(response);

                    window.location.reload();
                },

                complete: function complete() {
                    self.requesting = false;
                    self.loading = false;
                }
            });
        }
    }
};

/* ./assets/components/weforms-page-license/index.js */
weForms.routeComponents.License = {
    template: '#tmpl-wpuf-weforms-page-license',
    mixins: [weForms.mixins.Loading],

    data: function data() {
        return {
            loading: false,
            license: '',
            email: '',
            status: {},
            message: '',
            error: ''
        };
    },

    created: function created() {
        this.fetchLicense();
    },

    computed: {

        isActivated: function isActivated() {
            return this.status.activated !== undefined ? this.status.activated : false;
        }
    },

    methods: {

        fetchLicense: function fetchLicense() {
            var self = this;

            self.loading = true;

            wp.ajax.send('weforms_pro_get_license', {
                data: {
                    _wpnonce: weForms.nonce
                },

                success: function success(response) {
                    self.license = response.license.key;
                    self.email = response.license.email;
                    self.status = response.status || {};
                    self.message = response.message;
                },

                complete: function complete() {
                    self.loading = false;
                }
            });
        },

        deleteLicense: function deleteLicense(target, nonce) {
            var self = this;

            if (!confirm(weForms.confirm)) {
                return;
            }

            self.loading = true;
            jQuery(target).addClass('updating-message');

            wp.ajax.send('wedevs-license-delete-form-action', {
                data: {
                    _wpnonce: nonce,
                    license_product_slug: 'weforms-pro'
                },

                success: function success() {
                    self.license = '';
                    self.email = '';
                    self.status = {};
                    self.message = '';
                },

                error: function error(_error4) {
                    alert(_error4);
                },

                complete: function complete() {
                    self.loading = false;
                    jQuery(target).removeClass('updating-message');
                }
            });
        },

        activate: function activate(target, nonce) {
            if ('' === this.license || '' === this.email) {
                alert('Please provide your email and license key');
                return;
            }

            var self = this;
            self.error = '';

            jQuery(target).addClass('updating-message');

            wp.ajax.send('wedevs-license-form-action', {
                data: {
                    _wpnonce: nonce,
                    email: self.email,
                    key: self.license,
                    license_product_slug: 'weforms-pro'
                },

                success: function success(response) {
                    if (response.data.activated) {
                        self.status = response.data;
                        self.message = response.message;
                    } else {
                        self.status = response.data;
                        self.error = response.data.error;
                    }
                },

                error: function error(_error5) {
                    alert(_error5);
                },

                complete: function complete() {
                    jQuery(target).removeClass('updating-message');
                }
            });
        }
    }
};
