jQuery(document).ready(function($) {

    var weFormsFrontReport = {
        init: function () {
            var form_id = [],
                frontend_report = [];
            $(".wpuf-form-add :input[name=form_id]").each(function(){
                form_id.push( $(this).val() );
            });
            $(".wpuf-form-add :input[name=weforms-front-report]").each(function(){
                frontend_report.push( $(this).val() );
            });

            var idx,
                form_selector = '';

            for ( idx = 0; idx < form_id.length; idx++ ) {
                form_selector = '.weforms-' + form_id[idx];
                if ( frontend_report[idx] === 'yes' ) {
                    $(form_selector).off();
                    $(form_selector).on('submit', this.frontReportFormSubmit);
                }
            }
        },

        frontReportFormSubmit: function (e) {
            e.preventDefault();

            var form = $(this),
                submitButton = form.find('input[type=submit]'),
                form_data = weFormsFrontReport.weFormsValidateForm(form);

            if (form_data) {

                // send the request
                form.find('li.wpuf-submit').append('<span class="wpuf-loading"></span>');
                submitButton.attr('disabled', 'disabled').addClass('button-primary-disabled');

                $.post( wpuf_frontend.ajaxurl, form_data, function ( res ) {
                    e.preventDefault();
                    // var res = $.parseJSON(res);

                    if ( res.show_chart === true ) {

                        form.find('ul').remove();
                        form.before('<div class="wpuf-success">' + res.message + '</div>');
                        form.addClass('weforms-chart-container');
                        $('.weforms-chart-container').css({
                            "width": "350px",
                            "height": "auto",
                        });

                        this.report_data_parsed = JSON.parse(res.report_data);
                        var id_num = 1;

                        for (var index = 0; index < this.report_data_parsed.length; index++) {
                            var ex_template = this.report_data_parsed[index].template;

                            if (ex_template === 'file_upload' || ex_template === 'image_upload' || ex_template === 'address_field' ||
                                ex_template === 'repeat_field' || ex_template === 'google_map' || ex_template === 'step_start' ||
                                ex_template === 'shortcode' || ex_template === 'action_hook' || ex_template === 'toc' ||
                                ex_template === 'custom_hidden_field' || ex_template === 'image_upload' || ex_template === 'section_break' ||
                                ex_template === 'custom_html' || ex_template === 'recaptcha') {
                                continue;
                            }

                            var chart_data = this.report_data_parsed[index];
                            var chart_title = chart_data.field_label;
                            var data_set = [];
                            var chart_dataset = [
                                {
                                    label: chart_data.field_label,
                                    backgroundColor: chart_data.bg_color,
                                    data: chart_data.data,
                                }
                            ];
                            var tooltip_var = {
                                callbacks: {
                                    title: function() {
                                        return '';
                                    },
                                    label: function(item,data) {
                                        return item.xLabel + ': ' + item.yLabel;
                                    }
                                }
                            };

                            if (chart_data.template === 'checkbox_grid' || chart_data.template === 'multiple_choice_grid') {
                                var count = 0;
                                for (var idx in chart_data.data) {
                                    var new_data = chart_data.data[idx];
                                    if (!Array.isArray(new_data)) {
                                        new_data = [new_data];
                                    }
                                    data_set.push({
                                        label: idx,
                                        backgroundColor: chart_data.bg_color[count++],
                                        data: new_data,
                                    });
                                }
                                chart_dataset = data_set;
                                tooltip_var = {};
                            }

                            id_name = 'weforms-chart-' + chart_data.template + id_num;
                            form.append('<div class="' + id_name + '" style="width: 100%; height: auto"><canvas id="' + id_name + '" width="100" height="100"></canvas></div>');

                            new Chart(document.getElementById(id_name), {
                                responsive: true,
                                type: 'bar',
                                data: {
                                    labels: chart_data.label,
                                    datasets: chart_dataset
                                },
                                options: {
                                    legend: {
                                        display: true,
                                        position: 'top',
                                        labels: {
                                            fontColor: '#333'
                                        }
                                    },
                                    title: {
                                        display: true,
                                        text: chart_title
                                    },
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                min: 0,
                                                beginAtZero: true,
                                                stepSize: 1,
                                            }
                                        }]
                                    },
                                    tooltips: tooltip_var,
                                }
                            });
                            id_num = id_num + 1;
                        }
                    } else {
                        form.before( '<div class="wpuf-success">' + res.message + '</div>');
                        form.slideUp( 'fast', function() {
                            form.remove();
                        });
                    }

                    submitButton.removeClass('button-primary-disabled');
                    form.find('span.wpuf-loading').remove();
                });
            }
        },

        weFormsValidateForm: function (self) {

            var temp,
                temp_val = '',
                error = false,
                error_items = [];
            error_type = '';

            // ===== Validate: Text and Textarea ========
            var required = self.find('[data-required="yes"]:visible');

            required.each(function (i, item) {
                // temp_val = $.trim($(item).val());

                // console.log( $(item).data('type') );
                var data_type = $(item).data('type');
                val = '';

                switch (data_type) {
                    case 'rich':
                        var name = $(item).data('id');
                        val = $.trim(tinyMCE.get(name).getContent());

                        if (val === '') {
                            error = true;

                            // make it warn collor
                            weFormsFrontReport.weFormsFrontMarkError(item);
                        }
                        break;

                    case 'textarea':
                    case 'text':

                        val = $.trim($(item).val());

                        if (val === '') {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontReport.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'password':
                    case 'confirm_password':
                        var hasRepeat = $(item).data('repeat');

                        val = $.trim($(item).val());

                        if (val === '') {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontReport.weFormsFrontMarkError(item, error_type);
                        }

                        if (hasRepeat) {
                            var repeatItem = $('[data-type="confirm_password"]').eq(0);

                            if (repeatItem.val() !== val) {
                                error = true;
                                error_type = 'mismatch';

                                weFormsFrontReport.weFormsFrontMarkError(repeatItem, error_type);
                            }
                        }

                        break;

                    case 'select':
                        val = $(item).val();

                        // console.log(val);
                        if (!val || val === '-1') {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontReport.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'multiselect':
                        val = $(item).val();

                        if (val === null || val.length === 0) {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontReport.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'tax-checkbox':
                        var length = $(item).children().find('input:checked').length;

                        if (!length) {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontReport.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'radio':
                        var length = $(item).find('input:checked').length;

                        if (!length) {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontReport.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'file':
                        var length = $(item).find('ul').children().length;

                        if (!length) {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontReport.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'email':
                        var val = $(item).val();

                        if (val !== '') {
                            //run the validation
                            if (!weFormsFrontReport.isValidEmail(val)) {
                                error = true;
                                error_type = 'validation';

                                weFormsFrontReport.weFormsFrontMarkError(item, error_type);
                            }
                        } else if (val === '') {
                            error = true;
                            error_type = 'required';

                            weFormsFrontReport.weFormsFrontMarkError(item, error_type);
                        }
                        break;


                    case 'url':
                        var val = $(item).val();

                        if (val !== '') {
                            //run the validation
                            if (!weFormsFrontReport.isValidURL(val)) {
                                error = true;
                                error_type = 'validation';

                                weFormsFrontReport.weFormsFrontMarkError(item, error_type);
                            }
                        }
                        break;
                }

            });

            // if already some error found, bail out
            if (error) {
                // add error notice
                weFormsFrontReport.addErrorNotice(self, 'end');

                return false;
            }

            var form_data = self.serialize(),
                rich_texts = [];

            // grab rich texts from tinyMCE
            $('.wpuf-rich-validation', self).each(function (index, item) {
                var item = $(item);
                var editor_id = item.data('id');
                var item_name = item.data('name');
                var val = $.trim(tinyMCE.get(editor_id).getContent());

                rich_texts.push(item_name + '=' + encodeURIComponent(val));
            });

            // append them to the form var
            form_data = form_data + '&' + rich_texts.join('&');
            return form_data;
        },

        weFormsFrontMarkError: function(item, error_type) {

            var error_string = '';
            $(item).closest('li').addClass('has-error');

            if ( error_type ) {
                error_string = $(item).closest('li').data('label');
                switch ( error_type ) {
                    case 'required' :
                        error_string = error_string + ' ' + error_str_obj[error_type];
                        break;
                    case 'mismatch' :
                        error_string = error_string + ' ' +error_str_obj[error_type];
                        break;
                    case 'validation' :
                        error_string = error_string + ' ' + error_str_obj[error_type];
                        break;
                }
                $(item).siblings('.wpuf-error-msg').remove();
                $(item).after('<div class="wpuf-error-msg">'+ error_string +'</div>');
            }

            $(item).focus();
        },

        isValidEmail: function( email ) {
            var pattern = new RegExp(/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i);
            return pattern.test(email);
        },

        isValidURL: function(url) {
            var urlregex = new RegExp("^(http:\/\/www.|https:\/\/www.|ftp:\/\/www.|www.|http:\/\/|https:\/\/){1}([0-9A-Za-z]+\.)");
            return urlregex.test(url);
        },

    };

    weFormsFrontReport.init();
});
