;( function( $ ) {
    $( document ).ready( function(){
        var $signaturePad = document.getElementById( 'wpuf-signature-pad' ),
			signaturePad,
			clear_image;
		/*
		 * If we do not have a signature pad, abort.
		 *
		 * By default, the signature javascript is loaded on every page. Avoid an error
		 * and abort if the signature element does not exist.
		 */
        if ( ! $signaturePad ) {
            return;
        }
        signaturePad = new SignaturePad( $signaturePad, {
            backgroundColor: '#fefefe',
            penColor: 'rgb(0, 0, 0)'
        });
        clear_image = document.getElementById( 'wpuf-signature-clear' );
        $( '#wpuf-signature-pad' ).on( 'click touchmove', function ( e ) {
            e.preventDefault();
            var imageData = $( this ).get( 0 ).toDataURL('image/png');
            $( '#wpuf_signature_image' ).val( imageData );
        } );
        clear_image.addEventListener( 'click', function ( event ) {
            event.preventDefault();
            signaturePad.clear();
            document.getElementsByName( "wpuf_signature_image" )[0].setAttribute( "value", '');
        });
    });
})( jQuery );
