<?php

class WeForms_Form_Report_Controller  extends Weforms_REST_Controller {

    /**
     * Endpoint namespace
     *
     * @var string
     */
    protected $namespace = 'weforms/v1';

    /**
     * Route name
     *
     * @var string
     */
    protected $base = 'forms';

    /**
     * Register all routes releated with forms
     *
     * @return void
     */

    public function register_routes() {

        register_rest_route( $this->namespace, '/' . $this->base . '/(?P<form_id>[\d]+)' .'/reports/', array(

            'args' => array(
                'form_id' => array(
                    'description'       => __( 'Unique identifier for the object', 'weforms-pro' ),
                    'key'               => 'integer',
                    'validate_callback' => array( $this, 'is_form_exists' ),
                    'required'          => true,
                ),
            ),

            array(
                'methods'             => WP_REST_Server::READABLE,
                'callback'            => array( $this, 'reports_form' ),
                'permission_callback' => array( $this, 'get_item_permissions_check' ),
                'args'     => array(
                    'context' => $this->get_context_param( [ 'default' => 'view' ] )
                ),
            ),
        ) );

    }


    /**
     * Get Reports Single Form
     *
     * @since 1.4.2
     *
     * @param WP_REST_Request $request Full details about the request.
     *
     * @return WP_REST_Response|WP_Error Response object on success, or WP_Error object on failure.
     **/
    public function reports_form( $request ) {
        $form_id     = isset( $request['form_id'] ) ? intval( $request['form_id'] ) : 0;
        $labels      = array();
        $data        = array();
        $field_name  = array();
        $field_label = array();
        $temp_names  = array();
        $form        = weforms()->form->get( $form_id );
        $fields      = $form->get_fields();

        if ( false === $fields ) {
            return new WP_Error('rest_weforms_invalid_field',__( 'No form fields found!','weforms' ),array( 'status' => 404 ) );
        }

        if ( sizeof( $fields ) < 1 ) {
            $fields[] = array(
                'label' => __( 'No form fields found!', 'weforms-pro' )
            );
        }

        foreach ( $fields as $key => $field ) {
            if ( empty( $field['value'] ) ) {
                $has_empty = true;
                break;
            }
        }

        foreach ( $fields as $field ) {
            $temp_names['template'][]    = $field['template'];
            $temp_names['field_name'][]  = $field['name'];
            $temp_names['field_label'][] = $field['label'];
        }

        $form_meta_keys  = $this->get_unique_form_keys( $form_id );

        $i = 0; $j = 0; $k = 0; $l = 0;

        array_shift( $form_meta_keys );
        $report_data = array();

        foreach ( $form_meta_keys as $key => $form_meta_key ) {
            $temp                   = $this->get_chart_data( $form_id, $form_meta_key, $temp_names['template'][$i] );
            $temp2                  = array_values( $temp['value'] );
            $temp['template']       = $temp_names['template'][$i++];
            $temp['field_name']     = $temp_names['field_name'][$j++];
            $temp['field_label']    = $temp_names['field_label'][$k++];

            if( is_array( $temp2[0] ) && !empty( $temp2 ) ) {
                $meta_array = array();

                foreach ($temp2 as $key => $value) {
                    if( !empty( $value ) && is_array( $value ) ) {
                       $meta_value  = unserialize( $value[0] );
                       $meta_array = array_merge($meta_array, $meta_value);
                    }
                }

                $temp2 = $meta_array;
            }

            $temp2 = array_count_values( $temp2 );
            ksort( $temp2 );

            foreach ( $temp2 as $key => $value) {
                if ( empty( $key ) || empty( $value ) ) {
                    continue;
                }
                $temp['data_label'][] = $key;
                $temp['data_value'][] = $value;
            }

            if ( !empty ( $temp['data_label'] ) ) {
                $temp['label'] = $temp['data_label'];
            }

            if ( !empty ( $temp['data_value'] ) ) {
                $temp['data'] = $temp['data_value'];
            }

            unset( $temp['value'], $temp['data_label'], $temp['data_value'] );

            $report_data[] = $temp;
        }

        $response = $report_data;

        $response = $this->prepare_response_for_collection( $response );
        $response = rest_ensure_response( $response );

        return $response;
    }

    /**
     * get Unique Form Key
     *
     * @param int $form_id
     *
     * @return string
     **/
    public function get_unique_form_keys( $form_id ) {
        global $wpdb;

        $form_keys         = array();
        $form_keys_sql     = "SELECT DISTINCT meta_key FROM " . $wpdb->prefix . "weforms_entries LEFT JOIN " . $wpdb->prefix . "weforms_entrymeta ON " . $wpdb->prefix . "weforms_entries.id = " . $wpdb->prefix . "weforms_entrymeta.weforms_entry_id WHERE form_id={$form_id}";
        $form_keys_results = $wpdb->get_results( $form_keys_sql );
        $meta_keys         = array();

        foreach ( $form_keys_results as $form_keys_result ) {
            $meta_keys[] = $form_keys_result->meta_key;
        }

        $meta_keys = array_filter( $meta_keys );

        return $meta_keys;
    }

    /**
     * get Chart Data
     *
     * @since  1.3.9
     *
     * @param int $form_id
     * @param string $meta_key
     * @param string $field_name
     *
     * @return array
     **/
    public function get_chart_data( $form_id, $meta_key, $field_name ) {
        global $wpdb;

        $field_count_sql       = "SELECT count(*) as value_count, meta_key FROM " . $wpdb->prefix . "weforms_entries LEFT JOIN " . $wpdb->prefix . "weforms_entrymeta ON " . $wpdb->prefix . "weforms_entries.id = " . $wpdb->prefix . "weforms_entrymeta.weforms_entry_id WHERE form_id={$form_id} AND meta_key='{$meta_key}'";
        $field_entries_sql     = "SELECT meta_key, meta_value FROM " . $wpdb->prefix . "weforms_entries LEFT JOIN " . $wpdb->prefix . "weforms_entrymeta ON " . $wpdb->prefix . "weforms_entries.id = " . $wpdb->prefix . "weforms_entrymeta.weforms_entry_id WHERE form_id={$form_id} AND meta_key='{$meta_key}'";
        $field_count_results   = $wpdb->get_results( $field_count_sql );
        $field_entries_results = $wpdb->get_results( $field_entries_sql );
        $values                = array(); $field_entries = array();

        foreach ( $field_count_results as $field_count_result ) {
            $field_entries['count'] = $field_count_result->value_count;
        }

        foreach ( $field_entries_results as $field_entries_result ) {
            if ( empty( $field_entries_result ) ) {
                continue;
            }

            $value = '';
            $keys = '';

            switch ( $field_name ) {
                case 'name_field':
                    $value = implode( ' ', explode( WeForms::$field_separator, $field_entries_result->meta_value ) );
                    $value = str_replace('  ', ' ', $value);
                    break;

                case 'textarea_field':
                case 'text_field' :
                    $value = strip_tags( weforms_format_text( $field_entries_result->meta_value ) );
                    break;

                case 'checkbox_grid':
                    $entry_value = unserialize( $field_entries_result->meta_value );
                    $value = array();

                    if ( $entry_value ) {
                        foreach ( $entry_value as $key => $option_value ) {
                            $value[$key] = $option_value;
                        }
                    }
                    break;

                case 'multiple_choice_grid':
                    $entry_value = unserialize( $field_entries_result->meta_value );
                    $value = array();

                    if ( $entry_value ) {
                        foreach ( $entry_value as $key => $option_value ) {
                            $value[$key] = $option_value;
                        }
                    }
                    break;

                case 'multiple_select':
                case 'checkbox_field':
                    $value  = explode( WeForms::$field_separator, $field_entries_result->meta_value );
                    $value  = array_filter( $value );
                    break;

                case 'single_product':
                    $field_value = maybe_unserialize( $field_entries_result->meta_value );
                    $value = array();

                    if ( is_array( $field_value ) ) {
                        foreach ( $field_value as $key => $sv ) {
                            $value[$key] = $sv;
                        }
                    }
                    break;

                case 'multiple_product':
                    $field_value = maybe_unserialize( $field_entries_result->meta_value );
                    $value = array();

                    if ( is_array( $field_value ) ) {
                        foreach ( $field_value as $key => $sfv ) {
                            if ( is_array( $sfv ) ) {
                                foreach ( $sfv as $key => $sv ) {
                                    $sv = str_replace( array( '_', '-' ), ' ', $key ) . ': ' . $sv;
                                    $sv = ucwords( $sv );
                                    $value[] = $sv;
                                }
                            }
                        }
                    }
                    break;

                case 'payment_method':
                    $value = maybe_unserialize( $field_entries_result->meta_value );
                    break;

                default:
                    $value = $field_entries_result->meta_value;
                    break;
            }

            $values[] = $value;
        }

        $field_entries['value'] = $values;
        $field_entries          = $this->process_chart_data( $field_entries, $meta_key, $field_name );

        return $field_entries;
    }


    /**
     * Process chart data of a form
     *
     * @since  1.3.9
     * @param array $form_entries
     * @param string $meta_key
     * @param string $meta_key
     *
     * @return array
     **/
    public function process_chart_data( $form_entries, $meta_key, $field_name  ) {
        $color_arr = array( "#EC5657", "#1BCDD1", "#8FAABB", "#B08BEB", "#3EA0DD", "#F5A52A", "#23BFAA", "#FAA586", "#EB8CC6", "#36A2EB", "#FF6384", "#FFCE56", "#4BC0C0", "#4661EE" );
        $values    = array(); $labels = array(); $colors = array(); $chart_type = 'bar';

        switch( $field_name ) {

            case 'multiple_choice_grid':
                $data = array(); $temp_data = array(); $temp_data2 = array(); $val_count = array();
                for( $i = 0; $i < count( $form_entries['value'] ); $i++ ) {
                    $data = array_merge_recursive( $data, $form_entries['value'][$i] );
                }
                if ( count( $form_entries['value'] ) == 1 ) {
                    foreach ( $data as $key => $val ) {
                        $labels[]          = $key;
                        $temp_data[$val][] = 1;
                    }

                    for ( $i = 0; $i < count( $labels); $i++ ) {
                        for ( $j = 0; $j < count( $labels ); $j++ ) {
                            if ( $i == $j ) {
                                $temp_data2[$i][$j] = 1;
                            } else {
                                $temp_data2[$i][$j] = 0;
                            }
                        }
                    }

                    $i = 0;
                    foreach ( $temp_data as $key => $value) {
                        unset( $value );
                        $temp_data[$key] = $temp_data2[$i++];
                    }

                    $values = $temp_data;
                } else {
                    foreach ( $data as $key => $val ) {
                        $temp_data[$key] = array_count_values( $val );
                    }

                    $columns = array();

                    foreach ( $temp_data as $key => $val ) {
                        $labels[] = $key;
                         foreach ( $val as $k => $v ) {
                            $columns[] = $k;
                        }
                    }

                    $columns = array_unique( $columns );
                    $columns = array_count_values( $columns );

                    foreach ( $columns as $key => $value ) {
                        $columns[$key] = 0;
                    }

                    foreach ( $temp_data as $key => $val ) {
                        $tmp = array_diff_key( $columns, $val );
                        $val = array_merge( $val, $tmp );
                        $temp_data[$key] = $val;
                    }

                    foreach( $temp_data as $tdata ) {
                        $temp_data2 = array_merge_recursive( $temp_data2, $tdata );
                    }

                    $values = $temp_data2;
                }

                for ($i = 0, $j = 0; $i < count( $labels ) ; $i++, $j++) {
                    if ( $j == 14 ) {
                        $j = 0;
                    }

                    $colors[] = $color_arr[$j];
                }

                break;

            case 'checkbox_grid':
                $data = array(); $temp_data = array(); $temp_data2 = array(); $val_count = array();

                for( $i = 0; $i < count( $form_entries['value'] ); $i++ ) {
                    $data = array_merge_recursive( $data, $form_entries['value'][$i] );
                }

                foreach ( $data as $key => $val ) {
                    $temp_data[$key] = array_count_values( $val );
                }

                $columns = array();

                foreach ( $temp_data as $key => $val ) {
                    $labels[] = $key;
                     foreach ( $val as $k => $v ) {
                        $columns[] = $k;
                    }
                }

                $columns = array_unique( $columns );
                $columns = array_count_values( $columns );

                foreach ( $columns as $key => $value ) {
                    $columns[$key] = 0;
                }

                foreach ( $temp_data as $key => $val ) {
                    $tmp             = array_diff_key( $columns, $val );
                    $val             = array_merge( $val, $tmp );
                    $temp_data[$key] = $val;
                }

                foreach( $temp_data as $tdata ) {
                    $temp_data2 = array_merge_recursive( $temp_data2, $tdata );
                }

                $values = $temp_data2;

                for ($i = 0, $j = 0; $i < count( $labels ) ; $i++, $j++) {
                    if ( $j == 14 ) {
                        $j = 0;
                    }
                    $colors[] = $color_arr[$j];
                }
                break;

            case 'multiple_select':
            case 'checkbox_field':
                foreach ( $form_entries['value'] as $entry_value ) {
                    foreach ( $entry_value as $entry_val ) {
                        $temp[] = $entry_val;
                    }
                }
                $temp = array_count_values( $temp );
                foreach ( $temp as $key => $value) {
                    $labels[] = $key;
                    $values[] = $value;
                }

                for ( $i = 0; $i < count( $labels ); $i++ ) {
                    $colors[$i] = $color_arr[0];
                }
                break;

            case 'single_product':

                foreach ( $form_entries['value']  as $entry_value ) {
                    foreach ( $entry_value as $key => $entry_val ) {
                        if ( $key == 'product' ) {
                            $labels[] = $key;
                        }
                        if ( $key == 'price' ) {
                            $values[] = $entry_val;
                        }
                    }
                }

                for ( $i = 0; $i < count( $values ); $i++ ) {
                    $colors[$i] = $color_arr[0];
                }
                break;

            case 'multiple_product':
                foreach ( $form_entries['value'] as $entry_value ) {
                    for( $i = 0; $i < count( $entry_value ); $i++) {
                        if ( $i == 0 ) {
                            $labels[] = str_replace( "Product: ","","$entry_value[0]" );
                        }

                        if ( $i == 2 ) {
                            $values[] = str_replace( "Price: ","","$entry_value[2]" );
                        }
                    }
                }

                for ($i = 0, $j = 0; $i < count( $labels ) ; $i++, $j++) {
                    if ( $j == 14 ) {
                        $j = 0;
                    }
                    $colors[] = $color_arr[$j];
                }

                break;

            default:
                $temp = array_count_values( $form_entries['value'] );

                for ( $i = 0; $i < count( $temp ); $i++ ) {
                    $colors[$i] = $color_arr[0];
                }
                break;
        }

        if ( !empty( $labels ) ) {
            $form_entries['label'] = $labels;
        }

        if ( !empty( $values ) ) {
            $form_entries['data'] = $values;
        }

        if ( !empty( $colors ) ) {
            $form_entries['bg_color'] = $colors;
        }

        $form_entries['chart_type'] = $chart_type;

        return $form_entries;
    }
}
