<?php

/**
 * Admin Class
 */
class WeForms_Pro_Admin {

    function __construct() {
        add_action( 'wpuf-form-builder-add-js-templates', array( $this, 'js_template' ) );

        add_filter( 'weforms_vue_routes', array( $this, 'vue_routes' ) );

        add_action( 'weforms_form_settings_form', array( $this, 'form_settings_misc_settings' ) );
        add_action( 'weforms_form_settings_form', array( $this, 'form_settings_multistep' ) );
        add_action( 'weforms_form_settings_form', array( $this, 'form_settings_condition_on_submit_button' ) );

        add_filter( 'weforms_form_access_capability', array( $this, 'grant_admin_permission' ) );

        add_filter( 'weforms_settings_tabs', array( $this, 'set_default_settings' ), 6 );
        add_filter( 'weforms_settings_tab_content_google-map', array( $this, 'settings_panel' ) );
    }


    /**
     * Set default settings tabs
     *
     * @param array $tabs
     *
     * @return array
     */
    function set_default_settings( $tabs = array() ) {

        $tabs['google-map']   = array(
            'label' => __('Google Map', 'weforms'),
            'icon'  => WEFORMS_ASSET_URI . '/images/integrations/google-map.svg',
        );

        return $tabs;
    }


    /**
     * Add pro routes into the router
     *
     * @param  array $routes
     *
     * @return array
     */
    public function vue_routes( $routes ) {
        $routes[] = array(
            'path'      => '/modules',
            'name'      => 'modules',
            'component' => 'Modules'
        );

        return $routes;
    }

    /**
     * Add component template
     *
     * @return void
     */
    public function js_template() {

        if ( ! defined( 'WPUF_PRO_ASSET_URI' ) ) {
            define( 'WPUF_PRO_ASSET_URI', WEFORMS_PRO_ASSETS );
        }

        include WEFORMS_PRO_PATH . '/assets/js/component-templates.php';
        include WEFORMS_PRO_PATH . '/assets/pro-fields/form-components.php';
    }

    /**
     * Render the settings panel
     *
     * @return void
     */
    public function settings_panel() {
        include_once dirname( __FILE__ ) . '/views/settings.php';
    }

    /**
     * Misc. settings
     *
     * @return void
     */
    public function form_settings_misc_settings() {
        include_once dirname( __FILE__ ) . '/views/settings-misc_settings.php';
    }

    /**
     * Multistep settings
     *
     * @return void
     */
    public function form_settings_multistep() {
        include_once dirname( __FILE__ ) . '/views/settings-multistep.php';
    }

    /**
     * Conditional logic on submit button settings
     *
     * @return void
     *
     * @since 1.3.6
     */
    public function form_settings_condition_on_submit_button() {
        include_once dirname( __FILE__ ) . '/views/settings-condition_on_submit_button.php';
    }

    /**
     * Grants admin access capability for other roles
     *
     * @param  string $capability
     *
     * @return string
     */
    public function grant_admin_permission( $capability ) {
        $capability = weforms_get_settings( 'permission', 'manage_options' );

        return $capability;
    }
}
