<?php

/**
 * Pro Fields Manager
 */
class WeForms_Pro_Fields_Manager {

    function __construct() {
        add_filter( 'weforms_form_fields', array( $this, 'register_fields' ) );

        add_filter( 'weforms_field_groups_custom', array( $this, 'add_to_custom_fields' ) );
        add_filter( 'weforms_field_groups_others', array( $this, 'add_to_others_fields' ) );

        add_filter( 'weforms_field_get_js_settings', array( $this, 'add_conditional_field' ) );

        // step start fields
        add_action( 'weforms_form_fields_top', array( $this, 'step_start_form_top' ), 10, 2 );
    }

    /**
     * Register pro fields
     *
     * @param  array $fields
     *
     * @return array
     */
    public function register_fields( $fields ) {

        require_once dirname( __FILE__ ) . '/fields/class-field-repeat.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-date.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-file.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-country.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-numeric.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-address.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-gmap.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-shortcode.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-hook.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-toc.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-rating.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-step.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-linear-scale.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-checkbox-grid.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-multiple-choice-grid.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-signature.php';
        require_once dirname( __FILE__ ) . '/fields/class-field-phone.php';

        $fields['repeat_field']         = new WeForms_Form_Field_Repeat();
        $fields['date_field']           = new WeForms_Form_Field_Date();
        $fields['file_upload']          = new WeForms_Form_Field_File();
        $fields['country_list_field']   = new WeForms_Form_Field_Country();
        $fields['numeric_text_field']   = new WeForms_Form_Field_Numeric();
        $fields['address_field']        = new WeForms_Form_Field_Address();
        $fields['google_map']           = new WeForms_Form_Field_GMap();
        $fields['shortcode']            = new WeForms_Form_Field_Shortcode();
        $fields['action_hook']          = new WeForms_Form_Field_Hook();
        $fields['toc']                  = new WeForms_Form_Field_Toc();
        $fields['ratings']              = new WeForms_Form_Field_Rating();
        $fields['step_start']           = new WeForms_Form_Field_Step();
        $fields['linear_scale']         = new WeForms_Form_Field_Linear_Scale();
        $fields['checkbox_grid']        = new WeForms_Form_Field_Checkbox_Grid();
        $fields['multiple_choice_grid'] = new WeForms_Form_Field_Multiple_Choice_Grid();
        $fields['signature_field']      = new WeForms_Form_Field_Signature();
        $fields['phone_field']          = new WeForms_Form_Field_Phone();

        return $fields;
    }

    /**
     * Register fields to custom field section
     *
     * @param array $fields
     */
    public function add_to_custom_fields( $fields ) {
        $pro_fields = array(
            'repeat_field', 'date_field', 'file_upload', 'country_list_field', 'phone_field',
            'numeric_text_field', 'address_field', 'google_map', 'step_start', 'signature_field'
        );

        return array_merge( $fields, $pro_fields );
    }

    /**
     * Register fields to others field section
     *
     * @param array $fields
     */
    public function add_to_others_fields( $fields ) {
        $pro_fields = array(
            'shortcode', 'action_hook', 'toc', 'ratings', 'linear_scale', 'checkbox_grid', 'multiple_choice_grid'
        );

        return array_merge( $fields, $pro_fields );
    }

    /**
     * Add conditional field settings
     *
     * @param array $settings
     */
    public function add_conditional_field( $settings ) {
        $settings['settings'][] = array(
            'name'           => 'wpuf_cond',
            'title'          => __( 'Conditional Logic', 'weforms-pro' ),
            'type'           => 'conditional-logic',
            'section'        => 'advanced',
            'priority'       => 30,
            'help_text'      => '',
        );

        return $settings;
    }

    /**
     * [step_start_form_top description]
     *
     * @param  \WeForms_Form $form
     * @param  array $form_fields
     *
     * @return void
     */
    public function step_start_form_top( $form, $form_fields ) {
        $settings     = $form->get_settings();
        $is_multistep = isset( $settings['enable_multistep'] ) && $settings['enable_multistep'];

        if ( ! $is_multistep ) {
            return;
        }

        if ( isset( $settings['multistep_progressbar_type'] ) && $settings['multistep_progressbar_type'] == 'progressive' ) {
            wp_enqueue_script('jquery-ui-progressbar');
        }

        if ( isset( $settings['enable_multistep'] ) && $settings['enable_multistep'] == 'yes' ) {
            $ms_ac_txt_color   = isset( $settings['ms_ac_txt_color'] ) ? $settings['ms_ac_txt_color'] : '#ffffff';
            $ms_active_bgcolor = isset( $settings['ms_active_bgcolor'] ) ? $settings['ms_active_bgcolor'] : '#00a0d2';
            $ms_bgcolor        = isset( $settings['ms_bgcolor'] ) ? $settings['ms_bgcolor'] : '#E4E4E4';
            ?>
            <style type="text/css">
                .wpuf-form-add .wpuf-form .wpuf-multistep-progressbar ul.wpuf-step-wizard li,
                .wpuf-form-add .wpuf-form .wpuf-multistep-progressbar.ui-progressbar {
                    background-color:  <?php echo $ms_bgcolor; ?>;
                    background:  <?php echo $ms_bgcolor; ?>;
                }
                .wpuf-form-add .wpuf-form .wpuf-multistep-progressbar ul.wpuf-step-wizard li::after{
                    border-left-color: <?php echo $ms_bgcolor; ?>;
                }
                .wpuf-form-add .wpuf-form .wpuf-multistep-progressbar ul.wpuf-step-wizard li.active-step,
                .wpuf-form-add .wpuf-form .wpuf-multistep-progressbar .ui-widget-header{
                    color: <?php echo $ms_ac_txt_color; ?>;
                    background-color:  <?php echo $ms_active_bgcolor; ?>;
                }
                .wpuf-form-add .wpuf-form .wpuf-multistep-progressbar ul.wpuf-step-wizard li.active-step::after {
                    border-left-color: <?php echo $ms_active_bgcolor; ?>;
                }
                .wpuf-form-add .wpuf-form .wpuf-multistep-progressbar.ui-progressbar .wpuf-progress-percentage{
                    color: <?php echo $ms_ac_txt_color; ?>;
                }
            </style>
            <input type="hidden" name="wpuf_multistep_type" value="<?php echo $settings['multistep_progressbar_type'] ?>"/>

            <?php

            if ( $settings['multistep_progressbar_type'] == 'step_by_step' ){
                ?>
                <!-- wpuf-multistep-progressbar -->
                <div class="wpuf-multistep-progressbar">

                </div>
            <?php
            } else {
                ?>
                <div class="wpuf-multistep-progressbar">

                </div>
            <?php

            }
        }

    }
}
