<?php

/**
 * The Pro integration class
 */
class WeForms_Pro_Integration extends WeForms_Abstract_Integration {

	/**
     * The settings settings_template
     *
     * @var array
     */
    protected $settings_template = null;


    /**
     * Check if it's the forms page
     *
     * @return boolean
     */
    public function is_weforms_page() {
        if ( get_current_screen()->base != 'toplevel_page_weforms' ) {
            return false;
        }

        return true;
    }

    /**
     * Load the individual template file if exists
     *
     * @return void
     */
    public function load_template() {
        if ( ! $this->is_weforms_page() ) {
            return;
        }

        if ( ! $this->template ) {
            return;
        }

        echo '<script type="text/x-template" id="tmpl-wpuf-integration-' . $this->id . '">';
        include $this->template;
        echo '</script>';
    }

    /**
     * Load settings
     *
     * @return void
     */
    public function load_settings( $priority = 10 ) {

        if ( ! $this->settings_template ) {
            return;
        }

        add_action( 'weforms_settings_tabs', array( $this, 'settings_tabs' ), $priority );
        add_action( 'weforms_settings_tab_content_' . $this->id, array( $this, 'settings_panel' ), $priority );
    }


    /**
     * Render the settings panel
     *
     * @return void
     */
    public function settings_panel() {
        if( file_exists( $this->settings_template )) {
            include $this->settings_template;
        }
    }

    /**
     * Add new tab at settings
     *
     * @return void
     */
    public function settings_tabs( $tabs ) {

        $tabs[ $this->id ] = array(
            'label' => $this->title,
            'icon' => $this->icon,
        );

        return $tabs;
    }


    /**
     * Get file prefix
     *
     * @return string
     */
    public function get_prefix() {
        $prefix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

        return $prefix;
    }

    /**
     * Get default componenet url
     *
     * @return string
     */
    public function module_component_file( $plugin_file ) {

        $prefix = $this->get_prefix();

        return plugins_url( 'component/index' . $prefix . '.js', $plugin_file );
    }

}
