<?php

/**
 * The modules class
 */
class WeForms_Pro_Modules {

    function __construct() {
        add_action( 'wp_ajax_weforms_get_modules', array( $this, 'get_modules' ) );
        add_action( 'wp_ajax_weforms_toggle_modules', array( $this, 'toggle_modules' ) );
    }

    /**
     * Administrator validation
     *
     * @return void
     */
    public function check_admin() {
        if ( !current_user_can( 'administrator' ) ) {
            wp_send_json_error( __( 'You do not have sufficient permission.', 'weforms' ) );
        }
    }

    /**
     * Fetch all the modules
     *
     * @return void
     */
    public function get_modules() {
        check_ajax_referer( 'weforms' );
        $this->check_admin();

        $modules = array(
            'all'    => weforms_pro_get_modules(),
            'active' => weforms_pro_get_active_modules()
        );

        wp_send_json_success( $modules );
    }

    /**
     * Activate/deactivate a module
     *
     * @return void
     */
    public function toggle_modules() {
        check_ajax_referer( 'weforms' );
        $this->check_admin();

        $module = isset( $_POST['module'] ) ? sanitize_text_field( $_POST['module'] ) : '';
        $type   = isset( $_POST['type'] ) ? $_POST['type'] : '';

        if ( ! $module ) {
            wp_send_json_error( __( 'Invalid module provided', 'weforms-pro' ) );
        }

        if ( ! in_array( $type, array( 'activate', 'deactivate' ) ) ) {
            wp_send_json_error( __( 'Invalid request type', 'weforms-pro' ) );
        }

        if ( 'all' === $module ) {
            $modules = weforms_pro_get_modules();
        } else {
            $modules = array( $module => weforms_pro_get_module( $module ) );
        }

        if ( 'activate' == $type ) {
            foreach ($modules as $module_file => $data) {
                weforms_pro_activate_module( $module_file );
            }

            $message = sprintf( __( 'Activated', 'weforms-pro' ) );

        } else {
            foreach ($modules as $module_file => $data) {
                weforms_pro_deactivate_module( $module_file );
            }

            $message = sprintf( __( 'Deactivated', 'weforms-pro' ) );
        }

        wp_send_json_success( $message );
    }

}
