<?php

/**
 * Form single entry resend notifications class
 *
 *@since 1.2.7
 */
class WeForms_Resend_Notifications {

    /**
     * Constructor
     *
     */
    public function __construct() {
        add_action( 'weforms_entry_single_right_metabox', array( $this, 'metabox_data' ) );
        add_action( 'wp_ajax_weforms_form_active_notifications', array( $this, 'get_active_notifications' ) );
        add_action( 'wp_ajax_weforms_entry_resend_notifications', array( $this, 'resend_entry_notification' ) );
    }

    /**
     * Initializes the WeForms_Form_Report() class
     *
     */
    public static function init() {
        static $instance = false;

        if ( ! $instance ) {
            $instance = new WeForms_Resend_Notifications();
        }

        return $instance;
    }

    /**
     * Load resend notification metabox on single entry page
     *
     */
    public function metabox_data( ) {
        ob_start(); ?>
            <form-entry-resend-notifications></form-entry-resend-notifications>
        <?php echo ob_get_clean();
    }

    /**
     * Get active notifications of a form
     *
     * @param  int $form_id
     *
     * @return array|boolean
     */
    public function get_active_notifications() {
        check_ajax_referer( 'weforms' );

        $form_id  = isset( $_REQUEST['form_id'] ) ? intval( $_REQUEST['form_id'] ) : 0;

        $notifications = $this->get_form_notifications( $form_id );

        $response = array(
            'form_notifications'  => $notifications,
        );

        wp_send_json_success( $response );
    }

    /**
     * Send email selected notifications
     *
     */
    public function resend_entry_notification() {
        check_ajax_referer( 'weforms' );

        $form_id        = isset( $_REQUEST['form_id'] ) ? $_REQUEST['form_id'] : 0;
        $entry_id       = isset( $_REQUEST['entry_id'] ) ? $_REQUEST['entry_id'] : 0;
        $notifications  = isset( $_REQUEST['notifications'] ) ? $_REQUEST['notifications'] : null;

        $entry = new WeForms_Notification( array(
            'form_id'  => $form_id,
            'page_id'  => 0,
            'entry_id' => $entry_id
        ) );

        $entry->resend_entry_notifications( $notifications );

        $response = array(
            'message'  => __( 'Notifications has been sent.', 'weforms-pro' ),
        );

        wp_send_json_success( $response );
    }

    /**
     * Get notifications of a form
     *
     * @param  int $form_id
     *
     * @return array|boolean
     */
    public function get_form_notifications( $form_id ) {
        $notifications = weforms()->form->get( $form_id )->get_notifications();

        if ( $notifications ) {
            $notifications = array_filter( $notifications, function($notification) {
                return $notification['active'] == true;
            } );

            return $notifications;
        }

        return false;
    }
}

$weforms_resend_notifications = WeForms_Resend_Notifications::init();