<?php

/**
 * Plugin Upgrade Routine
 *
 * @since 1.1.1
 */
class WeForms_Upgrades_Pro {

    /**
     * The upgrades
     *
     * @var array
     */
    private static $upgrades = array(
        '1.1.1' => 'upgrades/upgrade-1.1.1.php'
    );

    /**
     * Get the plugin version
     *
     * @return string
     */
    public function get_version() {
        return get_option( 'weforms_pro_version' );
    }

    /**
     * Check if the plugin needs any update
     *
     * @return boolean
     */
    public function needs_update() {

        // may be it's the first install
        if ( ! $this->get_version() ) {
            return false;
        }

        if ( version_compare( $this->get_version(), WEFORMS_PRO_VERSION, '<' ) ) {
            return true;
        }

        return false;
    }

    /**
     * Perform all the necessary upgrade routines
     *
     * @return void
     */
    function perform_updates() {
        $installed_version = $this->get_version();
        $path              = trailingslashit( dirname( __FILE__ ) );

        foreach ( self::$upgrades as $version => $file ) {
            if ( version_compare( $installed_version, $version, '<' ) ) {
                include $path . $file;
                update_option( 'weforms_pro_version', $version );
            }
        }

        update_option( 'weforms_pro_version', WEFORMS_PRO_VERSION );
    }
}
