<?php

/**
 * Mailgun Emailer Class
 */
class WeForms_Emailer_Mailgun implements WeForms_Mailer_Contract {

    private $endpoint = 'https://api.mailgun.net/v3/%domain%/messages';

    public function send( $to, $subject, $body, $headers ) {
        $gateways = weforms_get_settings( 'gateways' );

        $api_key = isset( $gateways->mailgun ) ? $gateways->mailgun : '';
        $domain  = isset( $gateways->mailgun_domain ) ? $gateways->mailgun_domain : '';

        if ( !$api_key && !$domain ) {
            return;
        }

        $mail_args = array(
            'to'      => $to,
            'subject' => $subject,
            'text'    => strip_tags( $body ),
            'html'    => $body,
        );

        if ( isset( $headers['from'] ) ) {
            $mail_args['from'] = sprintf( '%s <%s>', $headers['from']['name'], $headers['from']['email'] );
        }

        if ( isset( $headers['replyto'] ) ) {
            $mail_args['h:Reply-To'] = $headers['replyto'];
        }

        if ( isset( $headers['cc'] ) ) {
            $mail_args['cc'] = $headers['cc'];
        }

        if ( isset( $headers['bcc'] ) ) {
            $mail_args['bcc'] = $headers['bcc'];
        }

        $args = array(
            'headers' => array(
                'Authorization' => 'Basic ' . base64_encode( 'api:' . $api_key ),
            ),
            'body' => $mail_args
        );

        $endpoint = str_replace( '%domain%', $domain, $this->endpoint );
        $response = wp_remote_post( $endpoint, $args );

        if ( 200 !== wp_remote_retrieve_response_code( $response ) ) {
            weforms()->log('error', 'wemail-mailgun: ' . wp_remote_retrieve_body( $response ) );
            return false;
        }

        return true;
    }
}
