<?php

/**
 * Sendgrid Emailer Class
 */
class WeForms_Emailer_SendGrid implements WeForms_Mailer_Contract {

    private $endpoint = 'https://api.sendgrid.com/v3/mail/send';

    public function send( $to, $subject, $body, $headers ) {
        $gateways = weforms_get_settings( 'gateways' );
        $api_key  = isset( $gateways->sendgrid ) ? $gateways->sendgrid : '';

        if ( ! $api_key ) {
            return;
        }

        $mail_args = array(
            'personalizations' => array(
                array(
                    'to' => array(
                        array( 'email' => $to )
                    )
                )
            ),
            'from' => array(
                'email' => $headers['from']['email'],
                'name' => $headers['from']['name']
            ),
            'reply_to' => array(
                'email' => $headers['replyto'],
            ),
            'subject' => $subject,
            'content' => array(
                array(
                    'type'  => 'text/html',
                    'value' => $body
                )
            )
        );

        $args = array(
            'headers' => array(
                'Content-type'  => 'application/json',
                'Authorization' => 'Bearer ' . $api_key,
            ),
            'body' => wp_json_encode( $mail_args )
        );

        $response = wp_remote_post( $this->endpoint, $args );

        if ( 202 !== wp_remote_retrieve_response_code( $response ) ) {
            weforms()->log('error', 'wemail-sendgrid: ' . wp_remote_retrieve_body( $response ) );
            return false;
        }

        return true;
    }
}
