<?php

/**
 * Sparkpost Emailer Class
 */
class WeForms_Emailer_SparkPost implements WeForms_Mailer_Contract {

    private $endpoint = 'https://api.sparkpost.com/api/v1/transmissions';

    public function send( $to, $subject, $body, $headers ) {
        $gateways = weforms_get_settings( 'gateways' );
        $api_key  = isset( $gateways->sparkpost ) ? $gateways->sparkpost : '';

        if ( ! $api_key ) {
            return;
        }

        $mail_args = array(
            'recipients' => array(
                array(
                    'address' => array(
                        'email' => $to
                    )
                )
            ),

            'content' => array(
                'html'    => $body,
                'text'    => $body,
                'subject' => $subject,
                'from'    => array(
                    'email' => $headers['from']['email'],
                    'name'  => $headers['from']['name'],
                ),
                'reply_to' => isset( $headers['replyto'] ) ? $headers['replyto'] : null,
                'headers' => array(
                    'x-content-type' => 'text/html'
                )
            ),
        );

        if ( isset( $headers['cc'] ) ) {
            $mail_args['content']['headers']['CC'] = $headers['cc'];
        }

        if ( isset( $headers['bcc'] ) ) {
            $mail_args['recipients'][] = array(
                'address' => array(
                    'email'     => $headers['bcc'],
                    'header_to' => $to
                )
            );
        }

        $args = array(
            'headers' => array(
                'Content-type'  => 'application/json',
                'Authorization' => $api_key,
                'User-Agent'    => 'weforms-sparkpost',
            ),
            'body' => wp_json_encode( $mail_args )
        );

        $response = wp_remote_post( $this->endpoint, $args );

        if ( 200 !== wp_remote_retrieve_response_code( $response ) ) {
            weforms()->log('error', 'wemail-sparkpost: ' . wp_remote_retrieve_body( $response ) );
            return false;
        }

        return true;
    }

}
