<?php

/**
 * Text Field Class
 */
class WeForms_Form_Field_Checkbox_Grid extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'Checkbox Grid', 'weforms' );
        $this->input_type = 'checkbox_grid';
        $this->icon       = 'th';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        $selected = !empty( $field_settings['selected'] ) ? $field_settings['selected'] : array();
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings, $form_id ); ?>

            <div class="wpuf-fields" data-required="<?php echo $field_settings['required'] ?>" data-type="radio">

                <?php
                // echo "<pre>"; var_dump($field_settings); echo "</pre>";
                if ( $field_settings['grid_rows'] && count( $field_settings['grid_rows'] ) > 0 &&  $field_settings['grid_columns'] && count( $field_settings['grid_columns'] ) > 0 ) {
                    ?>
                    <div class="wpufTable">
                        <div class="wpufTableHeading">
                            <div class="wpufTableRow">
                                <div class="wpufTableHead">&nbsp;</div>
                                <?php foreach ( $field_settings['grid_columns'] as $column ) {
                                    echo '<div class="wpufTableHead">' . $column . "</div>";
                                } ?>
                            </div>
                        </div>
                        <div class="wpufTableBody">
                            <?php
                            foreach ( $field_settings['grid_rows'] as $row_key => $row_value ) {
                                ?>
                                <div class="wpufTableRow">
                                    <div class="wpufTableHead"><?php echo $row_value; ?></div>
                                    <?php foreach ( $field_settings['grid_columns'] as $column_key => $column_value ) {
                                        ?>
                                        <div class="wpufTableCell">
                                            <label class="wpuf-checkbox-inline">
                                                <input
                                                    type="checkbox"
                                                    class="<?php echo 'wpuf_' . $field_settings['name']. '_'. $form_id; ?>"
                                                    name="<?php echo $field_settings['name'] . '[' . $row_key . ']'; ?>[]"
                                                    value="<?php echo esc_attr( $column_value ); ?>"
                                                    <?php echo in_array( $column_value, $selected ) ? ' checked="checked"' : ''; ?> />
                                            </label>
                                        </div>
                                        <?php
                                    } ?>
                                </div>
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                    <?php
                }
                ?>

                <?php $this->help_text( $field_settings ); ?>

            </div>
        </li>
        <?php
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options  = $this->get_default_option_settings( true, array( 'width' ) );
        $dropdown_options = array(
            array(
                'name'          => 'grid_rows',
                'title'         => __( 'Rows', 'wpuf' ),
                'type'          => 'row-data',
                'is_multiple'   => true,
                'section'       => 'basic',
                'priority'      => 12,
                'help_text'     => __( 'Add rows for the form field', 'wpuf' ),
            ),
            array(
                'name'          => 'grid_columns',
                'title'         => __( 'columns', 'wpuf' ),
                'type'          => 'column-data',
                'is_multiple'   => true,
                'section'       => 'basic',
                'priority'      => 15,
                'help_text'     => __( 'Add columns for the form field', 'wpuf' ),
            ),
        );

        return array_merge( $default_options, $dropdown_options );
    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();
        $props    = array(
            'selected'       => array(),
            'grid_rows'      => array( 'Row' => __( 'Row', 'wpuf' ) ),
            'grid_columns'   => array( 'Column' => __( 'Column', 'wpuf' ) ),
        );

        return array_merge( $defaults, $props );
    }

    /**
     * Prepare entry
     *
     * @param $field
     *
     * @return mixed
     */
    public function prepare_entry( $field, $args = [] ) {
        $args        = ! empty( $args ) ? $args : $_POST;
        $entry_value = ( is_array( $args[$field['name']] ) && $args[$field['name']] ) ? $args[$field['name']] : array();

        return $entry_value;
    }
}
