<?php

/**
 * Country Field Class
 */
class WeForms_Form_Field_Country extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'Country List', 'weforms' );
        $this->input_type = 'country_list_field';
        $this->icon       = 'globe';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        $country_list             = $field_settings['country_list'];
        $list_visibility_option   = $country_list['country_list_visibility_opt_name'];
        $country_select_hide_list = isset( $country_list['country_select_hide_list'] ) && is_array( $country_list['country_select_hide_list'] ) ? $country_list['country_select_hide_list'] : array();
        $country_select_show_list = isset( $country_list['country_select_show_list'] ) && is_array( $country_list['country_select_show_list'] ) ? $country_list['country_select_show_list'] : array();
        $value                    = isset( $country_list['name'] ) ? $country_list['name'] : '';
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings ); ?>

            <div class="wpuf-fields <?php echo ' wpuf_'.$field_settings['name'].'_'.$form_id; ?>">
                <select
                    name="<?php echo $field_settings['name']; ?>"
                    data-required="<?php echo $field_settings['required'] ?>"
                    data-type="select"
                ></select>

                <?php $this->help_text( $field_settings ); ?>
            </div>

            <?php
                $field_name        = $field_settings['name'];
                $countries         = weforms_pro_get_countries();
                // $banned_countries  = json_encode( $country_select_hide_list );
                $banned_countries  = $country_select_hide_list;
                // $allowed_countries = json_encode($country_select_show_list);
                $allowed_countries =  $country_select_show_list;
                $sel_country       = !empty( $value ) ? $value : '' ;
                $option_string     = '<option value="-1">Select Country</option>';

                if ( $list_visibility_option == 'hide' ) {
                    foreach ( $countries as $country ) {
                        if ( in_array( $country['code'], $banned_countries ) ) {
                            continue;
                        }
                        $selected = ( $sel_country == $country['code'] ) ? 'selected':'';
                        $option_string .= "<option value=\"{$country['code']}\" { $selected } > {$country['name']}  </option>";
                    }
                } else if ( $list_visibility_option == 'show' ) {
                    foreach ( $countries as $country ) {
                        if ( in_array( $country['code'], $allowed_countries ) ) {
                            $selected = ( $sel_country == $country['code'] ) ? 'selected':'';
                            $option_string .= "<option value=\"{$country['code']}\" { $selected } > {$country['name']}  </option>";
                        }
                    }
                } else {
                    foreach ( $countries as $country ) {
                        $selected = ( $sel_country == $country['code'] ) ? 'selected':'';
                        $option_string .= "<option value=\"{$country['code']}\" { $selected } > {$country['name']}  </option>";
                    }
                }

                $script = "jQuery(document).ready(function($){
                    var field_name =`{$field_settings['name']}`;
                    $('select[name=\"'+ field_name +'\"]').html(`{$option_string}`);
                });";
               wp_add_inline_script( 'wpuf-form', $script );
            ?>
        </li>
        <?php
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options      = $this->get_default_option_settings( true, array( 'width' ) );

        $settings = array(
            array(
                'name'          => 'country_list',
                'title'         => '',
                'type'          => 'country-list',
                'section'       => 'advanced',
                'priority'      => 22,
                'help_text'     => '',
            )
        );

        return array_merge( $default_options, $settings );
    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();
        $props    = array(
            'country_list'  => array(
                'name'                              => '',
                'country_list_visibility_opt_name'  => 'all', // all, hide, show
                'country_select_show_list'          => array(),
                'country_select_hide_list'          => array()
            )
        );

        return array_merge( $defaults, $props );
    }
}
