<?php

/**
 * Date Field Class
 */
class WeForms_Form_Field_Date extends WeForms_Field_Contract {

	/**
	 * Class Constructor
	 */
	public function __construct() {
		$this->name       = __( 'Date / Time', 'weforms' );
		$this->input_type = 'date_field';
		$this->icon       = 'calendar-o';
	}

	/**
	 * Render the text field
	 *
	 * @param  array   $field_settings field settings passed from form editor.
	 * @param  integer $form_id WeForms form ID.
	 *
	 * @return void
	 */
	public function render( $field_settings, $form_id ) {
		$value = '';
		?>
		<li <?php $this->print_list_attributes( $field_settings ); ?>>
			<?php $this->print_label( $field_settings ); ?>

			<div class="wpuf-fields">
				<input
					id="wpuf-date-<?php echo esc_attr( $field_settings['name'] ); ?>"
					type="text"
					<?php
						$field_settings['enforce_format'] = ! isset( $field_settings['enforce_format'] ) ? '' : $field_settings['enforce_format'];
						echo esc_attr( $field_settings['enforce_format'] !== 'yes' ) ? '' : 'readonly';
					?>
					class="datepicker <?php echo ' wpuf_' . esc_attr( $field_settings['name'] ) . '_' . esc_attr( $form_id ); ?>"
					data-required="<?php echo esc_attr( $field_settings['required'] ); ?>"
					data-type="text"
					name="<?php echo esc_attr( $field_settings['name'] ); ?>"
					placeholder="<?php echo esc_attr( $field_settings['format'] ); ?>"
					value="<?php echo esc_attr( $value ); ?>"
					size="30"
				/>
				<?php $this->help_text( $field_settings ); ?>
			</div>
		</li>
		<?php
			$name   = $field_settings['name'];
			$format = $field_settings['format'];

			if ( $field_settings['time'] == 'yes' ) {
				$script = "jQuery(function($) {
					$('#wpuf-date-{$name}').datetimepicker({ dateFormat: '{$format}' });
				});";
			} else {
				$script = "jQuery(function($) {
					$('#wpuf-date-{$name}').datepicker({ dateFormat: '{$format}' });
				});";
			}

			wp_add_inline_script( 'weforms-pro-frontend-scripts', $script );

	}

	/**
	 * Get field options setting
	 *
	 * @return array
	 */
	public function get_options_settings() {
		$default_options = is_array( $this->get_default_option_settings() ) ? $this->get_default_option_settings() : array();

		$settings = array(
			array(
				'name'      => 'format',
				'title'     => esc_html__( 'Date Format', 'wpuf-pro' ),
				'type'      => 'text',
				'section'   => 'advanced',
				'priority'  => 23,
				'help_text' => esc_html__( 'The date format', 'wpuf-pro' ),
			),
			array(
				'name'          => 'time',
				'title'         => '',
				'type'          => 'checkbox',
				'is_single_opt' => true,
				'options'       => array(
					'yes' => esc_html__( 'Enable time input', 'wpuf-pro' ),
				),
				'section'       => 'advanced',
				'priority'      => 24,
				'help_text'     => '',
			),
			array(
				'name'          => 'is_publish_time',
				'title'         => '',
				'type'          => 'checkbox',
				'is_single_opt' => true,
				'options'       => array(
					'yes' => esc_html__( 'Set this as publish time input', 'wpuf-pro' ),
				),
				'section'       => 'advanced',
				'priority'      => 24,
				'help_text'     => '',
			),
			array(
				'name'          => 'enforce_format',
				'title'         => __( 'Toggle Keyboard input for Date', 'weforms' ),
				'type'          => 'checkbox',
				'section'       => 'advanced',
				'is_single_opt' => true,
				'options'       => array(
					'yes' => esc_html__( 'Force Datepicker Input', 'weforms' ),
				),
				'default'       => 'yes',
				'priority'      => 24,
				'help_text'     => esc_html__( 'Disables Keyboard Input and uses the Datepicker Format', 'weforms' ),
			),
		);

		return array_merge( $default_options, $settings );
	}

	/**
	 * Get the field props
	 *
	 * @return array
	 */
	public function get_field_props() {
		$defaults = $this->default_attributes();
		$props    = array(
			'format'          => 'dd/mm/yy',
			'time'            => '',
			'is_publish_time' => '',
			'enforce_format'  => '',
		);

		return array_merge( $defaults, $props );
	}

	/**
	 * Prepare entry
	 *
	 * @param array $field field array.
	 * @param array $args arguments array.
	 *
	 * @return mixed
	 */
	public function prepare_entry( $field, $args = array() ) {
		$args = ! empty( $args ) ? $args : $_POST;

		return sanitize_text_field( trim( $args[ $field['name'] ] ) );
	}
}
