<?php

/**
 * File Field Class
 */
class WeForms_Form_Field_File extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'File Upload', 'weforms-pro' );
        $this->input_type = 'file_upload';
        $this->icon       = 'upload';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        $allowed_ext = '';
        $extensions  = weforms_allowed_extensions();
        $unique_id   = sprintf( '%s-%d', $field_settings['name'], $form_id );

        if ( is_array( $field_settings['extension'] ) ) {
            foreach ($field_settings['extension'] as $ext) {
                $allowed_ext .= $extensions[$ext]['ext'] . ',';
            }
        } else {
            $allowed_ext = '*';
        }
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings ); ?>

            <div class="wpuf-fields">
                <div id="wpuf-<?php echo $unique_id; ?>-upload-container">
                    <div class="wpuf-attachment-upload-filelist" data-type="file" data-required="<?php echo $field_settings['required']; ?>">
                        <a id="wpuf-<?php echo $unique_id; ?>-pickfiles" data-form_id="<?php echo $form_id; ?>" class="button file-selector <?php echo ' wpuf_'.$field_settings['name'].'_'.$form_id; ?>" href="#"><?php _e( 'Select File(s)', 'weforms-pro' ); ?></a>

                        <ul class="wpuf-attachment-list thumbnails"></ul>
                    </div>
                </div><!-- .container -->

                <?php $this->help_text( $field_settings ); ?>

            </div> <!-- .wpuf-fields -->
        </li>
        <?php
        $count       = $field_settings['count'];
        $name        = $field_settings['name'];
        $max_size    = $field_settings['max_size'];

        $script = ";(function($) {
            $(document).ready( function() {
                var uploader = new WPUF_Uploader(
                    'wpuf-{$unique_id}-pickfiles',
                    'wpuf-{$unique_id}-upload-container',
                    {$count},
                    '{$name}',
                    '{$allowed_ext}',
                    {$max_size}
                );
                wpuf_plupload_items.push(uploader);
            });
        })(jQuery);";

        wp_add_inline_script( 'weforms-pro-frontend-scripts', $script );
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options      = $this->get_default_option_settings( true, array('dynamic','width') );

        $settings = array(
            array(
                'name'          => 'max_size',
                'title'         => __( 'Max. file size', 'weforms-pro' ),
                'type'          => 'text',
                'variation'     => 'number',
                'section'       => 'advanced',
                'priority'      => 20,
                'help_text'     => __( 'Enter maximum upload size limit in KB', 'weforms-pro' ),
            ),

            array(
                'name'          => 'count',
                'title'         => __( 'Max. files', 'weforms-pro' ),
                'type'          => 'text',
                'variation'     => 'number',
                'section'       => 'advanced',
                'priority'      => 21,
                'help_text'     => __( 'Number of images can be uploaded', 'weforms-pro' ),
            ),

            array(
                'name'          => 'extension',
                'title'         => __( 'Allowed Files', 'weforms-pro' ),
                'title_class'   => 'label-hr',
                'type'          => 'checkbox',
                'options'       => array(
                    'images'    => __( 'Images (jpg, jpeg, gif, png, bmp)', 'weforms-pro' ),
                    'audio'     => __( 'Audio (mp3, wav, ogg, wma, mka, m4a, ra, mid, midi)', 'weforms-pro' ),
                    'video'     => __( 'Videos (avi, divx, flv, mov, ogv, mkv, mp4, m4v, divx, mpg, mpeg, mpe)', 'weforms-pro' ),
                    'pdf'       => __( 'PDF (pdf)', 'weforms-pro' ),
                    'office'    => __( 'Office Documents (doc, ppt, pps, xls, mdb, docx, xlsx, pptx, odt, odp, ods, odg, odc, odb, odf, rtf, txt)', 'weforms-pro' ),
                    'zip'       => __( 'Zip Archives (zip, gz, gzip, rar, 7z)', 'weforms-pro' ),
                    'exe'       => __( 'Executable Files (exe)', 'weforms-pro' ),
                    'csv'       => __( 'CSV (csv)', 'weforms-pro' ),
                ),
                'section'       => 'advanced',
                'priority'      => 22,
                'help_text'     => '',
            )
        );

        return array_merge( $default_options, $settings );
    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();
        $props    = array(
            'max_size'      => '1024',
            'count'         => '1',
            'extension'     => array( 'images', 'audio', 'video', 'pdf', 'office', 'zip', 'exe', 'csv' ),
        );

        return array_merge( $defaults, $props );
    }


    /**
     * Prepare entry
     *
     * @param $field
     *
     * @return mixed
     */
    public function prepare_entry( $field, $args = [] ) {
       $args = ! empty( $args ) ? $args : $_POST;

       return isset( $args['wpuf_files'][$field['name']] ) ? $args['wpuf_files'][$field['name']] : array();
    }
}
