<?php

/**
 * Text Field Class
 */
class WeForms_Form_Field_Linear_Scale extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'Linear Scale', 'weforms' );
        $this->input_type = 'linear_scale';
        $this->icon       = 'ellipsis-h';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings, $form_id ); ?>
            <div class="wpuf-fields" data-required="<?php echo $field_settings['required'] ?>" data-type="radio">
                <?php
                if ( $field_settings['scale_range'] && count( $field_settings['scale_range'] ) > 0 ) { ?>
                    <label><?php echo $field_settings['scale_text']['first'] ?></label>
                    <?php
                    for ($i=$field_settings['scale_range']['from']; $i <= $field_settings['scale_range']['to']; $i++) {
                        ?>
                        <label <?php echo $field_settings['inline'] == 'yes' ? 'class="wpuf-radio-inline"' : 'class="wpuf-radio-block"'; ?>>
                            <input
                                name="<?php echo $field_settings['name']; ?>"
                                class="<?php echo 'wpuf_'.$field_settings['name']. '_'. $form_id; ?>"
                                type="radio"
                                value="<?php echo esc_attr( $i ); ?>"
                            />
                            <?php echo $i; ?>
                        </label>
                        <?php
                    } ?>
                    <label><?php echo $field_settings['scale_text']['last'] ?></label>
                <?php
                }
                ?>

                <?php $this->help_text( $field_settings ); ?>

            </div>
        </li>
        <?php
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options = $this->get_default_option_settings( true, array( 'width' ) );

        $name_settings = array(
            array(
                'name'      => 'sub-labels',
                'title'     => __( 'Label', 'weforms' ),
                'type'      => 'linear',
                'section'   => 'advanced',
                'priority'  => 21,
                'help_text' => __( 'Select format to use for the name field', 'weforms' ),
            ),
            array(
                'name'          => 'inline',
                'title'         => __( 'Show in inline list', 'wpuf' ),
                'type'          => 'radio',
                'options'       => array(
                    'yes'   => __( 'Yes', 'wpuf' ),
                    'no'    => __( 'No', 'wpuf' ),
                ),
                'default'       => 'no',
                'inline'        => true,
                'section'       => 'advanced',
                'priority'      => 23,
                'help_text'     => __( 'Show this option in an inline list', 'wpuf' ),
            )
        );

        return array_merge( $default_options, $name_settings );
    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();
        $props    = array(
            'scale_range' => array(
                'from'  => 1,
                'to'    => 5
            ),
            'scale_text' => array(
                'first' => __( 'Very Bad', 'weforms' ),
                'last'  => __( 'Very Good', 'weforms' )
            ),
            'inline'           => 'yes'
        );

        return array_merge( $defaults, $props );
    }
}