<?php

/**
 * Numeric Field Class
 */
class WeForms_Form_Field_Numeric extends WeForms_Form_Field_Text {

    function __construct() {
        $this->name       = __( 'Numeric Field', 'weforms' );
        $this->input_type = 'numeric_text_field';
        $this->icon       = 'hashtag';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        $calculation_class = '';
        if ( isset( $field_settings['enable_calculation'] ) && $field_settings['enable_calculation'] && isset( $field_settings['formula_field'] ) && !empty( $field_settings['formula_field'] ) ) {
            $calculation_class = 'we-calc-result';
        }
        $value = $field_settings['default'];
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings ); ?>

            <div class="wpuf-fields wpuf-numeric_text_holder">
                <input
                    class="textfield <?php echo 'wpuf_'.$field_settings['name'].'_'.$form_id; ?> <?php echo $calculation_class ?>"
                    id="<?php echo $field_settings['name']; ?>"
                    type="number"
                    min="<?php echo $field_settings['min_value_field'];?>"
                    max="<?php echo $field_settings['max_value_field'] == 0 ? '' : $field_settings['max_value_field']; ?>"
                    step="<?php echo $field_settings['step_text_field']; ?>"
                    data-duplicate="<?php echo $field_settings['duplicate'] ? $field_settings['duplicate'] : 'no'; ?>"
                    data-required="<?php echo $field_settings['required'] ?>"
                    data-type="text" name="<?php echo esc_attr( $field_settings['name'] ); ?>"
                    placeholder="<?php echo esc_attr( $field_settings['placeholder'] ); ?>"
                    value="<?php echo esc_attr( $value ) ?>"
                    size="<?php echo esc_attr( $field_settings['size'] ) ?>" />

                <?php $this->help_text( $field_settings ); ?>
            </div>

        </li>
        <?php
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options = $this->get_default_option_settings();

        $settings = array(
            array(
                'name'          => 'step_text_field',
                'title'         => __( 'Step', 'wpuf-pro' ),
                'type'          => 'text',
                'variation'     => 'number',
                'section'       => 'advanced',
                'priority'      => 9,
                'help_text'     => '',
            ),

            array(
                'name'          => 'min_value_field',
                'title'         => __( 'Min Value', 'wpuf-pro' ),
                'type'          => 'text',
                'variation'     => 'number',
                'section'       => 'advanced',
                'priority'      => 11,
                'help_text'     => '',
            ),

            array(
                'name'          => 'max_value_field',
                'title'         => __( 'Max Value', 'wpuf-pro' ),
                'type'          => 'text',
                'variation'     => 'number',
                'section'       => 'advanced',
                'priority'      => 13,
                'help_text'     => '',
            ),

            array(
                'name'          => 'duplicate',
                'title'         => 'No Duplicates',
                'type'          => 'checkbox',
                'is_single_opt' => true,
                'options'       => array(
                    'no'   => __( 'Unique Values Only', 'weforms' )
                ),
                'default'       => '',
                'section'       => 'advanced',
                'priority'      => 23,
                'help_text'     => __( 'Select this option to limit user input to unique values only. This will require that a value entered in a field does not currently exist in the entry database for that field.', 'weforms' ),
            )
        );

        $numeric_options = array_merge( $default_options, $settings );

        return apply_filters( 'weforms_numeric_field_option_settings', $numeric_options );
    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();
        $props    = array(
            'step_text_field'   => '0',
            'min_value_field'   => '0',
            'max_value_field'   => '0',
            'duplicate'         => '',
        );

        $numeric_field_props = array_merge( $defaults, $props );

        return apply_filters( 'weforms_numeric_field_props', $numeric_field_props );
    }


    /**
     * Prepare entry
     *
     * @param $field
     *
     * @return mixed
     */
    public function prepare_entry( $field, $args = [] ) {
       $args = ! empty( $args ) ? $args : $_POST;

       return sanitize_text_field( trim( $args[$field['name']] ) );
    }
}
