<?php

/**
 * Text Field Class
 */
class WeForms_Form_Field_Phone extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'Phone', 'weforms' );
        $this->input_type = 'phone_field';
        $this->icon       = 'phone';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        $value = $field_settings['default'];
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings, $form_id ); ?>

            <div class="wpuf-fields">
                <input
                    class="phonefield <?php echo 'wpuf_' . $field_settings['name'] . '_' . $form_id; ?>"
                    id="<?php echo $field_settings['name'] . '_' . $form_id; ?>"
                    type="tel"
                    data-required="<?php echo $field_settings['required'] ?>"
                    data-type="text" name="<?php echo esc_attr( $field_settings['name'] ); ?>"
                    placeholder="<?php echo esc_attr( $field_settings['placeholder'] ); ?>"
                    value="<?php echo esc_attr( $value ) ?>"
                    size="<?php echo esc_attr( $field_settings['size'] ) ?>"
                />

                <span class="wpuf-wordlimit-message wpuf-help"></span>
                <?php $this->help_text( $field_settings ); ?>
            </div>

            <?php
                $name = esc_attr( $field_settings['name'] );
                $mask_option = !empty( $field_settings['mask_options'] ) ? $field_settings['mask_options'] : '';

                $script = "jQuery(document).ready(function($){
                    var phone_field = $( `input[name*={$name}]` );

                    if ( 'standard' == `{$mask_option}` ) {
                        phone_field.mask('(+999)-999-999999999');
                    } else if( 'standard_2' == `{$mask_option}` ) {
                        phone_field.mask('(+99)-999-999-99999999');
                    } else {
                        phone_field.mask('(+9)-999-999-99999999');
                    }
                });";

                wp_add_inline_script( 'wpuf-form', $script );
             ?>
        </li>
        <?php
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options      = $this->get_default_option_settings();
        $check_duplicate      = array(
            array(
                'name'          => 'duplicate',
                'title'         => 'No Duplicates',
                'type'          => 'checkbox',
                'is_single_opt' => true,
                'options'       => array(
                    'no'   => __( 'Unique Values Only', 'weforms' )
                ),
                'default'       => '',
                'section'       => 'advanced',
                'priority'      => 23,
                'help_text'     => __( 'Select this option to limit user input to unique values only. This will require that a value entered in a field does not currently exist in the entry database for that field.', 'weforms' ),
            )
        );
        $mask_options           = array(
            array(
                'name'      => 'mask_options',
                'title'     => 'Mask Options',
                'type'      => 'select',
                'options'   => array(
                    'standard'      => __( '(+###) ###-####', 'weforms' ),
                    'standard_2'    => __( '(+##) ###-####', 'weforms' ),
                    'international' => __( 'International', 'weforms' ),
                ),
                'default'   => '',
                'section'   => 'advanced',
                'priority'  => 23,
                'help_text' => __( 'Select this option to add masking to phone field.', 'weforms' ),
            )
        );
        return array_merge( $default_options, $check_duplicate, $mask_options );
    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();

        return $defaults;
    }

    /**
     * Prepare entry
     *
     * @param $field
     *
     * @return mixed
     */
    public function prepare_entry( $field, $args = [] ) {
       $args = ! empty( $args ) ? $args : $_POST;

       return sanitize_text_field( trim( $args[$field['name']] ) );
    }
}
