<?php

/**
 * Rating Field Class
 */
class WeForms_Form_Field_Rating extends WeForms_Form_Field_Dropdown {

    function __construct() {
        $this->name       = __( 'Ratings', 'weforms' );
        $this->input_type = 'ratings';
        $this->icon       = 'star-half-o';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        $value = '';
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings ); ?>

            <div class="wpuf-fields <?php echo ' wpuf_'.$field_settings['name'].'_'.$form_id; ?>">
                <select name="<?php echo $field_settings['name']; ?>" class="wpuf-ratings">
                    <?php foreach( $field_settings['options'] as $key => $option ) : ?>
                        <option value="<?php echo $key; ?>" <?php  echo $key == $value ? 'selected' : '' ; ?> ><?php echo $option; ?></option>
                    <?php endforeach; ?>
                </select>

                <?php $this->help_text( $field_settings ); ?>
            </div>

        </li>
        <?php

        $script = ";(function($) {
                    $('.wpuf-ratings').barrating({
                        theme: 'css-stars'
                    });
                    $(document).ready(function() {
                        $('.br-widget a').removeClass('br-selected');
                    });
        })(jQuery);";

        wp_add_inline_script( 'weforms-pro-frontend-scripts', $script );

    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();
        $props    = array(
            'selected' => '',
            'options'  => array(
                '1' => __( '1', 'wpuf' ),
                '2' => __( '2', 'wpuf' ),
                '3' => __( '3', 'wpuf' ),
                '4' => __( '4', 'wpuf' ),
                '5' => __( '5', 'wpuf' )
            ),
        );

        return array_merge( $defaults, $props );
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options          = $this->get_default_option_settings( true, array( 'width' ) );
        $default_dropdown_options = array( $this->get_default_option_dropdown_settings() );

        return array_merge( $default_options, $default_dropdown_options );
    }

}
