<?php

/**
 * Repeat Field Class
 */
class WeForms_Form_Field_Repeat extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'Repeat Field', 'weforms' );
        $this->input_type = 'repeat_field';
        $this->icon       = 'text-width';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        $add    = plugins_url( 'assets/images/add.png', WEFORMS_FILE );
        $remove = plugins_url( 'assets/images/remove.png', WEFORMS_FILE );
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings ); ?>

            <div class="wpuf-fields <?php echo ' wpuf_'.$field_settings['name'].'_'.$form_id; ?>">

                <?php if ( isset( $field_settings['multiple'] ) && '' != $field_settings['multiple'] ) { ?>
                    <table>
                        <thead>
                        <tr>
                            <?php
                            $num_columns = count( $field_settings['columns'] );
                            foreach ($field_settings['columns'] as $column) {
                                ?>
                                <th>
                                    <?php echo $column; ?>
                                </th>
                            <?php } ?>

                            <th style="visibility: hidden;">
                                Actions
                            </th>
                        </tr>

                        </thead>
                        <tbody>

                            <tr>
                                <?php for ($count = 0; $count < $num_columns; $count++) { ?>
                                    <td>
                                        <input type="text" name="<?php echo $field_settings['name'] . '[' . $count . ']'; ?>[]" size="<?php echo esc_attr( $field_settings['size'] ) ?>" data-required="<?php echo $field_settings['required'] ?>" data-type="text" />
                                    </td>
                                <?php } ?>
                                <td>
                                    <img class="wpuf-clone-field" alt="<?php esc_attr_e( 'Add another', 'wpuf-pro' ); ?>" title="<?php esc_attr_e( 'Add another', 'wpuf-pro' ); ?>" src="<?php echo $add; ?>">
                                    <img class="wpuf-remove-field" alt="<?php esc_attr_e( 'Remove this choice', 'wpuf-pro' ); ?>" title="<?php esc_attr_e( 'Remove this choice', 'wpuf-pro' ); ?>" src="<?php echo $remove; ?>">
                                </td>
                            </tr>

                        </tbody>
                    </table>

                <?php } else { ?>


                    <table>

                            <tr>
                                <td>
                                    <input id="wpuf-<?php echo $field_settings['name']; ?>" type="text" data-required="<?php echo $field_settings['required'] ?>" data-type="text" name="<?php echo esc_attr( $field_settings['name'] ); ?>[]" placeholder="<?php echo esc_attr( $field_settings['placeholder'] ); ?>" value="<?php echo esc_attr( $field_settings['default'] ) ?>" size="<?php echo esc_attr( $field_settings['size'] ) ?>" />
                                </td>
                                <td>
                                    <img style="cursor:pointer; margin:0 3px;" alt="add another choice" title="add another choice" class="wpuf-clone-field" src="<?php echo $add; ?>">
                                    <img style="cursor:pointer;" class="wpuf-remove-field" alt="remove this choice" title="remove this choice" src="<?php echo $remove; ?>">
                                </td>
                            </tr>

                    </table>
                <?php } ?>
                <?php $this->help_text( $field_settings ); ?>
            </div>

        </li>
        <?php
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options      = $this->get_default_option_settings( true, array( 'width' ) );

        $settings = array(
            array(
                'name'          => 'multiple',
                'title'         => __( 'Multiple Column', 'wpuf-pro' ),
                'type'          => 'checkbox',
                'is_single_opt' => true,
                'options'       => array(
                    'true'   => __( 'Enable Multi Column', 'wpuf-pro' )
                ),
                'section'       => 'advanced',
                'priority'      => 23,
                'help_text'     => '',
            ),

            array(
                'name'          => 'columns',
                'title'         => __( 'Columns', 'wpuf-pro' ),
                'type'          => 'repeater-columns',
                'section'       => 'advanced',
                'priority'      => 24,
                'help_text'     => '',
                'dependencies' => array(
                    'multiple' => 'true'
                )
            ),

            array(
                'name'         => 'placeholder',
                'title'        => __( 'Placeholder text', 'wpuf-pro' ),
                'type'         => 'text',
                'section'      => 'advanced',
                'priority'     => 24,
                'help_text'    => __( 'Text for HTML5 placeholder attribute', 'wpuf-pro' ),
                'dependencies' => array(
                    'multiple' => ''
                )
            ),

            array(
                'name'         => 'default',
                'title'        => __( 'Default value', 'wpuf-pro' ),
                'type'         => 'text',
                'section'      => 'advanced',
                'priority'     => 25,
                'help_text'    => __( 'The default value this field will have', 'wpuf-pro' ),
                'dependencies' => array(
                    'multiple' => ''
                )
            ),

            array(
                'name'         => 'size',
                'title'        => __( 'Size', 'wpuf-pro' ),
                'type'         => 'text',
                'section'      => 'advanced',
                'priority'     => 26,
                'help_text'    => __( 'Size of this input field', 'wpuf-pro' )
            ),
        );

        return array_merge( $default_options, $settings );
    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();
        $props    = array(
            'multiple' => '',
            'columns'  => array( __( 'Column 1', 'wpuf-pro' ) ),
        );

        return array_merge( $defaults, $props );
    }

    /**
     * Prepare entry
     *
     * @param $field
     *
     * @return mixed
     */
    public function prepare_entry( $field, $args = [] ) {
       $args = ! empty( $args ) ? $args : $_POST;

        $entry_value = '';

        // if it is a multi column repeat field

        if ( isset( $field['multiple'] ) && $field['multiple'] == 'true' ) {

            // if there's any items in the array, process it
            if ( $args[$field['name']] ) {

                $ref_arr = array();
                $cols    = count( $field['columns'] );
                $first   = array_shift( array_values( $args[$field['name']] ) ); //first element
                $rows    = count( $first );

                // loop through columns
                for ($i = 0; $i < $rows; $i++) {
                    // loop through the rows and store in a temp array
                    $temp = array();

                    for ($j = 0; $j < $cols; $j++) {
                        $temp[] = $args[$field['name']][$j][$i];
                    }

                    // store all fields in a row with WeForms::$field_separator separated
                    $ref_arr[] = implode( WeForms::$field_separator, $temp );
                }

                // now, if we found anything in $ref_arr, store to $multi_repeated
                if ( $ref_arr ) {
                    $multi_repeated[$field['name']] = array_slice( $ref_arr, 0, $rows );
                }

                $entry_value = $multi_repeated[$field['name']];
                $entry_value = implode( ', ', $entry_value );
            }
        } else {
            $entry_value = implode( WeForms::$field_separator, $args[$field['name']] );
        }

        return sanitize_text_field(trim($entry_value) );

    }
}
